/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.common.util.collections.ConcurrentLongPairSet;
import org.apache.pulsar.common.util.collections.LongPairSet;

public class ConcurrentSortedLongPairSet
implements LongPairSet {
    protected final NavigableMap<Long, ConcurrentLongPairSet> longPairSets = new ConcurrentSkipListMap<Long, ConcurrentLongPairSet>();
    private int expectedItems;
    private int concurrencyLevel;
    private int maxAllowedSetOnRemove;
    private static final int DEFAULT_MAX_ALLOWED_SET_ON_REMOVE = 10;

    public ConcurrentSortedLongPairSet() {
        this(16, 1, 10);
    }

    public ConcurrentSortedLongPairSet(int expectedItems) {
        this(expectedItems, 1, 10);
    }

    public ConcurrentSortedLongPairSet(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 10);
    }

    public ConcurrentSortedLongPairSet(int expectedItems, int concurrencyLevel, int maxAllowedSetOnRemove) {
        this.expectedItems = expectedItems;
        this.concurrencyLevel = concurrencyLevel;
        this.maxAllowedSetOnRemove = maxAllowedSetOnRemove;
    }

    @Override
    public boolean add(long item1, long item2) {
        ConcurrentLongPairSet messagesToReplay = this.longPairSets.computeIfAbsent(item1, key -> new ConcurrentLongPairSet(this.expectedItems, this.concurrencyLevel));
        return messagesToReplay.add(item1, item2);
    }

    @Override
    public boolean remove(long item1, long item2) {
        ConcurrentLongPairSet messagesToReplay = (ConcurrentLongPairSet)this.longPairSets.get(item1);
        if (messagesToReplay != null) {
            boolean removed = messagesToReplay.remove(item1, item2);
            if (messagesToReplay.isEmpty() && this.longPairSets.size() > this.maxAllowedSetOnRemove) {
                this.longPairSets.remove(item1, messagesToReplay);
            }
            return removed;
        }
        return false;
    }

    @Override
    public int removeIf(LongPairSet.LongPairPredicate filter) {
        AtomicInteger removedValues = new AtomicInteger(0);
        this.longPairSets.forEach((? super K item1, ? super V longPairSet) -> {
            removedValues.addAndGet(longPairSet.removeIf(filter));
            if (longPairSet.isEmpty() && this.longPairSets.size() > this.maxAllowedSetOnRemove) {
                this.longPairSets.remove(item1, longPairSet);
            }
        });
        return removedValues.get();
    }

    @Override
    public Set<ConcurrentLongPairSet.LongPair> items() {
        return this.items((int)this.size());
    }

    @Override
    public void forEach(ConcurrentLongPairSet.LongPairConsumer processor) {
        for (Long item1 : this.longPairSets.navigableKeySet()) {
            ConcurrentLongPairSet messagesToReplay = (ConcurrentLongPairSet)this.longPairSets.get(item1);
            messagesToReplay.forEach((i1, i2) -> processor.accept(i1, i2));
        }
    }

    @Override
    public Set<ConcurrentLongPairSet.LongPair> items(int numberOfItems) {
        return this.items(numberOfItems, (item1, item2) -> new ConcurrentLongPairSet.LongPair(item1, item2));
    }

    @Override
    public <T> Set<T> items(int numberOfItems, LongPairSet.LongPairFunction<T> longPairConverter) {
        TreeSet items = new TreeSet();
        AtomicInteger count = new AtomicInteger(0);
        for (Long item1 : this.longPairSets.navigableKeySet()) {
            if (count.get() >= numberOfItems) break;
            ConcurrentLongPairSet messagesToReplay = (ConcurrentLongPairSet)this.longPairSets.get(item1);
            messagesToReplay.forEach((i1, i2) -> {
                if (count.get() < numberOfItems) {
                    items.add(longPairConverter.apply(i1, i2));
                    count.incrementAndGet();
                }
            });
        }
        return items;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        AtomicBoolean first = new AtomicBoolean(true);
        this.longPairSets.forEach((? super K key, ? super V longPairSet) -> longPairSet.forEach((item1, item2) -> {
            if (!first.getAndSet(false)) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(item1);
            sb.append(':');
            sb.append(item2);
            sb.append(']');
        }));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        this.longPairSets.forEach((? super K item1, ? super V longPairSet) -> {
            if (isEmpty.get() && !longPairSet.isEmpty()) {
                isEmpty.set(false);
            }
        });
        return isEmpty.get();
    }

    @Override
    public void clear() {
        this.longPairSets.clear();
    }

    @Override
    public long size() {
        AtomicLong size = new AtomicLong(0L);
        this.longPairSets.forEach((? super K item1, ? super V longPairSet) -> size.getAndAdd(longPairSet.size()));
        return size.get();
    }

    @Override
    public boolean contains(long item1, long item2) {
        ConcurrentLongPairSet longPairSet = (ConcurrentLongPairSet)this.longPairSets.get(item1);
        if (longPairSet != null) {
            return longPairSet.contains(item1, item2);
        }
        return false;
    }
}

