package apache.rocketmq.v2;

import static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * For all the RPCs in MessagingService, the following error handling policies
 * apply:
 * If the request doesn't bear a valid authentication credential, return a
 * response with common.status.code == `UNAUTHENTICATED`. If the authenticated
 * user is not granted with sufficient permission to execute the requested
 * operation, return a response with common.status.code == `PERMISSION_DENIED`.
 * If the per-user-resource-based quota is exhausted, return a response with
 * common.status.code == `RESOURCE_EXHAUSTED`. If any unexpected server-side
 * errors raise, return a response with common.status.code == `INTERNAL`.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.47.0)",
    comments = "Source: apache/rocketmq/v2/service.proto")
@org.apache.rocketmq.shaded.io.grpc.stub.annotations.GrpcGenerated
public final class MessagingServiceGrpc {

  private MessagingServiceGrpc() {}

  public static final String SERVICE_NAME = "apache.rocketmq.v2.MessagingService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.QueryRouteRequest,
      apache.rocketmq.v2.QueryRouteResponse> getQueryRouteMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "QueryRoute",
      requestType = apache.rocketmq.v2.QueryRouteRequest.class,
      responseType = apache.rocketmq.v2.QueryRouteResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.QueryRouteRequest,
      apache.rocketmq.v2.QueryRouteResponse> getQueryRouteMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.QueryRouteRequest, apache.rocketmq.v2.QueryRouteResponse> getQueryRouteMethod;
    if ((getQueryRouteMethod = MessagingServiceGrpc.getQueryRouteMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getQueryRouteMethod = MessagingServiceGrpc.getQueryRouteMethod) == null) {
          MessagingServiceGrpc.getQueryRouteMethod = getQueryRouteMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.QueryRouteRequest, apache.rocketmq.v2.QueryRouteResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "QueryRoute"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.QueryRouteRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.QueryRouteResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("QueryRoute"))
              .build();
        }
      }
    }
    return getQueryRouteMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.HeartbeatRequest,
      apache.rocketmq.v2.HeartbeatResponse> getHeartbeatMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Heartbeat",
      requestType = apache.rocketmq.v2.HeartbeatRequest.class,
      responseType = apache.rocketmq.v2.HeartbeatResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.HeartbeatRequest,
      apache.rocketmq.v2.HeartbeatResponse> getHeartbeatMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.HeartbeatRequest, apache.rocketmq.v2.HeartbeatResponse> getHeartbeatMethod;
    if ((getHeartbeatMethod = MessagingServiceGrpc.getHeartbeatMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getHeartbeatMethod = MessagingServiceGrpc.getHeartbeatMethod) == null) {
          MessagingServiceGrpc.getHeartbeatMethod = getHeartbeatMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.HeartbeatRequest, apache.rocketmq.v2.HeartbeatResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Heartbeat"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.HeartbeatRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.HeartbeatResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("Heartbeat"))
              .build();
        }
      }
    }
    return getHeartbeatMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.SendMessageRequest,
      apache.rocketmq.v2.SendMessageResponse> getSendMessageMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SendMessage",
      requestType = apache.rocketmq.v2.SendMessageRequest.class,
      responseType = apache.rocketmq.v2.SendMessageResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.SendMessageRequest,
      apache.rocketmq.v2.SendMessageResponse> getSendMessageMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.SendMessageRequest, apache.rocketmq.v2.SendMessageResponse> getSendMessageMethod;
    if ((getSendMessageMethod = MessagingServiceGrpc.getSendMessageMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getSendMessageMethod = MessagingServiceGrpc.getSendMessageMethod) == null) {
          MessagingServiceGrpc.getSendMessageMethod = getSendMessageMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.SendMessageRequest, apache.rocketmq.v2.SendMessageResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SendMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.SendMessageRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.SendMessageResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("SendMessage"))
              .build();
        }
      }
    }
    return getSendMessageMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.QueryAssignmentRequest,
      apache.rocketmq.v2.QueryAssignmentResponse> getQueryAssignmentMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "QueryAssignment",
      requestType = apache.rocketmq.v2.QueryAssignmentRequest.class,
      responseType = apache.rocketmq.v2.QueryAssignmentResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.QueryAssignmentRequest,
      apache.rocketmq.v2.QueryAssignmentResponse> getQueryAssignmentMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.QueryAssignmentRequest, apache.rocketmq.v2.QueryAssignmentResponse> getQueryAssignmentMethod;
    if ((getQueryAssignmentMethod = MessagingServiceGrpc.getQueryAssignmentMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getQueryAssignmentMethod = MessagingServiceGrpc.getQueryAssignmentMethod) == null) {
          MessagingServiceGrpc.getQueryAssignmentMethod = getQueryAssignmentMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.QueryAssignmentRequest, apache.rocketmq.v2.QueryAssignmentResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "QueryAssignment"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.QueryAssignmentRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.QueryAssignmentResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("QueryAssignment"))
              .build();
        }
      }
    }
    return getQueryAssignmentMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ReceiveMessageRequest,
      apache.rocketmq.v2.ReceiveMessageResponse> getReceiveMessageMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ReceiveMessage",
      requestType = apache.rocketmq.v2.ReceiveMessageRequest.class,
      responseType = apache.rocketmq.v2.ReceiveMessageResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ReceiveMessageRequest,
      apache.rocketmq.v2.ReceiveMessageResponse> getReceiveMessageMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ReceiveMessageRequest, apache.rocketmq.v2.ReceiveMessageResponse> getReceiveMessageMethod;
    if ((getReceiveMessageMethod = MessagingServiceGrpc.getReceiveMessageMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getReceiveMessageMethod = MessagingServiceGrpc.getReceiveMessageMethod) == null) {
          MessagingServiceGrpc.getReceiveMessageMethod = getReceiveMessageMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.ReceiveMessageRequest, apache.rocketmq.v2.ReceiveMessageResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ReceiveMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.ReceiveMessageRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.ReceiveMessageResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("ReceiveMessage"))
              .build();
        }
      }
    }
    return getReceiveMessageMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.AckMessageRequest,
      apache.rocketmq.v2.AckMessageResponse> getAckMessageMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AckMessage",
      requestType = apache.rocketmq.v2.AckMessageRequest.class,
      responseType = apache.rocketmq.v2.AckMessageResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.AckMessageRequest,
      apache.rocketmq.v2.AckMessageResponse> getAckMessageMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.AckMessageRequest, apache.rocketmq.v2.AckMessageResponse> getAckMessageMethod;
    if ((getAckMessageMethod = MessagingServiceGrpc.getAckMessageMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getAckMessageMethod = MessagingServiceGrpc.getAckMessageMethod) == null) {
          MessagingServiceGrpc.getAckMessageMethod = getAckMessageMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.AckMessageRequest, apache.rocketmq.v2.AckMessageResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AckMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.AckMessageRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.AckMessageResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("AckMessage"))
              .build();
        }
      }
    }
    return getAckMessageMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest,
      apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse> getForwardMessageToDeadLetterQueueMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ForwardMessageToDeadLetterQueue",
      requestType = apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest.class,
      responseType = apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest,
      apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse> getForwardMessageToDeadLetterQueueMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest, apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse> getForwardMessageToDeadLetterQueueMethod;
    if ((getForwardMessageToDeadLetterQueueMethod = MessagingServiceGrpc.getForwardMessageToDeadLetterQueueMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getForwardMessageToDeadLetterQueueMethod = MessagingServiceGrpc.getForwardMessageToDeadLetterQueueMethod) == null) {
          MessagingServiceGrpc.getForwardMessageToDeadLetterQueueMethod = getForwardMessageToDeadLetterQueueMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest, apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ForwardMessageToDeadLetterQueue"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("ForwardMessageToDeadLetterQueue"))
              .build();
        }
      }
    }
    return getForwardMessageToDeadLetterQueueMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.EndTransactionRequest,
      apache.rocketmq.v2.EndTransactionResponse> getEndTransactionMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "EndTransaction",
      requestType = apache.rocketmq.v2.EndTransactionRequest.class,
      responseType = apache.rocketmq.v2.EndTransactionResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.EndTransactionRequest,
      apache.rocketmq.v2.EndTransactionResponse> getEndTransactionMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.EndTransactionRequest, apache.rocketmq.v2.EndTransactionResponse> getEndTransactionMethod;
    if ((getEndTransactionMethod = MessagingServiceGrpc.getEndTransactionMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getEndTransactionMethod = MessagingServiceGrpc.getEndTransactionMethod) == null) {
          MessagingServiceGrpc.getEndTransactionMethod = getEndTransactionMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.EndTransactionRequest, apache.rocketmq.v2.EndTransactionResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "EndTransaction"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.EndTransactionRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.EndTransactionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("EndTransaction"))
              .build();
        }
      }
    }
    return getEndTransactionMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.TelemetryCommand,
      apache.rocketmq.v2.TelemetryCommand> getTelemetryMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Telemetry",
      requestType = apache.rocketmq.v2.TelemetryCommand.class,
      responseType = apache.rocketmq.v2.TelemetryCommand.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.TelemetryCommand,
      apache.rocketmq.v2.TelemetryCommand> getTelemetryMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.TelemetryCommand, apache.rocketmq.v2.TelemetryCommand> getTelemetryMethod;
    if ((getTelemetryMethod = MessagingServiceGrpc.getTelemetryMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getTelemetryMethod = MessagingServiceGrpc.getTelemetryMethod) == null) {
          MessagingServiceGrpc.getTelemetryMethod = getTelemetryMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.TelemetryCommand, apache.rocketmq.v2.TelemetryCommand>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Telemetry"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.TelemetryCommand.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.TelemetryCommand.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("Telemetry"))
              .build();
        }
      }
    }
    return getTelemetryMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.NotifyClientTerminationRequest,
      apache.rocketmq.v2.NotifyClientTerminationResponse> getNotifyClientTerminationMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "NotifyClientTermination",
      requestType = apache.rocketmq.v2.NotifyClientTerminationRequest.class,
      responseType = apache.rocketmq.v2.NotifyClientTerminationResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.NotifyClientTerminationRequest,
      apache.rocketmq.v2.NotifyClientTerminationResponse> getNotifyClientTerminationMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.NotifyClientTerminationRequest, apache.rocketmq.v2.NotifyClientTerminationResponse> getNotifyClientTerminationMethod;
    if ((getNotifyClientTerminationMethod = MessagingServiceGrpc.getNotifyClientTerminationMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getNotifyClientTerminationMethod = MessagingServiceGrpc.getNotifyClientTerminationMethod) == null) {
          MessagingServiceGrpc.getNotifyClientTerminationMethod = getNotifyClientTerminationMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.NotifyClientTerminationRequest, apache.rocketmq.v2.NotifyClientTerminationResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "NotifyClientTermination"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.NotifyClientTerminationRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.NotifyClientTerminationResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("NotifyClientTermination"))
              .build();
        }
      }
    }
    return getNotifyClientTerminationMethod;
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ChangeInvisibleDurationRequest,
      apache.rocketmq.v2.ChangeInvisibleDurationResponse> getChangeInvisibleDurationMethod;

  @org.apache.rocketmq.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ChangeInvisibleDuration",
      requestType = apache.rocketmq.v2.ChangeInvisibleDurationRequest.class,
      responseType = apache.rocketmq.v2.ChangeInvisibleDurationResponse.class,
      methodType = org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ChangeInvisibleDurationRequest,
      apache.rocketmq.v2.ChangeInvisibleDurationResponse> getChangeInvisibleDurationMethod() {
    org.apache.rocketmq.shaded.io.grpc.MethodDescriptor<apache.rocketmq.v2.ChangeInvisibleDurationRequest, apache.rocketmq.v2.ChangeInvisibleDurationResponse> getChangeInvisibleDurationMethod;
    if ((getChangeInvisibleDurationMethod = MessagingServiceGrpc.getChangeInvisibleDurationMethod) == null) {
      synchronized (MessagingServiceGrpc.class) {
        if ((getChangeInvisibleDurationMethod = MessagingServiceGrpc.getChangeInvisibleDurationMethod) == null) {
          MessagingServiceGrpc.getChangeInvisibleDurationMethod = getChangeInvisibleDurationMethod =
              org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.<apache.rocketmq.v2.ChangeInvisibleDurationRequest, apache.rocketmq.v2.ChangeInvisibleDurationResponse>newBuilder()
              .setType(org.apache.rocketmq.shaded.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ChangeInvisibleDuration"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.ChangeInvisibleDurationRequest.getDefaultInstance()))
              .setResponseMarshaller(org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  apache.rocketmq.v2.ChangeInvisibleDurationResponse.getDefaultInstance()))
              .setSchemaDescriptor(new MessagingServiceMethodDescriptorSupplier("ChangeInvisibleDuration"))
              .build();
        }
      }
    }
    return getChangeInvisibleDurationMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static MessagingServiceStub newStub(org.apache.rocketmq.shaded.io.grpc.Channel channel) {
    org.apache.rocketmq.shaded.io.grpc.stub.AbstractStub.StubFactory<MessagingServiceStub> factory =
      new org.apache.rocketmq.shaded.io.grpc.stub.AbstractStub.StubFactory<MessagingServiceStub>() {
        @java.lang.Override
        public MessagingServiceStub newStub(org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
          return new MessagingServiceStub(channel, callOptions);
        }
      };
    return MessagingServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static MessagingServiceBlockingStub newBlockingStub(
      org.apache.rocketmq.shaded.io.grpc.Channel channel) {
    org.apache.rocketmq.shaded.io.grpc.stub.AbstractStub.StubFactory<MessagingServiceBlockingStub> factory =
      new org.apache.rocketmq.shaded.io.grpc.stub.AbstractStub.StubFactory<MessagingServiceBlockingStub>() {
        @java.lang.Override
        public MessagingServiceBlockingStub newStub(org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
          return new MessagingServiceBlockingStub(channel, callOptions);
        }
      };
    return MessagingServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static MessagingServiceFutureStub newFutureStub(
      org.apache.rocketmq.shaded.io.grpc.Channel channel) {
    org.apache.rocketmq.shaded.io.grpc.stub.AbstractStub.StubFactory<MessagingServiceFutureStub> factory =
      new org.apache.rocketmq.shaded.io.grpc.stub.AbstractStub.StubFactory<MessagingServiceFutureStub>() {
        @java.lang.Override
        public MessagingServiceFutureStub newStub(org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
          return new MessagingServiceFutureStub(channel, callOptions);
        }
      };
    return MessagingServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * For all the RPCs in MessagingService, the following error handling policies
   * apply:
   * If the request doesn't bear a valid authentication credential, return a
   * response with common.status.code == `UNAUTHENTICATED`. If the authenticated
   * user is not granted with sufficient permission to execute the requested
   * operation, return a response with common.status.code == `PERMISSION_DENIED`.
   * If the per-user-resource-based quota is exhausted, return a response with
   * common.status.code == `RESOURCE_EXHAUSTED`. If any unexpected server-side
   * errors raise, return a response with common.status.code == `INTERNAL`.
   * </pre>
   */
  public static abstract class MessagingServiceImplBase implements org.apache.rocketmq.shaded.io.grpc.BindableService {

    /**
     * <pre>
     * Queries the route entries of the requested topic in the perspective of the
     * given endpoints. On success, servers should return a collection of
     * addressable message-queues. Note servers may return customized route
     * entries based on endpoints provided.
     * If the requested topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public void queryRoute(apache.rocketmq.v2.QueryRouteRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.QueryRouteResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getQueryRouteMethod(), responseObserver);
    }

    /**
     * <pre>
     * Producer or consumer sends HeartbeatRequest to servers periodically to
     * keep-alive. Additionally, it also reports client-side configuration,
     * including topic subscription, load-balancing group name, etc.
     * Returns `OK` if success.
     * If a client specifies a language that is not yet supported by servers,
     * returns `INVALID_ARGUMENT`
     * </pre>
     */
    public void heartbeat(apache.rocketmq.v2.HeartbeatRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.HeartbeatResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getHeartbeatMethod(), responseObserver);
    }

    /**
     * <pre>
     * Delivers messages to brokers.
     * Clients may further:
     * 1. Refine a message destination to message-queues which fulfills parts of
     * FIFO semantic;
     * 2. Flag a message as transactional, which keeps it invisible to consumers
     * until it commits;
     * 3. Time a message, making it invisible to consumers till specified
     * time-point;
     * 4. And more...
     * Returns message-id or transaction-id with status `OK` on success.
     * If the destination topic doesn't exist, returns `NOT_FOUND`.
     * </pre>
     */
    public void sendMessage(apache.rocketmq.v2.SendMessageRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.SendMessageResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSendMessageMethod(), responseObserver);
    }

    /**
     * <pre>
     * Queries the assigned route info of a topic for current consumer,
     * the returned assignment result is decided by server-side load balancer.
     * If the corresponding topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public void queryAssignment(apache.rocketmq.v2.QueryAssignmentRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.QueryAssignmentResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getQueryAssignmentMethod(), responseObserver);
    }

    /**
     * <pre>
     * Receives messages from the server in batch manner, returns a set of
     * messages if success. The received messages should be acked or redelivered
     * after processed.
     * If the pending concurrent receive requests exceed the quota of the given
     * consumer group, returns `UNAVAILABLE`. If the upstream store server hangs,
     * return `DEADLINE_EXCEEDED` in a timely manner. If the corresponding topic
     * or consumer group doesn't exist, returns `NOT_FOUND`. If there is no new
     * message in the specific topic, returns `OK` with an empty message set.
     * Please note that client may suffer from false empty responses.
     * If failed to receive message from remote, server must return only one
     * `ReceiveMessageResponse` as the reply to the request, whose `Status` indicates
     * the specific reason of failure, otherwise, the reply is considered successful.
     * </pre>
     */
    public void receiveMessage(apache.rocketmq.v2.ReceiveMessageRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ReceiveMessageResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReceiveMessageMethod(), responseObserver);
    }

    /**
     * <pre>
     * Acknowledges the message associated with the `receipt_handle` or `offset`
     * in the `AckMessageRequest`, it means the message has been successfully
     * processed. Returns `OK` if the message server remove the relevant message
     * successfully.
     * If the given receipt_handle is illegal or out of date, returns
     * `INVALID_ARGUMENT`.
     * </pre>
     */
    public void ackMessage(apache.rocketmq.v2.AckMessageRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.AckMessageResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getAckMessageMethod(), responseObserver);
    }

    /**
     * <pre>
     * Forwards one message to dead letter queue if the max delivery attempts is
     * exceeded by this message at client-side, return `OK` if success.
     * </pre>
     */
    public void forwardMessageToDeadLetterQueue(apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getForwardMessageToDeadLetterQueueMethod(), responseObserver);
    }

    /**
     * <pre>
     * Commits or rollback one transactional message.
     * </pre>
     */
    public void endTransaction(apache.rocketmq.v2.EndTransactionRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.EndTransactionResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getEndTransactionMethod(), responseObserver);
    }

    /**
     * <pre>
     * Once a client starts, it would immediately establishes bi-lateral stream
     * RPCs with brokers, reporting its settings as the initiative command.
     * When servers have need of inspecting client status, they would issue
     * telemetry commands to clients. After executing received instructions,
     * clients shall report command execution results through client-side streams.
     * </pre>
     */
    public org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.TelemetryCommand> telemetry(
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.TelemetryCommand> responseObserver) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getTelemetryMethod(), responseObserver);
    }

    /**
     * <pre>
     * Notify the server that the client is terminated.
     * </pre>
     */
    public void notifyClientTermination(apache.rocketmq.v2.NotifyClientTerminationRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.NotifyClientTerminationResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getNotifyClientTerminationMethod(), responseObserver);
    }

    /**
     * <pre>
     * Once a message is retrieved from consume queue on behalf of the group, it
     * will be kept invisible to other clients of the same group for a period of
     * time. The message is supposed to be processed within the invisible
     * duration. If the client, which is in charge of the invisible message, is
     * not capable of processing the message timely, it may use
     * ChangeInvisibleDuration to lengthen invisible duration.
     * </pre>
     */
    public void changeInvisibleDuration(apache.rocketmq.v2.ChangeInvisibleDurationRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ChangeInvisibleDurationResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getChangeInvisibleDurationMethod(), responseObserver);
    }

    @java.lang.Override public final org.apache.rocketmq.shaded.io.grpc.ServerServiceDefinition bindService() {
      return org.apache.rocketmq.shaded.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getQueryRouteMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.QueryRouteRequest,
                apache.rocketmq.v2.QueryRouteResponse>(
                  this, METHODID_QUERY_ROUTE)))
          .addMethod(
            getHeartbeatMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.HeartbeatRequest,
                apache.rocketmq.v2.HeartbeatResponse>(
                  this, METHODID_HEARTBEAT)))
          .addMethod(
            getSendMessageMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.SendMessageRequest,
                apache.rocketmq.v2.SendMessageResponse>(
                  this, METHODID_SEND_MESSAGE)))
          .addMethod(
            getQueryAssignmentMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.QueryAssignmentRequest,
                apache.rocketmq.v2.QueryAssignmentResponse>(
                  this, METHODID_QUERY_ASSIGNMENT)))
          .addMethod(
            getReceiveMessageMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                apache.rocketmq.v2.ReceiveMessageRequest,
                apache.rocketmq.v2.ReceiveMessageResponse>(
                  this, METHODID_RECEIVE_MESSAGE)))
          .addMethod(
            getAckMessageMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.AckMessageRequest,
                apache.rocketmq.v2.AckMessageResponse>(
                  this, METHODID_ACK_MESSAGE)))
          .addMethod(
            getForwardMessageToDeadLetterQueueMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest,
                apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse>(
                  this, METHODID_FORWARD_MESSAGE_TO_DEAD_LETTER_QUEUE)))
          .addMethod(
            getEndTransactionMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.EndTransactionRequest,
                apache.rocketmq.v2.EndTransactionResponse>(
                  this, METHODID_END_TRANSACTION)))
          .addMethod(
            getTelemetryMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
              new MethodHandlers<
                apache.rocketmq.v2.TelemetryCommand,
                apache.rocketmq.v2.TelemetryCommand>(
                  this, METHODID_TELEMETRY)))
          .addMethod(
            getNotifyClientTerminationMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.NotifyClientTerminationRequest,
                apache.rocketmq.v2.NotifyClientTerminationResponse>(
                  this, METHODID_NOTIFY_CLIENT_TERMINATION)))
          .addMethod(
            getChangeInvisibleDurationMethod(),
            org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                apache.rocketmq.v2.ChangeInvisibleDurationRequest,
                apache.rocketmq.v2.ChangeInvisibleDurationResponse>(
                  this, METHODID_CHANGE_INVISIBLE_DURATION)))
          .build();
    }
  }

  /**
   * <pre>
   * For all the RPCs in MessagingService, the following error handling policies
   * apply:
   * If the request doesn't bear a valid authentication credential, return a
   * response with common.status.code == `UNAUTHENTICATED`. If the authenticated
   * user is not granted with sufficient permission to execute the requested
   * operation, return a response with common.status.code == `PERMISSION_DENIED`.
   * If the per-user-resource-based quota is exhausted, return a response with
   * common.status.code == `RESOURCE_EXHAUSTED`. If any unexpected server-side
   * errors raise, return a response with common.status.code == `INTERNAL`.
   * </pre>
   */
  public static final class MessagingServiceStub extends org.apache.rocketmq.shaded.io.grpc.stub.AbstractAsyncStub<MessagingServiceStub> {
    private MessagingServiceStub(
        org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MessagingServiceStub build(
        org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
      return new MessagingServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Queries the route entries of the requested topic in the perspective of the
     * given endpoints. On success, servers should return a collection of
     * addressable message-queues. Note servers may return customized route
     * entries based on endpoints provided.
     * If the requested topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public void queryRoute(apache.rocketmq.v2.QueryRouteRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.QueryRouteResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getQueryRouteMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Producer or consumer sends HeartbeatRequest to servers periodically to
     * keep-alive. Additionally, it also reports client-side configuration,
     * including topic subscription, load-balancing group name, etc.
     * Returns `OK` if success.
     * If a client specifies a language that is not yet supported by servers,
     * returns `INVALID_ARGUMENT`
     * </pre>
     */
    public void heartbeat(apache.rocketmq.v2.HeartbeatRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.HeartbeatResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getHeartbeatMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Delivers messages to brokers.
     * Clients may further:
     * 1. Refine a message destination to message-queues which fulfills parts of
     * FIFO semantic;
     * 2. Flag a message as transactional, which keeps it invisible to consumers
     * until it commits;
     * 3. Time a message, making it invisible to consumers till specified
     * time-point;
     * 4. And more...
     * Returns message-id or transaction-id with status `OK` on success.
     * If the destination topic doesn't exist, returns `NOT_FOUND`.
     * </pre>
     */
    public void sendMessage(apache.rocketmq.v2.SendMessageRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.SendMessageResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSendMessageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Queries the assigned route info of a topic for current consumer,
     * the returned assignment result is decided by server-side load balancer.
     * If the corresponding topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public void queryAssignment(apache.rocketmq.v2.QueryAssignmentRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.QueryAssignmentResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getQueryAssignmentMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Receives messages from the server in batch manner, returns a set of
     * messages if success. The received messages should be acked or redelivered
     * after processed.
     * If the pending concurrent receive requests exceed the quota of the given
     * consumer group, returns `UNAVAILABLE`. If the upstream store server hangs,
     * return `DEADLINE_EXCEEDED` in a timely manner. If the corresponding topic
     * or consumer group doesn't exist, returns `NOT_FOUND`. If there is no new
     * message in the specific topic, returns `OK` with an empty message set.
     * Please note that client may suffer from false empty responses.
     * If failed to receive message from remote, server must return only one
     * `ReceiveMessageResponse` as the reply to the request, whose `Status` indicates
     * the specific reason of failure, otherwise, the reply is considered successful.
     * </pre>
     */
    public void receiveMessage(apache.rocketmq.v2.ReceiveMessageRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ReceiveMessageResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getReceiveMessageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Acknowledges the message associated with the `receipt_handle` or `offset`
     * in the `AckMessageRequest`, it means the message has been successfully
     * processed. Returns `OK` if the message server remove the relevant message
     * successfully.
     * If the given receipt_handle is illegal or out of date, returns
     * `INVALID_ARGUMENT`.
     * </pre>
     */
    public void ackMessage(apache.rocketmq.v2.AckMessageRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.AckMessageResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getAckMessageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Forwards one message to dead letter queue if the max delivery attempts is
     * exceeded by this message at client-side, return `OK` if success.
     * </pre>
     */
    public void forwardMessageToDeadLetterQueue(apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getForwardMessageToDeadLetterQueueMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Commits or rollback one transactional message.
     * </pre>
     */
    public void endTransaction(apache.rocketmq.v2.EndTransactionRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.EndTransactionResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getEndTransactionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Once a client starts, it would immediately establishes bi-lateral stream
     * RPCs with brokers, reporting its settings as the initiative command.
     * When servers have need of inspecting client status, they would issue
     * telemetry commands to clients. After executing received instructions,
     * clients shall report command execution results through client-side streams.
     * </pre>
     */
    public org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.TelemetryCommand> telemetry(
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.TelemetryCommand> responseObserver) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
          getChannel().newCall(getTelemetryMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     * Notify the server that the client is terminated.
     * </pre>
     */
    public void notifyClientTermination(apache.rocketmq.v2.NotifyClientTerminationRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.NotifyClientTerminationResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getNotifyClientTerminationMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Once a message is retrieved from consume queue on behalf of the group, it
     * will be kept invisible to other clients of the same group for a period of
     * time. The message is supposed to be processed within the invisible
     * duration. If the client, which is in charge of the invisible message, is
     * not capable of processing the message timely, it may use
     * ChangeInvisibleDuration to lengthen invisible duration.
     * </pre>
     */
    public void changeInvisibleDuration(apache.rocketmq.v2.ChangeInvisibleDurationRequest request,
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ChangeInvisibleDurationResponse> responseObserver) {
      org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getChangeInvisibleDurationMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * For all the RPCs in MessagingService, the following error handling policies
   * apply:
   * If the request doesn't bear a valid authentication credential, return a
   * response with common.status.code == `UNAUTHENTICATED`. If the authenticated
   * user is not granted with sufficient permission to execute the requested
   * operation, return a response with common.status.code == `PERMISSION_DENIED`.
   * If the per-user-resource-based quota is exhausted, return a response with
   * common.status.code == `RESOURCE_EXHAUSTED`. If any unexpected server-side
   * errors raise, return a response with common.status.code == `INTERNAL`.
   * </pre>
   */
  public static final class MessagingServiceBlockingStub extends org.apache.rocketmq.shaded.io.grpc.stub.AbstractBlockingStub<MessagingServiceBlockingStub> {
    private MessagingServiceBlockingStub(
        org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MessagingServiceBlockingStub build(
        org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
      return new MessagingServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Queries the route entries of the requested topic in the perspective of the
     * given endpoints. On success, servers should return a collection of
     * addressable message-queues. Note servers may return customized route
     * entries based on endpoints provided.
     * If the requested topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public apache.rocketmq.v2.QueryRouteResponse queryRoute(apache.rocketmq.v2.QueryRouteRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getQueryRouteMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Producer or consumer sends HeartbeatRequest to servers periodically to
     * keep-alive. Additionally, it also reports client-side configuration,
     * including topic subscription, load-balancing group name, etc.
     * Returns `OK` if success.
     * If a client specifies a language that is not yet supported by servers,
     * returns `INVALID_ARGUMENT`
     * </pre>
     */
    public apache.rocketmq.v2.HeartbeatResponse heartbeat(apache.rocketmq.v2.HeartbeatRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getHeartbeatMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Delivers messages to brokers.
     * Clients may further:
     * 1. Refine a message destination to message-queues which fulfills parts of
     * FIFO semantic;
     * 2. Flag a message as transactional, which keeps it invisible to consumers
     * until it commits;
     * 3. Time a message, making it invisible to consumers till specified
     * time-point;
     * 4. And more...
     * Returns message-id or transaction-id with status `OK` on success.
     * If the destination topic doesn't exist, returns `NOT_FOUND`.
     * </pre>
     */
    public apache.rocketmq.v2.SendMessageResponse sendMessage(apache.rocketmq.v2.SendMessageRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSendMessageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Queries the assigned route info of a topic for current consumer,
     * the returned assignment result is decided by server-side load balancer.
     * If the corresponding topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public apache.rocketmq.v2.QueryAssignmentResponse queryAssignment(apache.rocketmq.v2.QueryAssignmentRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getQueryAssignmentMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Receives messages from the server in batch manner, returns a set of
     * messages if success. The received messages should be acked or redelivered
     * after processed.
     * If the pending concurrent receive requests exceed the quota of the given
     * consumer group, returns `UNAVAILABLE`. If the upstream store server hangs,
     * return `DEADLINE_EXCEEDED` in a timely manner. If the corresponding topic
     * or consumer group doesn't exist, returns `NOT_FOUND`. If there is no new
     * message in the specific topic, returns `OK` with an empty message set.
     * Please note that client may suffer from false empty responses.
     * If failed to receive message from remote, server must return only one
     * `ReceiveMessageResponse` as the reply to the request, whose `Status` indicates
     * the specific reason of failure, otherwise, the reply is considered successful.
     * </pre>
     */
    public java.util.Iterator<apache.rocketmq.v2.ReceiveMessageResponse> receiveMessage(
        apache.rocketmq.v2.ReceiveMessageRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getReceiveMessageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Acknowledges the message associated with the `receipt_handle` or `offset`
     * in the `AckMessageRequest`, it means the message has been successfully
     * processed. Returns `OK` if the message server remove the relevant message
     * successfully.
     * If the given receipt_handle is illegal or out of date, returns
     * `INVALID_ARGUMENT`.
     * </pre>
     */
    public apache.rocketmq.v2.AckMessageResponse ackMessage(apache.rocketmq.v2.AckMessageRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getAckMessageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Forwards one message to dead letter queue if the max delivery attempts is
     * exceeded by this message at client-side, return `OK` if success.
     * </pre>
     */
    public apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse forwardMessageToDeadLetterQueue(apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getForwardMessageToDeadLetterQueueMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Commits or rollback one transactional message.
     * </pre>
     */
    public apache.rocketmq.v2.EndTransactionResponse endTransaction(apache.rocketmq.v2.EndTransactionRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getEndTransactionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Notify the server that the client is terminated.
     * </pre>
     */
    public apache.rocketmq.v2.NotifyClientTerminationResponse notifyClientTermination(apache.rocketmq.v2.NotifyClientTerminationRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getNotifyClientTerminationMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Once a message is retrieved from consume queue on behalf of the group, it
     * will be kept invisible to other clients of the same group for a period of
     * time. The message is supposed to be processed within the invisible
     * duration. If the client, which is in charge of the invisible message, is
     * not capable of processing the message timely, it may use
     * ChangeInvisibleDuration to lengthen invisible duration.
     * </pre>
     */
    public apache.rocketmq.v2.ChangeInvisibleDurationResponse changeInvisibleDuration(apache.rocketmq.v2.ChangeInvisibleDurationRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getChangeInvisibleDurationMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * For all the RPCs in MessagingService, the following error handling policies
   * apply:
   * If the request doesn't bear a valid authentication credential, return a
   * response with common.status.code == `UNAUTHENTICATED`. If the authenticated
   * user is not granted with sufficient permission to execute the requested
   * operation, return a response with common.status.code == `PERMISSION_DENIED`.
   * If the per-user-resource-based quota is exhausted, return a response with
   * common.status.code == `RESOURCE_EXHAUSTED`. If any unexpected server-side
   * errors raise, return a response with common.status.code == `INTERNAL`.
   * </pre>
   */
  public static final class MessagingServiceFutureStub extends org.apache.rocketmq.shaded.io.grpc.stub.AbstractFutureStub<MessagingServiceFutureStub> {
    private MessagingServiceFutureStub(
        org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected MessagingServiceFutureStub build(
        org.apache.rocketmq.shaded.io.grpc.Channel channel, org.apache.rocketmq.shaded.io.grpc.CallOptions callOptions) {
      return new MessagingServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Queries the route entries of the requested topic in the perspective of the
     * given endpoints. On success, servers should return a collection of
     * addressable message-queues. Note servers may return customized route
     * entries based on endpoints provided.
     * If the requested topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.QueryRouteResponse> queryRoute(
        apache.rocketmq.v2.QueryRouteRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getQueryRouteMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Producer or consumer sends HeartbeatRequest to servers periodically to
     * keep-alive. Additionally, it also reports client-side configuration,
     * including topic subscription, load-balancing group name, etc.
     * Returns `OK` if success.
     * If a client specifies a language that is not yet supported by servers,
     * returns `INVALID_ARGUMENT`
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.HeartbeatResponse> heartbeat(
        apache.rocketmq.v2.HeartbeatRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getHeartbeatMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Delivers messages to brokers.
     * Clients may further:
     * 1. Refine a message destination to message-queues which fulfills parts of
     * FIFO semantic;
     * 2. Flag a message as transactional, which keeps it invisible to consumers
     * until it commits;
     * 3. Time a message, making it invisible to consumers till specified
     * time-point;
     * 4. And more...
     * Returns message-id or transaction-id with status `OK` on success.
     * If the destination topic doesn't exist, returns `NOT_FOUND`.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.SendMessageResponse> sendMessage(
        apache.rocketmq.v2.SendMessageRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSendMessageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Queries the assigned route info of a topic for current consumer,
     * the returned assignment result is decided by server-side load balancer.
     * If the corresponding topic doesn't exist, returns `NOT_FOUND`.
     * If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.QueryAssignmentResponse> queryAssignment(
        apache.rocketmq.v2.QueryAssignmentRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getQueryAssignmentMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Acknowledges the message associated with the `receipt_handle` or `offset`
     * in the `AckMessageRequest`, it means the message has been successfully
     * processed. Returns `OK` if the message server remove the relevant message
     * successfully.
     * If the given receipt_handle is illegal or out of date, returns
     * `INVALID_ARGUMENT`.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.AckMessageResponse> ackMessage(
        apache.rocketmq.v2.AckMessageRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getAckMessageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Forwards one message to dead letter queue if the max delivery attempts is
     * exceeded by this message at client-side, return `OK` if success.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse> forwardMessageToDeadLetterQueue(
        apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getForwardMessageToDeadLetterQueueMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Commits or rollback one transactional message.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.EndTransactionResponse> endTransaction(
        apache.rocketmq.v2.EndTransactionRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getEndTransactionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Notify the server that the client is terminated.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.NotifyClientTerminationResponse> notifyClientTermination(
        apache.rocketmq.v2.NotifyClientTerminationRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getNotifyClientTerminationMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Once a message is retrieved from consume queue on behalf of the group, it
     * will be kept invisible to other clients of the same group for a period of
     * time. The message is supposed to be processed within the invisible
     * duration. If the client, which is in charge of the invisible message, is
     * not capable of processing the message timely, it may use
     * ChangeInvisibleDuration to lengthen invisible duration.
     * </pre>
     */
    public org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture<apache.rocketmq.v2.ChangeInvisibleDurationResponse> changeInvisibleDuration(
        apache.rocketmq.v2.ChangeInvisibleDurationRequest request) {
      return org.apache.rocketmq.shaded.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getChangeInvisibleDurationMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_QUERY_ROUTE = 0;
  private static final int METHODID_HEARTBEAT = 1;
  private static final int METHODID_SEND_MESSAGE = 2;
  private static final int METHODID_QUERY_ASSIGNMENT = 3;
  private static final int METHODID_RECEIVE_MESSAGE = 4;
  private static final int METHODID_ACK_MESSAGE = 5;
  private static final int METHODID_FORWARD_MESSAGE_TO_DEAD_LETTER_QUEUE = 6;
  private static final int METHODID_END_TRANSACTION = 7;
  private static final int METHODID_NOTIFY_CLIENT_TERMINATION = 8;
  private static final int METHODID_CHANGE_INVISIBLE_DURATION = 9;
  private static final int METHODID_TELEMETRY = 10;

  private static final class MethodHandlers<Req, Resp> implements
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      org.apache.rocketmq.shaded.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final MessagingServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(MessagingServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_QUERY_ROUTE:
          serviceImpl.queryRoute((apache.rocketmq.v2.QueryRouteRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.QueryRouteResponse>) responseObserver);
          break;
        case METHODID_HEARTBEAT:
          serviceImpl.heartbeat((apache.rocketmq.v2.HeartbeatRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.HeartbeatResponse>) responseObserver);
          break;
        case METHODID_SEND_MESSAGE:
          serviceImpl.sendMessage((apache.rocketmq.v2.SendMessageRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.SendMessageResponse>) responseObserver);
          break;
        case METHODID_QUERY_ASSIGNMENT:
          serviceImpl.queryAssignment((apache.rocketmq.v2.QueryAssignmentRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.QueryAssignmentResponse>) responseObserver);
          break;
        case METHODID_RECEIVE_MESSAGE:
          serviceImpl.receiveMessage((apache.rocketmq.v2.ReceiveMessageRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ReceiveMessageResponse>) responseObserver);
          break;
        case METHODID_ACK_MESSAGE:
          serviceImpl.ackMessage((apache.rocketmq.v2.AckMessageRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.AckMessageResponse>) responseObserver);
          break;
        case METHODID_FORWARD_MESSAGE_TO_DEAD_LETTER_QUEUE:
          serviceImpl.forwardMessageToDeadLetterQueue((apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse>) responseObserver);
          break;
        case METHODID_END_TRANSACTION:
          serviceImpl.endTransaction((apache.rocketmq.v2.EndTransactionRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.EndTransactionResponse>) responseObserver);
          break;
        case METHODID_NOTIFY_CLIENT_TERMINATION:
          serviceImpl.notifyClientTermination((apache.rocketmq.v2.NotifyClientTerminationRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.NotifyClientTerminationResponse>) responseObserver);
          break;
        case METHODID_CHANGE_INVISIBLE_DURATION:
          serviceImpl.changeInvisibleDuration((apache.rocketmq.v2.ChangeInvisibleDurationRequest) request,
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.ChangeInvisibleDurationResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<Req> invoke(
        org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_TELEMETRY:
          return (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<Req>) serviceImpl.telemetry(
              (org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver<apache.rocketmq.v2.TelemetryCommand>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class MessagingServiceBaseDescriptorSupplier
      implements org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoFileDescriptorSupplier, org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    MessagingServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return apache.rocketmq.v2.MQService.getDescriptor();
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("MessagingService");
    }
  }

  private static final class MessagingServiceFileDescriptorSupplier
      extends MessagingServiceBaseDescriptorSupplier {
    MessagingServiceFileDescriptorSupplier() {}
  }

  private static final class MessagingServiceMethodDescriptorSupplier
      extends MessagingServiceBaseDescriptorSupplier
      implements org.apache.rocketmq.shaded.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    MessagingServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public org.apache.rocketmq.shaded.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile org.apache.rocketmq.shaded.io.grpc.ServiceDescriptor serviceDescriptor;

  public static org.apache.rocketmq.shaded.io.grpc.ServiceDescriptor getServiceDescriptor() {
    org.apache.rocketmq.shaded.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (MessagingServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = org.apache.rocketmq.shaded.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new MessagingServiceFileDescriptorSupplier())
              .addMethod(getQueryRouteMethod())
              .addMethod(getHeartbeatMethod())
              .addMethod(getSendMessageMethod())
              .addMethod(getQueryAssignmentMethod())
              .addMethod(getReceiveMessageMethod())
              .addMethod(getAckMessageMethod())
              .addMethod(getForwardMessageToDeadLetterQueueMethod())
              .addMethod(getEndTransactionMethod())
              .addMethod(getTelemetryMethod())
              .addMethod(getNotifyClientTerminationMethod())
              .addMethod(getChangeInvisibleDurationMethod())
              .build();
        }
      }
    }
    return result;
  }
}
