/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar;

import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;

/**
 * Exemplar filters are used to pre-filter measurements before attempting to store them in a
 * reservoir.
 *
 * <p>This class is internal and is hence not for public use. Its APIs are unstable and can change
 * at any time.
 */
public interface ExemplarFilter {
  /** Returns whether or not a reservoir should attempt to filter a measurement. */
  boolean shouldSampleMeasurement(long value, Attributes attributes, Context context);

  /** Returns whether or not a reservoir should attempt to filter a measurement. */
  boolean shouldSampleMeasurement(double value, Attributes attributes, Context context);

  /**
   * A filter that only accepts measurements where there is a {@code Span} in {@link Context} that
   * is being sampled.
   */
  static ExemplarFilter sampleWithTraces() {
    return WithTraceExemplarFilter.INSTANCE;
  }

  /** A filter that accepts any measurement. */
  static ExemplarFilter alwaysSample() {
    return AlwaysSampleFilter.INSTANCE;
  }

  /** A filter that accepts no measurements. */
  static ExemplarFilter neverSample() {
    return NeverSampleFilter.INSTANCE;
  }
}
