/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection;

import java.sql.SQLException;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.ConnectionStatus;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.LocalTransactionManager;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.TransactionManager;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;

public final class BackendTransactionManager
implements TransactionManager {
    private final BackendConnection connection;
    private TransactionType transactionType;
    private LocalTransactionManager localTransactionManager;
    private ShardingTransactionManager shardingTransactionManager;

    public BackendTransactionManager(BackendConnection backendConnection) {
        this.connection = backendConnection;
        this.transactionType = this.connection.getTransactionType();
        this.localTransactionManager = new LocalTransactionManager(backendConnection);
        this.shardingTransactionManager = null == this.connection.getLogicSchema() ? null : this.connection.getLogicSchema().getBackendDataSource().getShardingTransactionManagerEngine().getTransactionManager(this.transactionType);
    }

    @Override
    public void begin() {
        if (!this.connection.getStateHandler().isInTransaction()) {
            this.connection.getStateHandler().setStatus(ConnectionStatus.TRANSACTION);
            this.connection.releaseConnections(false);
        }
        if (TransactionType.LOCAL == this.transactionType || null == this.shardingTransactionManager) {
            this.localTransactionManager.begin();
        } else {
            this.shardingTransactionManager.begin();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection.getStateHandler().isInTransaction()) {
            try {
                if (TransactionType.LOCAL == this.transactionType || null == this.shardingTransactionManager) {
                    this.localTransactionManager.commit();
                } else {
                    this.shardingTransactionManager.commit();
                }
            }
            finally {
                this.connection.getStateHandler().setStatus(ConnectionStatus.TERMINATED);
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection.getStateHandler().isInTransaction()) {
            try {
                if (TransactionType.LOCAL == this.transactionType || null == this.shardingTransactionManager) {
                    this.localTransactionManager.rollback();
                } else {
                    this.shardingTransactionManager.rollback();
                }
            }
            finally {
                this.connection.getStateHandler().setStatus(ConnectionStatus.TERMINATED);
            }
        }
    }
}

