/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.shardingsphere.core.SimpleQueryShardingEngine;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.optimize.api.statement.OptimizedStatement;
import org.apache.shardingsphere.core.optimize.encrypt.EncryptOptimizeEngineFactory;
import org.apache.shardingsphere.core.optimize.transparent.statement.TransparentOptimizedStatement;
import org.apache.shardingsphere.core.parse.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rewrite.SQLRewriteEngine;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.route.router.masterslave.MasterSlaveRouter;
import org.apache.shardingsphere.core.rule.BaseRule;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.schema.EncryptSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.spi.database.DatabaseType;

public final class StatementExecutorWrapper
implements JDBCExecutorWrapper {
    private static final ShardingProxyContext SHARDING_PROXY_CONTEXT = ShardingProxyContext.getInstance();
    private final LogicSchema logicSchema;

    @Override
    public SQLRouteResult route(String sql, DatabaseType databaseType) {
        if (this.logicSchema instanceof ShardingSchema) {
            return this.doShardingRoute(sql, databaseType);
        }
        if (this.logicSchema instanceof MasterSlaveSchema) {
            return this.doMasterSlaveRoute(sql);
        }
        if (this.logicSchema instanceof EncryptSchema) {
            return this.doEncryptRoute(sql);
        }
        return this.doTransparentRoute(sql);
    }

    private SQLRouteResult doShardingRoute(String sql, DatabaseType databaseType) {
        SimpleQueryShardingEngine shardingEngine = new SimpleQueryShardingEngine(this.logicSchema.getShardingRule(), ShardingProxyContext.getInstance().getShardingProperties(), this.logicSchema.getMetaData(), databaseType, this.logicSchema.getParseEngine());
        return shardingEngine.shard(sql, Collections.emptyList());
    }

    private SQLRouteResult doMasterSlaveRoute(String sql) {
        SQLStatement sqlStatement = this.logicSchema.getParseEngine().parse(sql, false);
        TransparentOptimizedStatement optimizedStatement = new TransparentOptimizedStatement(sqlStatement);
        SQLRewriteEngine sqlRewriteEngine = new SQLRewriteEngine(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), (OptimizedStatement)optimizedStatement, sql);
        String rewriteSQL = sqlRewriteEngine.generateSQL().getSql();
        SQLRouteResult result = new SQLRouteResult((OptimizedStatement)optimizedStatement);
        for (String each : new MasterSlaveRouter(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), this.logicSchema.getParseEngine(), ((Boolean)SHARDING_PROXY_CONTEXT.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(rewriteSQL, false)) {
            result.getRouteUnits().add(new RouteUnit(each, new SQLUnit(rewriteSQL, Collections.emptyList())));
        }
        return result;
    }

    private SQLRouteResult doEncryptRoute(String sql) {
        EncryptSchema encryptSchema = (EncryptSchema)this.logicSchema;
        SQLStatement sqlStatement = encryptSchema.getParseEngine().parse(sql, false);
        OptimizedStatement optimizedStatement = EncryptOptimizeEngineFactory.newInstance((SQLStatement)sqlStatement).optimize((BaseRule)encryptSchema.getEncryptRule(), this.logicSchema.getMetaData().getTable(), sql, new LinkedList(), sqlStatement);
        SQLRewriteEngine sqlRewriteEngine = new SQLRewriteEngine(encryptSchema.getEncryptRule(), optimizedStatement, sql, Collections.emptyList(), ((Boolean)ShardingProxyContext.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.QUERY_WITH_CIPHER_COLUMN)).booleanValue());
        SQLRouteResult result = new SQLRouteResult(optimizedStatement);
        result.getRouteUnits().add(new RouteUnit(this.logicSchema.getDataSources().keySet().iterator().next(), new SQLUnit(sqlRewriteEngine.generateSQL().getSql(), Collections.emptyList())));
        return result;
    }

    private SQLRouteResult doTransparentRoute(String sql) {
        SQLRouteResult result = new SQLRouteResult((OptimizedStatement)new TransparentOptimizedStatement(this.logicSchema.getParseEngine().parse(sql, false)));
        result.getRouteUnits().add(new RouteUnit(this.logicSchema.getDataSources().keySet().iterator().next(), new SQLUnit(sql, Collections.emptyList())));
        return result;
    }

    @Override
    public Statement createStatement(Connection connection, SQLUnit sqlUnit, boolean isReturnGeneratedKeys) throws SQLException {
        return connection.createStatement();
    }

    @Override
    public boolean executeSQL(Statement statement, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return statement.execute(sql, isReturnGeneratedKeys ? 1 : 2);
    }

    @ConstructorProperties(value={"logicSchema"})
    public StatementExecutorWrapper(LogicSchema logicSchema) {
        this.logicSchema = logicSchema;
    }
}

