/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.api.config.RuleConfiguration;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.database.DatabaseTypes;
import org.apache.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.SchemaAddedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.SchemaDeletedEvent;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.recognizer.JDBCDriverURLRecognizerEngine;
import org.apache.shardingsphere.shardingproxy.backend.schema.EncryptSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.TransparentSchema;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;
import org.apache.shardingsphere.shardingproxy.util.DataSourceConverter;
import org.apache.shardingsphere.spi.database.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogicSchemas {
    private static final Logger log = LoggerFactory.getLogger(LogicSchemas.class);
    private static final LogicSchemas INSTANCE = new LogicSchemas();
    private final Map<String, LogicSchema> logicSchemas = new ConcurrentHashMap<String, LogicSchema>();
    private DatabaseType databaseType;

    private LogicSchemas() {
        ShardingOrchestrationEventBus.getInstance().register((Object)this);
    }

    public static LogicSchemas getInstance() {
        return INSTANCE;
    }

    public void init(Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules) {
        this.init(schemaRules.keySet(), schemaDataSources, schemaRules, false);
    }

    public void init(Collection<String> localSchemaNames, Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules, boolean isUsingRegistry) {
        this.databaseType = DatabaseTypes.getActualDatabaseType((String)JDBCDriverURLRecognizerEngine.getJDBCDriverURLRecognizer(schemaDataSources.values().iterator().next().values().iterator().next().getUrl()).getDatabaseType());
        this.initSchemas(localSchemaNames, schemaDataSources, schemaRules, isUsingRegistry);
    }

    private void initSchemas(Collection<String> localSchemaNames, Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, Map<String, RuleConfiguration> schemaRules, boolean isUsingRegistry) {
        if (schemaRules.isEmpty()) {
            this.logicSchemas.put(schemaDataSources.keySet().iterator().next(), this.createLogicSchema(schemaDataSources.keySet().iterator().next(), schemaDataSources, null, isUsingRegistry));
        }
        for (Map.Entry<String, RuleConfiguration> entry : schemaRules.entrySet()) {
            if (!localSchemaNames.isEmpty() && !localSchemaNames.contains(entry.getKey())) continue;
            this.logicSchemas.put(entry.getKey(), this.createLogicSchema(entry.getKey(), schemaDataSources, entry.getValue(), isUsingRegistry));
        }
    }

    private LogicSchema createLogicSchema(String schemaName, Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, RuleConfiguration ruleConfiguration, boolean isUsingRegistry) {
        LogicSchema result;
        try {
            result = ruleConfiguration instanceof ShardingRuleConfiguration ? new ShardingSchema(schemaName, schemaDataSources.get(schemaName), (ShardingRuleConfiguration)ruleConfiguration, isUsingRegistry) : (ruleConfiguration instanceof MasterSlaveRuleConfiguration ? new MasterSlaveSchema(schemaName, schemaDataSources.get(schemaName), (MasterSlaveRuleConfiguration)ruleConfiguration, isUsingRegistry) : (ruleConfiguration instanceof EncryptRuleConfiguration ? new EncryptSchema(schemaName, schemaDataSources.get(schemaName), (EncryptRuleConfiguration)ruleConfiguration) : new TransparentSchema(schemaName, schemaDataSources.get(schemaName))));
        }
        catch (Exception ex) {
            log.error("Exception occur when create schema {}.\nThe exception detail is {}.", (Object)schemaName, (Object)ex.getMessage());
            throw ex;
        }
        return result;
    }

    public boolean schemaExists(String schema) {
        return this.logicSchemas.keySet().contains(schema);
    }

    public LogicSchema getLogicSchema(String schemaName) {
        return Strings.isNullOrEmpty((String)schemaName) ? null : this.logicSchemas.get(schemaName);
    }

    public List<String> getSchemaNames() {
        return new LinkedList<String>(this.logicSchemas.keySet());
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent schemaAddedEvent) {
        this.logicSchemas.put(schemaAddedEvent.getShardingSchemaName(), this.createLogicSchema(schemaAddedEvent.getShardingSchemaName(), Collections.singletonMap(schemaAddedEvent.getShardingSchemaName(), DataSourceConverter.getDataSourceParameterMap((Map)schemaAddedEvent.getDataSourceConfigurations())), schemaAddedEvent.getRuleConfiguration(), true));
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent schemaDeletedEvent) {
        this.logicSchemas.remove(schemaDeletedEvent.getShardingSchemaName());
    }

    public Map<String, LogicSchema> getLogicSchemas() {
        return this.logicSchemas;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

