/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import java.util.Map;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.SQLParseEngine;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class TransparentSchema
extends LogicSchema {
    private final ShardingMetaData metaData;
    private final ShardingRule shardingRule = new ShardingRule(new ShardingRuleConfiguration(), this.getDataSources().keySet());

    public TransparentSchema(String name, Map<String, YamlDataSourceParameter> dataSources) {
        super(name, dataSources);
        this.metaData = this.createShardingMetaData();
    }

    @Override
    public SQLParseEngine getParseEngine() {
        return null;
    }

    private ShardingMetaData createShardingMetaData() {
        ShardingDataSourceMetaData shardingDataSourceMetaData = new ShardingDataSourceMetaData(this.getDataSourceURLs(this.getDataSources()), this.shardingRule, LogicSchemas.getInstance().getDatabaseType());
        ShardingTableMetaData shardingTableMetaData = new ShardingTableMetaData(this.getTableMetaDataInitializer(shardingDataSourceMetaData).load(this.shardingRule));
        return new ShardingMetaData(shardingDataSourceMetaData, shardingTableMetaData);
    }

    @Override
    public ShardingMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }
}

