/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.ingest.position;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IntegerPrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.StringPrimaryKeyPosition;

public final class PrimaryKeyPositionFactory {
    public static IngestPosition<?> newInstance(String data) {
        String[] array = data.split(",");
        Preconditions.checkArgument((3 == array.length ? 1 : 0) != 0, (Object)("Unknown primary key position: " + data));
        Preconditions.checkArgument((1 == array[0].length() ? 1 : 0) != 0, (Object)("Invalid primary key position type: " + array[0]));
        char type = array[0].charAt(0);
        String beginValue = array[1];
        String endValue = array[2];
        switch (type) {
            case 'i': {
                return new IntegerPrimaryKeyPosition(Long.parseLong(beginValue), Long.parseLong(endValue));
            }
            case 's': {
                return new StringPrimaryKeyPosition(beginValue, endValue);
            }
        }
        throw new IllegalArgumentException("Unknown primary key position type: " + type);
    }

    public static IngestPosition<?> newInstance(@NonNull Object beginValue, @NonNull Object endValue) {
        if (beginValue == null) {
            throw new NullPointerException("beginValue is marked non-null but is null");
        }
        if (endValue == null) {
            throw new NullPointerException("endValue is marked non-null but is null");
        }
        if (beginValue instanceof Number) {
            return new IntegerPrimaryKeyPosition(((Number)beginValue).longValue(), ((Number)endValue).longValue());
        }
        if (beginValue instanceof CharSequence) {
            return new StringPrimaryKeyPosition(beginValue.toString(), endValue.toString());
        }
        throw new IllegalArgumentException("Unknown begin value type: " + beginValue.getClass().getName());
    }
}

