/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.job.progress;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.task.progress.InventoryTaskProgress;

public final class JobItemInventoryTasksProgress {
    private final Map<String, InventoryTaskProgress> inventoryTaskProgressMap;

    public Map<String, IngestPosition<?>> getInventoryPosition(String tableName) {
        Pattern pattern = Pattern.compile(String.format("%s(#\\d+)?", tableName));
        return this.inventoryTaskProgressMap.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).find()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((InventoryTaskProgress)entry.getValue()).getPosition()));
    }

    public int getInventoryFinishedPercentage() {
        long finished = this.inventoryTaskProgressMap.values().stream().filter(each -> each.getPosition() instanceof FinishedPosition).count();
        return this.inventoryTaskProgressMap.isEmpty() ? 0 : (int)(finished * 100L / (long)this.inventoryTaskProgressMap.size());
    }

    @Generated
    public JobItemInventoryTasksProgress(Map<String, InventoryTaskProgress> inventoryTaskProgressMap) {
        this.inventoryTaskProgressMap = inventoryTaskProgressMap;
    }

    @Generated
    public Map<String, InventoryTaskProgress> getInventoryTaskProgressMap() {
        return this.inventoryTaskProgressMap;
    }
}

