/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.data.builder.dialect;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.data.builder.ShardingSphereDataBuilder;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;

public final class PostgreSQLShardingSphereDataBuilder
implements ShardingSphereDataBuilder {
    private static final String SHARDING_SPHERE = "shardingsphere";

    @Override
    public ShardingSphereData build(ShardingSphereMetaData metaData) {
        ShardingSphereData result = new ShardingSphereData();
        for (Map.Entry<String, ShardingSphereDatabase> entry : metaData.getDatabases().entrySet()) {
            if (new PostgreSQLDatabaseType().getSystemDatabaseSchemaMap().containsKey(entry.getKey())) continue;
            ShardingSphereDatabaseData databaseData = new ShardingSphereDatabaseData();
            Optional<ShardingSphereSchema> shardingSphereSchema = Optional.ofNullable(entry.getValue()).map(database -> database.getSchema(SHARDING_SPHERE));
            if (shardingSphereSchema.isPresent()) {
                ShardingSphereSchemaData schemaData = new ShardingSphereSchemaData();
                shardingSphereSchema.get().getTables().forEach((key, value) -> schemaData.getTableData().put((String)key, new ShardingSphereTableData(value.getName(), new ArrayList<ShardingSphereColumn>(value.getColumns().values()))));
                databaseData.getSchemaData().put(SHARDING_SPHERE, schemaData);
            }
            result.getDatabaseData().put(entry.getKey(), databaseData);
        }
        return result;
    }

    public String getType() {
        return "PostgreSQL";
    }
}

