/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type.table;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class AlterTableStatementSchemaRefresher
implements MetaDataRefresher<AlterTableStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, AlterTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName, logicDataSourceNames);
        if (sqlStatement.getRenameTable().isPresent()) {
            String renameTable = ((SimpleTableSegment)sqlStatement.getRenameTable().get()).getTableName().getIdentifier().getValue();
            alterSchemaMetaDataPOJO.getAlteredTables().add(this.getTable(database, logicDataSourceNames, schemaName, renameTable, props));
            alterSchemaMetaDataPOJO.getDroppedTables().add(tableName);
        } else {
            alterSchemaMetaDataPOJO.getAlteredTables().add(this.getTable(database, logicDataSourceNames, schemaName, tableName, props));
        }
        modeContextManager.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    private ShardingSphereTable getTable(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, String tableName, ConfigurationProperties props) throws SQLException {
        ShardingSphereRuleMetaData ruleMetaData = new ShardingSphereRuleMetaData(new LinkedList(database.getRuleMetaData().getRules()));
        if (!this.containsInImmutableDataNodeContainedRule(tableName, database)) {
            ruleMetaData.findRules(MutableDataNodeRule.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, tableName));
        }
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getProtocolType(), database.getResourceMetaData().getStorageTypes(), database.getResourceMetaData().getDataSources(), ruleMetaData.getRules(), props, schemaName);
        Map schemaMap = GenericSchemaBuilder.build(Collections.singletonList(tableName), (GenericSchemaBuilderMaterial)material);
        return Optional.ofNullable((ShardingSphereSchema)schemaMap.get(schemaName)).map(optional -> optional.getTable(tableName)).orElseGet(() -> new ShardingSphereTable(tableName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
    }

    private boolean containsInImmutableDataNodeContainedRule(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public String getType() {
        return AlterTableStatement.class.getName();
    }
}

