/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import me.ahoo.cosid.sharding.IntervalStep;
import me.ahoo.cosid.sharding.IntervalTimeline;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public abstract class AbstractCosIdIntervalShardingAlgorithm<T extends Comparable<?>>
implements StandardShardingAlgorithm<T> {
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    public static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    public static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    public static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    public static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    public static final String ZONE_ID_KEY = "zone-id";
    private Properties props;
    private ZoneId zoneId;
    private IntervalTimeline intervalTimeline;

    public void init(Properties props) {
        this.props = props;
        this.zoneId = this.getZoneId(props);
        this.intervalTimeline = this.getIntervalTimeline(props);
    }

    private ZoneId getZoneId(Properties props) {
        return props.containsKey(ZONE_ID_KEY) ? ZoneId.of(props.getProperty(ZONE_ID_KEY)) : ZoneId.systemDefault();
    }

    private IntervalTimeline getIntervalTimeline(Properties props) {
        String logicNamePrefix = this.getRequiredValue(props, "logic-name-prefix");
        LocalDateTime effectiveLower = LocalDateTime.parse(this.getRequiredValue(props, DATE_TIME_LOWER_KEY), DEFAULT_DATE_TIME_FORMATTER);
        LocalDateTime effectiveUpper = LocalDateTime.parse(this.getRequiredValue(props, DATE_TIME_UPPER_KEY), DEFAULT_DATE_TIME_FORMATTER);
        DateTimeFormatter suffixFormatter = DateTimeFormatter.ofPattern(this.getRequiredValue(props, SHARDING_SUFFIX_FORMAT_KEY));
        ChronoUnit stepUnit = ChronoUnit.valueOf(this.getRequiredValue(props, INTERVAL_UNIT_KEY));
        int stepAmount = Integer.parseInt(props.getOrDefault((Object)INTERVAL_AMOUNT_KEY, (Object)1).toString());
        return new IntervalTimeline(logicNamePrefix, Range.closed((Comparable)effectiveLower, (Comparable)effectiveUpper), IntervalStep.of((ChronoUnit)stepUnit, (int)stepAmount), suffixFormatter);
    }

    private String getRequiredValue(Properties props, String key) {
        Preconditions.checkArgument((boolean)props.containsKey(key), (String)"%s can not be null.", (Object)key);
        return props.getProperty(key);
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        LocalDateTime shardingTime = this.convertShardingValue(shardingValue.getValue());
        return this.intervalTimeline.sharding(shardingTime);
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        Range<LocalDateTime> shardingRangeTime = this.convertRangeShardingValue(shardingValue.getValueRange());
        return this.intervalTimeline.sharding(shardingRangeTime);
    }

    private Range<LocalDateTime> convertRangeShardingValue(Range<T> shardingValue) {
        Comparable endpointValue;
        if (Range.all().equals(shardingValue)) {
            return Range.all();
        }
        Comparable comparable = endpointValue = shardingValue.hasLowerBound() ? shardingValue.lowerEndpoint() : shardingValue.upperEndpoint();
        if (endpointValue instanceof LocalDateTime) {
            return shardingValue;
        }
        if (shardingValue.hasLowerBound() && shardingValue.hasUpperBound()) {
            LocalDateTime lower = this.convertShardingValue(shardingValue.lowerEndpoint());
            LocalDateTime upper = this.convertShardingValue(shardingValue.upperEndpoint());
            return Range.range((Comparable)lower, (BoundType)shardingValue.lowerBoundType(), (Comparable)upper, (BoundType)shardingValue.upperBoundType());
        }
        if (shardingValue.hasLowerBound()) {
            LocalDateTime lower = this.convertShardingValue(shardingValue.lowerEndpoint());
            return BoundType.OPEN.equals((Object)shardingValue.lowerBoundType()) ? Range.greaterThan((Comparable)lower) : Range.atLeast((Comparable)lower);
        }
        LocalDateTime upper = this.convertShardingValue(shardingValue.upperEndpoint());
        return BoundType.OPEN.equals((Object)shardingValue.upperBoundType()) ? Range.lessThan((Comparable)upper) : Range.atMost((Comparable)upper);
    }

    protected abstract LocalDateTime convertShardingValue(T var1);

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    protected ZoneId getZoneId() {
        return this.zoneId;
    }
}

