/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Properties;
import me.ahoo.cosid.util.LocalDateTimeConvert;
import org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval.AbstractCosIdIntervalShardingAlgorithm;
import org.apache.shardingsphere.sharding.exception.ShardingPluginException;

public final class CosIdIntervalShardingAlgorithm
extends AbstractCosIdIntervalShardingAlgorithm<Comparable<?>> {
    private static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    private static final String TIMESTAMP_SECOND_UNIT = "SECOND";
    private static final String TIMESTAMP_UNIT_KEY = "ts-unit";
    private boolean isSecondTs;
    private DateTimeFormatter dateTimeFormatter;

    @Override
    public void init(Properties props) {
        super.init(props);
        this.isSecondTs = this.getIsSecondTs(props);
        this.dateTimeFormatter = this.getDateTimeFormatter(props);
    }

    private boolean getIsSecondTs(Properties props) {
        return props.containsKey(TIMESTAMP_UNIT_KEY) && TIMESTAMP_SECOND_UNIT.equalsIgnoreCase(props.getProperty(TIMESTAMP_UNIT_KEY));
    }

    private DateTimeFormatter getDateTimeFormatter(Properties props) {
        return DateTimeFormatter.ofPattern(props.getProperty(DATE_TIME_PATTERN_KEY, "yyyy-MM-dd HH:mm:ss"));
    }

    @Override
    protected LocalDateTime convertShardingValue(Comparable<?> shardingValue) {
        if (shardingValue instanceof LocalDateTime) {
            return (LocalDateTime)shardingValue;
        }
        if (shardingValue instanceof ZonedDateTime) {
            return ((ZonedDateTime)shardingValue).toLocalDateTime();
        }
        if (shardingValue instanceof OffsetDateTime) {
            return ((OffsetDateTime)shardingValue).toLocalDateTime();
        }
        if (shardingValue instanceof Instant) {
            return LocalDateTimeConvert.fromInstant((Instant)((Instant)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)shardingValue, LocalTime.MIN);
        }
        if (shardingValue instanceof Date) {
            return LocalDateTimeConvert.fromDate((Date)((Date)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)shardingValue;
            return LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonthValue(), 1, 0, 0);
        }
        if (shardingValue instanceof Year) {
            return LocalDateTime.of(((Year)shardingValue).getValue(), 1, 1, 0, 0);
        }
        if (shardingValue instanceof Long) {
            return this.isSecondTs ? LocalDateTimeConvert.fromTimestampSecond((long)((Long)shardingValue), (ZoneId)this.getZoneId()) : LocalDateTimeConvert.fromTimestamp((long)((Long)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof String) {
            return LocalDateTimeConvert.fromString((String)((String)((Object)shardingValue)), (DateTimeFormatter)this.dateTimeFormatter);
        }
        throw new ShardingPluginException("Unsupported sharding value type `%s`.", new Object[]{shardingValue});
    }

    public String getType() {
        return "COSID_INTERVAL";
    }
}

