/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer;

import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.optimizer.SQLOptimizeContext;
import org.apache.shardingsphere.sqlfederation.optimizer.converter.SQLNodeConverterEngine;

public final class SQLOptimizeEngine {
    private final SqlToRelConverter converter;
    private final RelOptPlanner hepPlanner;

    public SQLOptimizeContext optimize(SQLStatement sqlStatement) {
        SqlNode sqlNode = SQLNodeConverterEngine.convert(sqlStatement);
        RelNode logicPlan = this.converter.convertQuery((SqlNode)sqlNode, (boolean)true, (boolean)true).rel;
        RelDataType validatedNodeType = Objects.requireNonNull(this.converter.validator).getValidatedNodeType(sqlNode);
        RelNode ruleBasedPlan = SQLOptimizeEngine.optimizeWithRBO(logicPlan, this.hepPlanner);
        RelNode bestPlan = this.optimizeWithCBO(ruleBasedPlan, this.converter);
        return new SQLOptimizeContext(bestPlan, validatedNodeType);
    }

    private static RelNode optimizeWithRBO(RelNode logicPlan, RelOptPlanner hepPlanner) {
        hepPlanner.setRoot(logicPlan);
        return hepPlanner.findBestExp();
    }

    private RelNode optimizeWithCBO(RelNode bestPlan, SqlToRelConverter converter) {
        RelOptPlanner planner = converter.getCluster().getPlanner();
        if (!bestPlan.getTraitSet().equals((Object)converter.getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE))) {
            planner.setRoot(planner.changeTraits(bestPlan, converter.getCluster().traitSet().replace((RelTrait)EnumerableConvention.INSTANCE)));
        } else {
            planner.setRoot(bestPlan);
        }
        return planner.findBestExp();
    }

    @Generated
    public SQLOptimizeEngine(SqlToRelConverter converter, RelOptPlanner hepPlanner) {
        this.converter = converter;
        this.hepPlanner = hepPlanner;
    }
}

