/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.context.parser;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sqlfederation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.sqlfederation.optimizer.context.parser.dialect.OptimizerSQLDialectBuilderFactory;

public final class OptimizerParserContextFactory {
    public static Map<String, OptimizerParserContext> create(Map<String, ShardingSphereDatabase> databases) {
        ConcurrentHashMap<String, OptimizerParserContext> result = new ConcurrentHashMap<String, OptimizerParserContext>();
        for (Map.Entry<String, ShardingSphereDatabase> entry : databases.entrySet()) {
            DatabaseType databaseType = entry.getValue().getProtocolType();
            result.put(entry.getKey(), new OptimizerParserContext(databaseType, OptimizerParserContextFactory.createSQLDialectProperties(databaseType)));
        }
        return result;
    }

    public static OptimizerParserContext create(DatabaseType databaseType) {
        return new OptimizerParserContext(databaseType, OptimizerParserContextFactory.createSQLDialectProperties(databaseType));
    }

    private static Properties createSQLDialectProperties(DatabaseType databaseType) {
        Properties result = new Properties();
        result.setProperty(CalciteConnectionProperty.TIME_ZONE.camelName(), "UTC");
        result.putAll((Map<?, ?>)OptimizerSQLDialectBuilderFactory.build(databaseType));
        return result;
    }

    @Generated
    public OptimizerParserContextFactory() {
    }
}

