/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.FederationTranslatableTable;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.TranslatableFilterRule;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.TranslatableProjectFilterRule;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.TranslatableProjectRule;

public class TranslatableTableScan
extends TableScan
implements EnumerableRel {
    private final FederationTranslatableTable translatableTable;
    private final int[] fields;
    private final List<RexNode> filters;
    private final int number;
    private final List<RexNode> expressions;

    public TranslatableTableScan(RelOptCluster cluster, RelOptTable table, FederationTranslatableTable translatableTable, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (List)ImmutableList.of(), table);
        this.translatableTable = translatableTable;
        this.fields = fields;
        this.number = fields.length;
        this.filters = null;
        this.expressions = new ArrayList<RexNode>();
    }

    public TranslatableTableScan(RelOptCluster cluster, RelOptTable table, FederationTranslatableTable translatableTable, int[] fields, int number) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (List)ImmutableList.of(), table);
        this.translatableTable = translatableTable;
        this.fields = fields;
        this.number = number;
        this.filters = null;
        this.expressions = new ArrayList<RexNode>();
    }

    public TranslatableTableScan(RelOptCluster cluster, RelOptTable table, FederationTranslatableTable translatableTable, List<RexNode> filters, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (List)ImmutableList.of(), table);
        this.translatableTable = translatableTable;
        this.fields = fields;
        this.number = fields.length;
        this.filters = filters;
        this.expressions = new ArrayList<RexNode>();
    }

    public TranslatableTableScan(RelOptCluster cluster, RelOptTable table, FederationTranslatableTable translatableTable, List<RexNode> filters, int[] fields, int number, List<RexNode> expressions) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (List)ImmutableList.of(), table);
        this.translatableTable = translatableTable;
        this.fields = fields;
        this.number = number;
        this.filters = filters;
        this.expressions = expressions;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new TranslatableTableScan(this.getCluster(), this.table, this.translatableTable, this.fields, this.number);
    }

    public String toString() {
        if (null == this.filters) {
            return "TranslatableTableScan{translatableTable=" + (Object)((Object)this.translatableTable) + ", fields=" + Arrays.toString(this.fields) + '}';
        }
        Object[] filterValues = new String[this.number];
        this.addFilter(this.filters, (String[])filterValues);
        return "TranslatableTableScan{translatableTable=" + (Object)((Object)this.translatableTable) + ", fields=" + Arrays.toString(this.fields) + ", filters=" + Arrays.toString(filterValues) + '}';
    }

    public RelWriter explainTerms(RelWriter relWriter) {
        if (null == this.filters) {
            return super.explainTerms(relWriter).item("fields", (Object)Primitive.asList((int[])this.fields));
        }
        String[] filterValues = new String[this.number];
        this.addFilter(this.filters, filterValues);
        return super.explainTerms(relWriter).item("fields", (Object)Primitive.asList((int[])this.fields)).item("filters", (Object)Primitive.asList((Object)filterValues));
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return builder.build();
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)TranslatableProjectFilterRule.INSTANCE);
        planner.addRule((RelOptRule)TranslatableFilterRule.INSTANCE);
        planner.addRule((RelOptRule)TranslatableProjectRule.INSTANCE);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(((double)this.number + 2.0) / ((double)this.table.getRowType().getFieldCount() + 2.0));
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        if (null == this.filters) {
            return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)this.table.getExpression(FederationTranslatableTable.class), (String)"project", (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.fields)})));
        }
        String[] filterValues = new String[this.number];
        this.addFilter(this.filters, filterValues);
        return implementor.result(physType, Blocks.toBlock((Node)Expressions.call((Expression)this.table.getExpression(FederationTranslatableTable.class), (String)"projectAndFilter", (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)filterValues), Expressions.constant((Object)this.fields)})));
    }

    private void addFilter(List<RexNode> filters, String[] filterValues) {
        int index = 0;
        for (RexNode filter : filters) {
            filterValues[index] = filter.toString();
            ++index;
        }
    }

    @Generated
    public FederationTranslatableTable getTranslatableTable() {
        return this.translatableTable;
    }

    @Generated
    public int[] getFields() {
        return this.fields;
    }

    @Generated
    public List<RexNode> getFilters() {
        return this.filters;
    }

    @Generated
    public int getNumber() {
        return this.number;
    }

    @Generated
    public List<RexNode> getExpressions() {
        return this.expressions;
    }
}

