/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.util;

import lombok.Generated;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class SQLFederationDataTypeUtil {
    public static RelDataType createRelDataType(ShardingSphereTable table, RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = typeFactory.builder();
        for (ShardingSphereColumn each : table.getColumns().values()) {
            fieldInfoBuilder.add(each.getName(), SQLFederationDataTypeUtil.getRelDataType(each, typeFactory));
        }
        return fieldInfoBuilder.build();
    }

    private static RelDataType getRelDataType(ShardingSphereColumn column, RelDataTypeFactory typeFactory) {
        Class sqlTypeClass = SqlType.valueOf((int)column.getDataType()).clazz;
        RelDataType javaType = typeFactory.createJavaType(sqlTypeClass);
        return typeFactory.createTypeWithNullability(javaType, true);
    }

    @Generated
    private SQLFederationDataTypeUtil() {
    }
}

