/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.optimizer.RemoveRedundantSortsSuite$;
import org.apache.spark.sql.catalyst.optimizer.RemoveRedundantSortsSuite$Optimize$;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase$class;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Range;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u001f\tI\"+Z7pm\u0016\u0014V\rZ;oI\u0006tGoU8siN\u001cV/\u001b;f\u0015\t\u0019A!A\u0005paRLW.\u001b>fe*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000b\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)\u0001\u000f\\1og&\u0011\u0011D\u0006\u0002\t!2\fg\u000eV3ti\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011AA\u0004\u0006A\u0001A\t!I\u0001\t\u001fB$\u0018.\\5{KB\u0011!eI\u0007\u0002\u0001\u0019)A\u0005\u0001E\u0001K\tAq\n\u001d;j[&TXm\u0005\u0002$MA\u0019qE\u000b\u0017\u000e\u0003!R!!\u000b\u0003\u0002\u000bI,H.Z:\n\u0005-B#\u0001\u0004*vY\u0016,\u00050Z2vi>\u0014\bCA\u00171\u001b\u0005q#BA\u0018\u0017\u0003\u001dawnZ5dC2L!!\r\u0018\u0003\u00171{w-[2bYBc\u0017M\u001c\u0005\u00067\r\"\ta\r\u000b\u0002C!9Qg\tb\u0001\n\u00031\u0014a\u00022bi\u000eDWm]\u000b\u0002oA\u0019\u0001hP!\u000e\u0003eR!AO\u001e\u0002\u0013%lW.\u001e;bE2,'B\u0001\u001f>\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u000f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002C\u00076\t1%\u0003\u0002EU\t)!)\u0019;dQ\"1ai\tQ\u0001\n]\n\u0001BY1uG\",7\u000f\t\u0005\b\u0011\u0002\u0011\r\u0011\"\u0001J\u00031!Xm\u001d;SK2\fG/[8o+\u0005Q\u0005CA\u0017L\u0013\taeFA\u0007M_\u000e\fGNU3mCRLwN\u001c\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002&\u0002\u001bQ,7\u000f\u001e*fY\u0006$\u0018n\u001c8!\u0001")
public class RemoveRedundantSortsSuite
extends SparkFunSuite
implements PlanTest {
    private final LocalRelation testRelation;
    private volatile RemoveRedundantSortsSuite$Optimize$ Optimize$module;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("a");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("b");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("c");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoveRedundantSortsSuite$Optimize$ Optimize$lzycompute() {
        RemoveRedundantSortsSuite removeRedundantSortsSuite = this;
        synchronized (removeRedundantSortsSuite) {
            if (this.Optimize$module != null) return this.Optimize$module;
            this.Optimize$module = new RemoveRedundantSortsSuite$Optimize$(this);
            return this.Optimize$module;
        }
    }

    @Override
    public SQLConf conf() {
        return PlanTestBase$class.conf(this);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase$class.normalizeExprIds(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase$class.normalizePlan(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase$class.comparePlans(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase$class.compareExpressions(this, e1, e2);
    }

    @Override
    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase$class.compareJoinOrder(this, plan1, plan2);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f2) {
        PlanTestBase$class.withSQLConf(this, pairs, f2);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase$class.comparePlans$default$3(this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.class.canEvaluateWithinJoin((PredicateHelper)this, (Expression)expr);
    }

    public RemoveRedundantSortsSuite$Optimize$ Optimize() {
        return this.Optimize$module == null ? this.Optimize$lzycompute() : this.Optimize$module;
    }

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public RemoveRedundantSortsSuite() {
        PredicateHelper.class.$init$((PredicateHelper)this);
        PlanTestBase$class.$init$(this);
        this.testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol(symbol$1).int(), package.expressions$.MODULE$.DslSymbol(symbol$2).int(), package.expressions$.MODULE$.DslSymbol(symbol$3).int()}));
        this.test("SPARK-33183: remove redundant sort by", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$4;
            private static Symbol symbol$5;

            static {
                symbol$4 = Symbol$.MODULE$.apply("a");
                symbol$5 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$4), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$5)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$4).asc(), package.expressions$.MODULE$.DslSymbol(symbol$5).desc_nullsFirst()}));
                LogicalPlan unnecessaryReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$4)}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$4).asc(), package.expressions$.MODULE$.DslSymbol(symbol$5).desc_nullsFirst()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(unnecessaryReordered).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$4)}))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("SPARK-33183: remove all redundant local sorts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$6;

            static {
                symbol$6 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$6).asc()}))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("SPARK-33183: should not remove global sort", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$7;
            private static Symbol symbol$8;

            static {
                symbol$7 = Symbol$.MODULE$.apply("a");
                symbol$8 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$7), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).desc_nullsFirst()}));
                LogicalPlan reordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$7)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$7).asc(), package.expressions$.MODULE$.DslSymbol(symbol$8).desc_nullsFirst()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reordered).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(reordered).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("do not remove sort if the order is different", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$9;
            private static Symbol symbol$10;

            static {
                symbol$9 = Symbol$.MODULE$.apply("a");
                symbol$10 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$9).asc(), package.expressions$.MODULE$.DslSymbol(symbol$10).desc_nullsFirst()}));
                LogicalPlan reorderedDifferently = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)package.expressions$.MODULE$.intToLiteral(2))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$9).asc(), package.expressions$.MODULE$.DslSymbol(symbol$10).desc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reorderedDifferently).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(reorderedDifferently).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("SPARK-33183: remove top level local sort with filter operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$11;
            private static Symbol symbol$12;

            static {
                symbol$11 = Symbol$.MODULE$.apply("a");
                symbol$12 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$11).asc(), package.expressions$.MODULE$.DslSymbol(symbol$12).desc()}));
                LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$11).asc(), package.expressions$.MODULE$.DslSymbol(symbol$12).desc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$11).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("SPARK-33183: keep top level global sort with filter operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$13;
            private static Symbol symbol$14;

            static {
                symbol$13 = Symbol$.MODULE$.apply("a");
                symbol$14 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan projectPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)}));
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(projectPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$13).asc(), package.expressions$.MODULE$.DslSymbol(symbol$14).desc()}));
                LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$13).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$13).asc(), package.expressions$.MODULE$.DslSymbol(symbol$14).desc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(projectPlan).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$13).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$13).asc(), package.expressions$.MODULE$.DslSymbol(symbol$14).desc()}))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("SPARK-33183: limits should not affect order for local sort", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$15;
            private static Symbol symbol$16;

            static {
                symbol$15 = Symbol$.MODULE$.apply("a");
                symbol$16 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$15), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$16)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$15).asc(), package.expressions$.MODULE$.DslSymbol(symbol$16).desc()}));
                LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$15).asc(), package.expressions$.MODULE$.DslSymbol(symbol$16).desc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("SPARK-33183: should not remove global sort with limit operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$17;
            private static Symbol symbol$18;

            static {
                symbol$17 = Symbol$.MODULE$.apply("a");
                symbol$18 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$17), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$18)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$17).asc(), package.expressions$.MODULE$.DslSymbol(symbol$18).desc()}));
                LogicalPlan filteredAndReordered = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$17).asc(), package.expressions$.MODULE$.DslSymbol(symbol$18).desc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(filteredAndReordered).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("different sorts are not simplified if limit is in between", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$19;
            private static Symbol symbol$20;

            static {
                symbol$19 = Symbol$.MODULE$.apply("a");
                symbol$20 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$19), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$20)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$20).desc()}))).limit((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$19).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("SPARK-33183: should not remove global sort with range operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$21;

            static {
                symbol$21 = Symbol$.MODULE$.apply("id");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Range inputPlan = Range$.MODULE$.apply(1L, 1000L, 1L, 10);
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$21).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
                LogicalPlan reversedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$21).desc()}));
                LogicalPlan reversedOptimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(reversedPlan).analyze());
                LogicalPlan reversedCorrectAnswer = package.plans$.MODULE$.DslLogicalPlan(reversedPlan).analyze();
                this.$outer.comparePlans(reversedOptimized, reversedCorrectAnswer, this.$outer.comparePlans$default$3());
                Range negativeStepInputPlan = Range$.MODULE$.apply(10L, 1L, -1L, 10);
                LogicalPlan negativeStepOrderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)negativeStepInputPlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$21).desc()}));
                LogicalPlan negativeStepOptimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(negativeStepOrderedPlan).analyze());
                LogicalPlan negativeStepCorrectAnswer = package.plans$.MODULE$.DslLogicalPlan(negativeStepOrderedPlan).analyze();
                this.$outer.comparePlans(negativeStepOptimized, negativeStepCorrectAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("SPARK-33183: remove local sort with range operator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$22;

            static {
                symbol$22 = Symbol$.MODULE$.apply("id");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Range inputPlan = Range$.MODULE$.apply(1L, 1000L, 1L, 10);
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$22).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)inputPlan).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("sort should not be removed when there is a node which doesn't guarantee any order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$23;
            private static Symbol symbol$24;

            static {
                symbol$23 = Symbol$.MODULE$.apply("a");
                symbol$24 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$23), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$24)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$23).asc()}));
                LogicalPlan groupedAndResorted = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedPlan).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$23)}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$23))}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$23).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(groupedAndResorted).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(groupedAndResorted).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        this.test("remove two consecutive sorts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$25;
            private static Symbol symbol$26;

            static {
                symbol$25 = Symbol$.MODULE$.apply("a");
                symbol$26 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedTwice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$25).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$26).desc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwice).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$26).desc()}))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("remove sorts separated by Filter/Project operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$27;
            private static Symbol symbol$28;
            private static Symbol symbol$29;

            static {
                symbol$27 = Symbol$.MODULE$.apply("a");
                symbol$28 = Symbol$.MODULE$.apply("b");
                symbol$29 = Symbol$.MODULE$.apply("c");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedTwiceWithProject = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$27).asc()}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$28)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$28).desc()}));
                LogicalPlan optimizedWithProject = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithProject).analyze());
                LogicalPlan correctAnswerWithProject = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$28)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$28).desc()}))).analyze();
                this.$outer.comparePlans(optimizedWithProject, correctAnswerWithProject, this.$outer.comparePlans$default$3());
                LogicalPlan orderedTwiceWithFilter = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$27).asc()}))).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$28).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$28).desc()}));
                LogicalPlan optimizedWithFilter = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithFilter).analyze());
                LogicalPlan correctAnswerWithFilter = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$28).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$28).desc()}))).analyze();
                this.$outer.comparePlans(optimizedWithFilter, correctAnswerWithFilter, this.$outer.comparePlans$default$3());
                LogicalPlan orderedTwiceWithBoth = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$27).asc()}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$28)}))).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$28).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$28).desc()}));
                LogicalPlan optimizedWithBoth = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithBoth).analyze());
                LogicalPlan correctAnswerWithBoth = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$28)}))).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$28).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$28).desc()}))).analyze();
                this.$outer.comparePlans(optimizedWithBoth, correctAnswerWithBoth, this.$outer.comparePlans$default$3());
                LogicalPlan orderedThrice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(orderedTwiceWithBoth).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(symbol$28).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as(symbol$29)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$29).asc()}));
                LogicalPlan optimizedThrice = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedThrice).analyze());
                LogicalPlan correctAnswerThrice = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$28)}))).where((Expression)package.expressions$.MODULE$.DslSymbol(symbol$28).$greater((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslSymbol(symbol$28).$plus((Expression)package.expressions$.MODULE$.intToLiteral(1))).as(symbol$29)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$29).asc()}))).analyze();
                this.$outer.comparePlans(optimizedThrice, correctAnswerThrice, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("SPARK-33183: remove consecutive global sorts with the same ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$30;
            private static Symbol symbol$31;

            static {
                symbol$30 = Symbol$.MODULE$.apply("a");
                symbol$31 = Symbol$.MODULE$.apply("b");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$30).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$30).asc()})), (Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$30).asc()}))), new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$30).asc(), package.expressions$.MODULE$.DslSymbol(symbol$31).desc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$30).asc()})), (Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$30).asc()})))}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(Tuple2<LogicalPlan, LogicalPlan> x0$1) {
                        Tuple2<LogicalPlan, LogicalPlan> tuple2 = x0$1;
                        if (tuple2 != null) {
                            LogicalPlan ordered = (LogicalPlan)tuple2._1();
                            LogicalPlan answer = (LogicalPlan)tuple2._2();
                            LogicalPlan optimized = (LogicalPlan)this.$outer.org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer().Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(ordered).analyze());
                            this.$outer.org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer().comparePlans(optimized, package.plans$.MODULE$.DslLogicalPlan(answer).analyze(), this.$outer.org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer().comparePlans$default$3());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RemoveRedundantSortsSuite org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("SPARK-33183: remove consecutive local sorts with the same ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$32;

            static {
                symbol$32 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$32).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$32).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$32).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$32).asc()}))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        this.test("SPARK-33183: remove consecutive local sorts with different ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$33;
            private static Symbol symbol$34;

            static {
                symbol$33 = Symbol$.MODULE$.apply("b");
                symbol$34 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan orderedPlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$33).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$34).desc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$34).asc()}));
                LogicalPlan optimized = (LogicalPlan)this.$outer.Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(orderedPlan).analyze());
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$34).asc()}))).analyze();
                this.$outer.comparePlans(optimized, correctAnswer, this.$outer.comparePlans$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("SPARK-33183: should keep global sort when child is a local sort with the same ordering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RemoveRedundantSortsSuite $outer;
            private static Symbol symbol$35;

            static {
                symbol$35 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan correctAnswer = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$35).asc()}))).analyze();
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalPlan[]{package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$35).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$35).asc()})), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation()).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$35).asc()}))).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$35).asc()}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslSymbol(symbol$35).asc()}))}))).foreach((Function1)new Serializable(this, correctAnswer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;
                    private final LogicalPlan correctAnswer$1;

                    public final void apply(LogicalPlan ordered) {
                        LogicalPlan optimized = (LogicalPlan)this.$outer.org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer().Optimize().execute((TreeNode)package.plans$.MODULE$.DslLogicalPlan(ordered).analyze());
                        this.$outer.org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer().comparePlans(optimized, this.correctAnswer$1, this.$outer.org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer().comparePlans$default$3());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.correctAnswer$1 = correctAnswer$1;
                    }
                });
            }

            public /* synthetic */ RemoveRedundantSortsSuite org$apache$spark$sql$catalyst$optimizer$RemoveRedundantSortsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RemoveRedundantSortsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
    }
}

