/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.execution.aggregate.HashMapGenerator;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\tQb+Z2u_JL'0\u001a3ICNDW*\u00199HK:,'/\u0019;pe*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tICNDW*\u00199HK:,'/\u0019;pe\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0002dib\u0004\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u000f\r|G-Z4f]*\u00111\u0004H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001e\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002 1\tq1i\u001c3fO\u0016t7i\u001c8uKb$\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002)\u0005<wM]3hCR,W\t\u001f9sKN\u001c\u0018n\u001c8t!\r\u0019S\u0006\r\b\u0003I)r!!\n\u0015\u000e\u0003\u0019R!a\n\b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013!B:dC2\f\u0017BA\u0016-\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!K\u0005\u0003]=\u00121aU3r\u0015\tYC\u0006\u0005\u00022g5\t!G\u0003\u0002\u00045%\u0011AG\r\u0002\u0014\u0003\u001e<'/Z4bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005\u0011r-\u001a8fe\u0006$X\rZ\"mCN\u001ch*Y7f!\tADH\u0004\u0002:uA\u0011Q\u0005L\u0005\u0003w1\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111\b\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006\trM]8va&twmS3z'\u000eDW-\\1\u0011\u0005\t+U\"A\"\u000b\u0005\u00113\u0011!\u0002;za\u0016\u001c\u0018B\u0001$D\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0003\u0006a!-\u001e4gKJ\u001c6\r[3nC\"A!\n\u0001B\u0001B\u0003%1*\u0001\bcSRl\u0015\r_\"ba\u0006\u001c\u0017\u000e^=\u0011\u00051kU\"\u0001\u0017\n\u00059c#aA%oi\")\u0001\u000b\u0001C\u0001#\u00061A(\u001b8jiz\"rAU*U+Z;\u0006\f\u0005\u0002\u0012\u0001!)Qc\u0014a\u0001-!)\u0011e\u0014a\u0001E!)ag\u0014a\u0001o!)\u0001i\u0014a\u0001\u0003\")\u0001j\u0014a\u0001\u0003\")!j\u0014a\u0001\u0017\")!\f\u0001C)7\u0006Q\u0012N\\5uS\u0006d\u0017N_3BO\u001e\u0014XmZ1uK\"\u000b7\u000f['baR\tq\u0007C\u0003^\u0001\u0011E1,\u0001\bhK:,'/\u0019;f\u000bF,\u0018\r\\:\t\u000b}\u0003A\u0011C.\u0002)\u001d,g.\u001a:bi\u00164\u0015N\u001c3Pe&s7/\u001a:u\u0011\u0015\t\u0007\u0001\"\u0005\\\u0003M9WM\\3sCR,'k\\<Ji\u0016\u0014\u0018\r^8s\u0001")
public class VectorizedHashMapGenerator
extends HashMapGenerator {
    private final CodegenContext ctx;
    private final String generatedClassName;
    private final StructType groupingKeySchema;
    private final StructType bufferSchema;
    private final int bitMaxCapacity;

    @Override
    public String initializeAggregateHashMap() {
        StructType schemaStructType = new StructType((StructField[])((TraversableOnce)this.groupingKeySchema.$plus$plus((GenTraversableOnce)this.bufferSchema, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class)));
        String schema = this.ctx.addReferenceObj("schemaTerm", (Object)schemaStructType, this.ctx.addReferenceObj$default$3());
        int aggBufferSchemaFieldsLength = this.bufferSchema.fields().length;
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(875).append("\n       |  private ").append(OnHeapColumnVector.class.getName()).append("[] vectors;\n       |  private ").append(ColumnarBatch.class.getName()).append(" batch;\n       |  private ").append(MutableColumnarRow.class.getName()).append(" aggBufferRow;\n       |  private int[] buckets;\n       |  private int capacity = 1 << ").append(this.bitMaxCapacity).append(";\n       |  private double loadFactor = 0.5;\n       |  private int numBuckets = (int) (capacity / loadFactor);\n       |  private int maxSteps = 2;\n       |  private int numRows = 0;\n       |\n       |  public ").append(this.generatedClassName).append("() {\n       |    vectors = ").append(OnHeapColumnVector.class.getName()).append(".allocateColumns(capacity, ").append(schema).append(");\n       |    batch = new ").append(ColumnarBatch.class.getName()).append("(vectors);\n       |\n       |    // Generates a projection to return the aggregate buffer only.\n       |    ").append(OnHeapColumnVector.class.getName()).append("[] aggBufferVectors =\n       |      new ").append(OnHeapColumnVector.class.getName()).append("[").append(aggBufferSchemaFieldsLength).append("];\n       |    for (int i = 0; i < ").append(aggBufferSchemaFieldsLength).append("; i++) {\n       |      aggBufferVectors[i] = vectors[i + ").append(this.groupingKeys().length()).append("];\n       |    }\n       |    aggBufferRow = new ").append(MutableColumnarRow.class.getName()).append("(aggBufferVectors);\n       |\n       |    buckets = new int[numBuckets];\n       |    java.util.Arrays.fill(buckets, -1);\n       |  }\n     ").toString())).stripMargin();
    }

    @Override
    public String generateEquals() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n       |private boolean equals(int idx, ").append(this.groupingKeySignature()).append(") {\n       |  return ").append(this.genEqualsForKeys$1(this.groupingKeys())).append(";\n       |}\n     ").toString())).stripMargin();
    }

    @Override
    public String generateFindOrInsert() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1033).append("\n       |public ").append(MutableColumnarRow.class.getName()).append(" findOrInsert(").append(this.groupingKeySignature()).append(") {\n       |  long h = hash(").append(((TraversableOnce)this.groupingKeys().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n       |  int step = 0;\n       |  int idx = (int) h & (numBuckets - 1);\n       |  while (step < maxSteps) {\n       |    // Return bucket index if it's either an empty slot or already contains the key\n       |    if (buckets[idx] == -1) {\n       |      if (numRows < capacity) {\n       |\n       |        // Initialize aggregate keys\n       |        ").append(VectorizedHashMapGenerator.genCodeToSetKeys$1(this.groupingKeys()).mkString("\n")).append("\n       |\n       |        ").append(((TraversableOnce)this.buffVars().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n       |\n       |        // Initialize aggregate values\n       |        ").append(this.genCodeToSetAggBuffers$1(this.bufferValues()).mkString("\n")).append("\n       |\n       |        buckets[idx] = numRows++;\n       |        aggBufferRow.rowId = buckets[idx];\n       |        return aggBufferRow;\n       |      } else {\n       |        // No more space\n       |        return null;\n       |      }\n       |    } else if (equals(idx, ").append(((TraversableOnce)this.groupingKeys().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")) {\n       |      aggBufferRow.rowId = buckets[idx];\n       |      return aggBufferRow;\n       |    }\n       |    idx = (idx + 1) & (numBuckets - 1);\n       |    step++;\n       |  }\n       |  // Didn't find it\n       |  return null;\n       |}\n     ").toString())).stripMargin();
    }

    @Override
    public String generateRowIterator() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n       |public java.util.Iterator<").append(InternalRow.class.getName()).append("> rowIterator() {\n       |  batch.setNumRows(numRows);\n       |  return batch.rowIterator();\n       |}\n     ").toString())).stripMargin();
    }

    private final String genEqualsForKeys$1(Seq groupingKeys) {
        return ((TraversableOnce)((TraversableLike)groupingKeys.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int ordinal;
            HashMapGenerator.Buffer key;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    key = (HashMapGenerator.Buffer)tuple2._1();
                    ordinal = tuple2._2$mcI$sp();
                    if (key != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            HashMapGenerator.Buffer buffer = key;
            int n = ordinal;
            String value = CodeGenerator$.MODULE$.getValueFromVector(new StringBuilder(9).append("vectors[").append(n).append("]").toString(), buffer.dataType(), "buckets[idx]");
            String string = new StringBuilder(2).append("(").append($this.ctx.genEqual(buffer.dataType(), value, buffer.name())).append(")").toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(" && ");
    }

    private static final Seq genCodeToSetKeys$1(Seq groupingKeys) {
        return (Seq)((TraversableLike)groupingKeys.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            int ordinal;
            HashMapGenerator.Buffer key;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    key = (HashMapGenerator.Buffer)tuple2._1();
                    ordinal = tuple2._2$mcI$sp();
                    if (key != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            HashMapGenerator.Buffer buffer = key;
            int n = ordinal;
            String string = CodeGenerator$.MODULE$.setValue(new StringBuilder(9).append("vectors[").append(n).append("]").toString(), "numRows", buffer.dataType(), buffer.name());
            return string;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private final Seq genCodeToSetAggBuffers$1(Seq bufferValues) {
        return (Seq)((TraversableLike)bufferValues.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            int ordinal;
            HashMapGenerator.Buffer key;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$3;
                    if (tuple2 == null) break block2;
                    key = (HashMapGenerator.Buffer)tuple2._1();
                    ordinal = tuple2._2$mcI$sp();
                    if (key != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            HashMapGenerator.Buffer buffer = key;
            int n = ordinal;
            String string = CodeGenerator$.MODULE$.updateColumn(new StringBuilder(9).append("vectors[").append(this.groupingKeys().length() + n).append("]").toString(), "numRows", buffer.dataType(), (ExprCode)this.buffVars().apply(n), true);
            return string;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public VectorizedHashMapGenerator(CodegenContext ctx, Seq<AggregateExpression> aggregateExpressions, String generatedClassName, StructType groupingKeySchema, StructType bufferSchema, int bitMaxCapacity) {
        this.ctx = ctx;
        this.generatedClassName = generatedClassName;
        this.groupingKeySchema = groupingKeySchema;
        this.bufferSchema = bufferSchema;
        this.bitMaxCapacity = bitMaxCapacity;
        super(ctx, aggregateExpressions, generatedClassName, groupingKeySchema, bufferSchema);
    }
}

