/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.IntDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.IntegerType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005uxAB\u0001\u0003\u0011\u0003#\u0001#\u0001\u0005J]R$U\r\u001c;b\u0015\t\u0019A!A\u0006d_6\u0004(/Z:tS>t'BA\u0003\u0007\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u0004\"!\u0005\n\u000e\u0003\t1aa\u0005\u0002\t\u0002\u0012!\"\u0001C%oi\u0012+G\u000e^1\u0014\u000bI)2DH\u0011\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\t\tB$\u0003\u0002\u001e\u0005\t\t2i\\7qe\u0016\u001c8/[8o'\u000eDW-\\3\u0011\u0005Yy\u0012B\u0001\u0011\u0018\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0006\u0012\n\u0005\r:\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0013\u0013\t\u00039\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003AAQ!\u000b\n\u0005B)\na\u0001^=qK&#W#A\u0016\u0011\u0005Ya\u0013BA\u0017\u0018\u0005\rIe\u000e\u001e\u0005\u0006_I!\t\u0005M\u0001\bI\u0016\u001cw\u000eZ3s+\t\tt\u0007F\u00023\u00076\u00032!E\u001a6\u0013\t!$AA\u0004EK\u000e|G-\u001a:\u0011\u0005Y:D\u0002\u0001\u0003\u0006q9\u0012\r!\u000f\u0002\u0002)F\u0011!(\u0010\t\u0003-mJ!\u0001P\f\u0003\u000f9{G\u000f[5oOB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tC\u0001\u0006if\u0004Xm]\u0005\u0003\u0005~\u0012!\"\u0011;p[&\u001cG+\u001f9f\u0011\u0015!e\u00061\u0001F\u0003\u0019\u0011WO\u001a4feB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0004]&|'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013!BQ=uK\n+hMZ3s\u0011\u0015qe\u00061\u0001P\u0003)\u0019w\u000e\\;n]RK\b/\u001a\t\u0004!F+T\"\u0001\u0003\n\u0005I#!\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f\u0011\u0015!&\u0003\"\u0011V\u0003\u001d)gnY8eKJ,\"AV.\u0015\u0005]c\u0006cA\tY5&\u0011\u0011L\u0001\u0002\b\u000b:\u001cw\u000eZ3s!\t14\fB\u00039'\n\u0007\u0011\bC\u0003O'\u0002\u0007Q\fE\u0002Q#jCQa\u0018\n\u0005B\u0001\f\u0001b];qa>\u0014Ho\u001d\u000b\u0003C\u0012\u0004\"A\u00062\n\u0005\r<\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001dz\u0003\r!\u001a\u0019\u0003M*\u00042\u0001U4j\u0013\tAGA\u0001\u0006D_2,XN\u001c+za\u0016\u0004\"A\u000e6\u0005\u0013-$\u0017\u0011!A\u0001\u0006\u0003a'aA0%kE\u0011!(\u001c\t\u0003-9L!a\\\f\u0003\u0007\u0005s\u0017P\u0002\u0003Z%\u0001\t8c\u00019\u0016eB\u0019\u0011\u0003W:\u000f\u0005y\"\u0018BA;@\u0003-Ie\u000e^3hKJ$\u0016\u0010]3\t\u000b\u0015\u0002H\u0011A<\u0015\u0003a\u0004\"!\u001f9\u000e\u0003IAqa\u001f9A\u0002\u0013E!&A\b`G>l\u0007O]3tg\u0016$7+\u001b>f\u0011\u001di\b\u000f1A\u0005\u0012y\f1cX2p[B\u0014Xm]:fINK'0Z0%KF$2a`A\u0003!\r1\u0012\u0011A\u0005\u0004\u0003\u00079\"\u0001B+oSRD\u0001\"a\u0002}\u0003\u0003\u0005\raK\u0001\u0004q\u0012\n\u0004bBA\u0006a\u0002\u0006KaK\u0001\u0011?\u000e|W\u000e\u001d:fgN,GmU5{K\u0002B\u0001\"a\u0004q\u0001\u0004%\tBK\u0001\u0012?Vt7m\\7qe\u0016\u001c8/\u001a3TSj,\u0007\"CA\na\u0002\u0007I\u0011CA\u000b\u0003UyVO\\2p[B\u0014Xm]:fINK'0Z0%KF$2a`A\f\u0011%\t9!!\u0005\u0002\u0002\u0003\u00071\u0006C\u0004\u0002\u001cA\u0004\u000b\u0015B\u0016\u0002%}+hnY8naJ,7o]3e'&TX\r\t\u0005\u0007\u0003?\u0001H\u0011\t\u0016\u0002\u001d\r|W\u000e\u001d:fgN,GmU5{K\"1\u00111\u00059\u0005B)\n\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\t\u0015\u0005\u001d\u0002\u000f1AA\u0002\u0013%!&A\u0005qe\u00164h+\u00197vK\"Y\u00111\u00069A\u0002\u0003\u0007I\u0011BA\u0017\u00035\u0001(/\u001a<WC2,Xm\u0018\u0013fcR\u0019q0a\f\t\u0013\u0005\u001d\u0011\u0011FA\u0001\u0002\u0004Y\u0003BCA\u001aa\u0002\u0007\t\u0011)Q\u0005W\u0005Q\u0001O]3w-\u0006dW/\u001a\u0011\t\u000f\u0005]\u0002\u000f\"\u0011\u0002:\u0005Qr-\u0019;iKJ\u001cu.\u001c9sKN\u001c\u0018NY5mSRL8\u000b^1ugR)q0a\u000f\u0002L!A\u0011QHA\u001b\u0001\u0004\ty$A\u0002s_^\u0004B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bB\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005%\u00131\t\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002N\u0005U\u0002\u0019A\u0016\u0002\u000f=\u0014H-\u001b8bY\"9\u0011\u0011\u000b9\u0005B\u0005M\u0013\u0001C2p[B\u0014Xm]:\u0015\u000b\u0015\u000b)&!\u0017\t\u000f\u0005]\u0013q\na\u0001\u000b\u0006!aM]8n\u0011\u001d\tY&a\u0014A\u0002\u0015\u000b!\u0001^8\u0007\u000bQ\u0012\u0002!a\u0018\u0014\u000b\u0005uS#!\u0019\u0011\u0007E\u00194\u000fC\u0005E\u0003;\u0012\t\u0011)A\u0005\u000b\"Qa*!\u0018\u0003\u0002\u0003\u0006I!a\u001a\u0011\u0007A\u000b6\u000fC\u0004&\u0003;\"\t!a\u001b\u0015\r\u00055\u0014qNA9!\rI\u0018Q\f\u0005\u0007\t\u0006%\u0004\u0019A#\t\u000f9\u000bI\u00071\u0001\u0002h!Y\u0011QOA/\u0001\u0004\u0005\r\u0011\"\u0003+\u0003\u0011\u0001(/\u001a<\t\u0019\u0005e\u0014Q\fa\u0001\u0002\u0004%I!a\u001f\u0002\u0011A\u0014XM^0%KF$2a`A?\u0011%\t9!a\u001e\u0002\u0002\u0003\u00071\u0006C\u0006\u0002\u0002\u0006u\u0003\u0019!A!B\u0013Y\u0013!\u00029sKZ\u0004\u0003\u0002CAC\u0003;\"\t%a\"\u0002\u000f!\f7OT3yiV\t\u0011\r\u0003\u0005\u0002\f\u0006uC\u0011IAG\u0003\u0011qW\r\u001f;\u0015\u000b}\fy)!%\t\u0011\u0005u\u0012\u0011\u0012a\u0001\u0003\u007fAq!!\u0014\u0002\n\u0002\u00071\u0006\u0003\u0005\u0002\u0016\u0006uC\u0011IAL\u0003)!WmY8naJ,7o\u001d\u000b\u0006\u007f\u0006e\u0015\u0011\u0016\u0005\t\u00037\u000b\u0019\n1\u0001\u0002\u001e\u0006a1m\u001c7v[:4Vm\u0019;peB!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$\u001a\t!B^3di>\u0014\u0018N_3e\u0013\u0011\t9+!)\u0003)]\u0013\u0018\u000e^1cY\u0016\u001cu\u000e\\;n]Z+7\r^8s\u0011\u001d\tY+a%A\u0002-\n\u0001bY1qC\u000eLG/\u001f\u0005\n\u0003_\u0013\u0012\u0011!C!\u0003c\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAZ!\u0011\t),a/\u000e\u0005\u0005]&bAA]\u0013\u0006!A.\u00198h\u0013\u0011\ti,a.\u0003\rM#(/\u001b8h\u0011!\t\tMEA\u0001\n\u0003Q\u0013\u0001\u00049s_\u0012,8\r^!sSRL\b\"CAc%\u0005\u0005I\u0011AAd\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!\\Ae\u0011%\t9!a1\u0002\u0002\u0003\u00071\u0006C\u0005\u0002NJ\t\t\u0011\"\u0011\u0002P\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002RB)\u00111[Am[6\u0011\u0011Q\u001b\u0006\u0004\u0003/<\u0012AC2pY2,7\r^5p]&!\u00111\\Ak\u0005!IE/\u001a:bi>\u0014\b\"CAp%\u0005\u0005I\u0011AAq\u0003!\u0019\u0017M\\#rk\u0006dGcA1\u0002d\"I\u0011qAAo\u0003\u0003\u0005\r!\u001c\u0005\n\u0003O\u0014\u0012\u0011!C!\u0003S\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002W!I\u0011Q\u001e\n\u0002\u0002\u0013\u0005\u0013q^\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0017\u0005\n\u0003g\u0014\u0012\u0011!C\u0005\u0003k\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001f\t\u0005\u0003k\u000bI0\u0003\u0003\u0002|\u0006]&AB(cU\u0016\u001cG\u000f")
public final class IntDelta {
    public static String toString() {
        return IntDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return IntDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return IntDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return IntDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return IntDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return IntDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return IntDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return IntDelta$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return IntDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return IntDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return IntDelta$.MODULE$.typeId();
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<IntegerType$> {
        private final ByteBuffer buffer;
        private int prev;

        private int prev() {
            return this.prev;
        }

        private void prev_$eq(int x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + delta : ByteBufferHelper$.MODULE$.getInt(this.buffer));
            row.setInt(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int prevLocal = 0;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + delta : ByteBufferHelper$.MODULE$.getInt(this.buffer);
                    columnVector.putInt(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<IntegerType$> columnType) {
            this.buffer = buffer;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<IntegerType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private int prevValue;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private int prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(int x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            int value = row.getInt(ordinal);
            int delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= -128 || delta > 127) {
                this._compressedSize_$eq(this._compressedSize() + INT$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + INT$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(IntDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                int prev = from.getInt();
                to.put((byte)-128);
                to.putInt(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    int current = from.getInt();
                    int delta = current - prev;
                    prev = current;
                    if (-128 < delta && delta <= 127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putInt(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }
}

