/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

public final class CSVInferSchema$ {
    public static CSVInferSchema$ MODULE$;
    private final IndexedSeq<DataType> numericPrecedence;
    private final Function2<DataType, DataType, Option<DataType>> findTightestCommonType;

    static {
        new CSVInferSchema$();
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header, CSVOptions options) {
        StructField[] structFieldArray;
        if (options.inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable & scala.Serializable)(rowSoFar, next) -> MODULE$.inferRowType(options, (DataType[])rowSoFar, (String[])next), (Function2 & Serializable & scala.Serializable)(first, second) -> MODULE$.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rootTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String thisHeader = (String)tuple2._1();
                DataType rootType = (DataType)tuple2._2();
                DataType dataType = rootType;
                Object object = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
                StringType$ dType = object;
                StructField structField = new StructField(thisHeader, (DataType)dType, true, StructField$.MODULE$.apply$default$4());
                return structField;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        } else {
            structFieldArray = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])header)).map((Function1 & Serializable & scala.Serializable)fieldName -> new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    private DataType[] inferRowType(CSVOptions options, DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i], options);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])first)).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            DataType dataType = (DataType)((Option)MODULE$.findTightestCommonType().apply((Object)a, (Object)b)).getOrElse((Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$);
            return dataType;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public DataType inferField(DataType typeSoFar, String field, CSVOptions options) {
        DataType dataType;
        DataType dataType2;
        block19: {
            block18: {
                if (field == null || field.isEmpty()) break block18;
                String string = field;
                String string2 = options.nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block19;
            }
            dataType2 = typeSoFar;
            return dataType2;
        }
        DataType dataType3 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field, options);
        } else if (IntegerType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseInteger(field, options);
        } else if (LongType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseLong(field, options);
        } else if (dataType3 instanceof DecimalType) {
            dataType = (DataType)((Option)this.findTightestCommonType().apply((Object)typeSoFar, (Object)this.tryParseDecimal(field, options))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
        } else if (DoubleType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseDouble(field, options);
        } else if (TimestampType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseTimestamp(field, options);
        } else if (BooleanType$.MODULE$.equals(dataType3)) {
            dataType = this.tryParseBoolean(field, options);
        } else {
            if (!StringType$.MODULE$.equals(dataType3)) {
                if (dataType3 == null) throw new MatchError((Object)dataType3);
                DataType dataType4 = dataType3;
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType4).toString());
            }
            dataType = StringType$.MODULE$;
        }
        dataType2 = dataType;
        return dataType2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field, CSVOptions options) {
        String string = field;
        String string2 = options.nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = options.negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = options.positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toInt()).isDefined() ? IntegerType$.MODULE$ : this.tryParseLong(field, options);
    }

    private DataType tryParseLong(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toLong()).isDefined() ? LongType$.MODULE$ : this.tryParseDecimal(field, options);
    }

    private DataType tryParseDecimal(String field, CSVOptions options) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = new BigDecimal(field);
            return bigDecimal.scale() <= 0 ? new DecimalType(bigDecimal.precision(), bigDecimal.scale()) : MODULE$.tryParseDouble(field, options);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.tryParseDouble(field, options));
    }

    private DataType tryParseDouble(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toDouble()).isDefined() || this.isInfOrNan(field, options) ? DoubleType$.MODULE$ : this.tryParseTimestamp(field, options);
    }

    private DataType tryParseTimestamp(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> options.timestampFormat().parse(field)).isDefined() ? TimestampType$.MODULE$ : (Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> DateTimeUtils$.MODULE$.stringToTime(field)).isDefined() ? TimestampType$.MODULE$ : this.tryParseBoolean(field, options));
    }

    private DataType tryParseBoolean(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(field)).toBoolean()).isDefined() ? BooleanType$.MODULE$ : this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    private IndexedSeq<DataType> numericPrecedence() {
        return this.numericPrecedence;
    }

    public Function2<DataType, DataType, Option<DataType>> findTightestCommonType() {
        return this.findTightestCommonType;
    }

    public static final /* synthetic */ boolean $anonfun$findTightestCommonType$2(Object elem) {
        return MODULE$.numericPrecedence().contains(elem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findTightestCommonType$3(DataType t1$1, DataType t2$1, DataType t) {
        DataType dataType = t;
        DataType dataType2 = t1$1;
        if (dataType == null) {
            if (dataType2 == null) return true;
        } else if (dataType.equals(dataType2)) return true;
        DataType dataType3 = t;
        DataType dataType4 = t2$1;
        if (dataType3 != null) {
            if (!dataType3.equals(dataType4)) return false;
            return true;
        }
        if (dataType4 == null) return true;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findTightestCommonType$1(DataType x0$3, DataType x1$1) {
        block5: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block4: {
                                                                var4_2 = new Tuple2((Object)x0$3, (Object)x1$1);
                                                                if (var4_2 == null) break block4;
                                                                t1 = (DataType)var4_2._1();
                                                                t2 = (DataType)var4_2._2();
                                                                v0 = t1;
                                                                var7_5 = t2;
                                                                if (v0 != null ? v0.equals(var7_5) == false : var7_5 != null) break block4;
                                                                var2_6 = new Some((Object)t1);
                                                                break block5;
                                                            }
                                                            if (var4_2 == null) break block6;
                                                            var8_7 = (DataType)var4_2._1();
                                                            t1 = (DataType)var4_2._2();
                                                            if (!NullType$.MODULE$.equals(var8_7)) break block6;
                                                            var2_6 = new Some((Object)t1);
                                                            break block5;
                                                        }
                                                        if (var4_2 == null) break block7;
                                                        t1 = (DataType)var4_2._1();
                                                        var11_10 = (DataType)var4_2._2();
                                                        if (!NullType$.MODULE$.equals(var11_10)) break block7;
                                                        var2_6 = new Some((Object)t1);
                                                        break block5;
                                                    }
                                                    if (var4_2 == null || !StringType$.MODULE$.equals(var12_11 = (DataType)var4_2._1())) break block8;
                                                    var2_6 = new Some((Object)StringType$.MODULE$);
                                                    break block5;
                                                }
                                                if (var4_2 == null || !StringType$.MODULE$.equals(var13_12 = (DataType)var4_2._2())) break block9;
                                                var2_6 = new Some((Object)StringType$.MODULE$);
                                                break block5;
                                            }
                                            if (var4_2 == null || !((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{t1 = (DataType)var4_2._1(), t2 = (DataType)var4_2._2()}))).forall((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$findTightestCommonType$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Object;)())) break block10;
                                            index = CSVInferSchema$.MODULE$.numericPrecedence().lastIndexWhere((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$findTightestCommonType$3$adapted(org.apache.spark.sql.types.DataType org.apache.spark.sql.types.DataType org.apache.spark.sql.types.DataType ), (Lorg/apache/spark/sql/types/DataType;)Ljava/lang/Object;)((DataType)t1, (DataType)t2));
                                            var2_6 = new Some(CSVInferSchema$.MODULE$.numericPrecedence().apply(index));
                                            break block5;
                                        }
                                        if (var4_2 == null) break block11;
                                        t1 = (DataType)var4_2._1();
                                        t2 = (DataType)var4_2._2();
                                        if (!(t1 instanceof IntegralType)) break block11;
                                        var19_18 = (IntegralType)t1;
                                        if (!(t2 instanceof DecimalType) || !(var20_19 = (DecimalType)t2).isWiderThan((DataType)var19_18)) break block11;
                                        var2_6 = new Some((Object)var20_19);
                                        break block5;
                                    }
                                    if (var4_2 == null) break block12;
                                    t1 = (DataType)var4_2._1();
                                    t2 = (DataType)var4_2._2();
                                    if (!(t1 instanceof DecimalType)) break block12;
                                    var23_22 = (DecimalType)t1;
                                    if (!(t2 instanceof IntegralType) || !var23_22.isWiderThan((DataType)(var24_23 = (IntegralType)t2))) break block12;
                                    var2_6 = new Some((Object)var23_22);
                                    break block5;
                                }
                                if (var4_2 == null) break block13;
                                t1 = (DataType)var4_2._1();
                                t2 = (DataType)var4_2._2();
                                if (!(t1 instanceof IntegralType)) break block13;
                                var27_26 = (IntegralType)t1;
                                if (!(t2 instanceof DecimalType)) break block13;
                                var28_27 = (DecimalType)t2;
                                var2_6 = (Option)CSVInferSchema$.MODULE$.findTightestCommonType().apply((Object)DecimalType$.MODULE$.forType((DataType)var27_26), (Object)var28_27);
                                break block5;
                            }
                            if (var4_2 == null) break block14;
                            t1 = (DataType)var4_2._1();
                            t2 = (DataType)var4_2._2();
                            if (!(t1 instanceof DecimalType)) break block14;
                            var31_30 = (DecimalType)t1;
                            if (!(t2 instanceof IntegralType)) break block14;
                            var32_31 = (IntegralType)t2;
                            var2_6 = (Option)CSVInferSchema$.MODULE$.findTightestCommonType().apply((Object)var31_30, (Object)DecimalType$.MODULE$.forType((DataType)var32_31));
                            break block5;
                        }
                        if (var4_2 == null || !DoubleType$.MODULE$.equals(var33_32 = (DataType)var4_2._1()) || !(var4_2._2() instanceof DecimalType)) break block15;
                        var3_33 = true;
                        break block16;
                    }
                    if (var4_2 == null) ** GOTO lbl-1000
                    var34_34 = (DataType)var4_2._2();
                    if (var4_2._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var34_34)) {
                        var3_33 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var3_33 = false;
                    }
                }
                if (!var3_33) break block17;
                var2_6 = new Some((Object)DoubleType$.MODULE$);
                break block5;
            }
            if (var4_2 == null) ** GOTO lbl-1000
            t1 = (DataType)var4_2._1();
            t2 = (DataType)var4_2._2();
            if (!(t1 instanceof DecimalType)) ** GOTO lbl-1000
            var37_37 = (DecimalType)t1;
            if (t2 instanceof DecimalType) {
                var38_38 = (DecimalType)t2;
                scale = package$.MODULE$.max(var37_37.scale(), var38_38.scale());
                range = package$.MODULE$.max(var37_37.precision() - var37_37.scale(), var38_38.precision() - var38_38.scale());
                var2_6 = range + scale > 38 ? new Some((Object)DoubleType$.MODULE$) : new Some((Object)new DecimalType(range + scale, scale));
            } else lbl-1000:
            // 3 sources

            {
                var2_6 = None$.MODULE$;
            }
        }
        return var2_6;
    }

    private CSVInferSchema$() {
        MODULE$ = this;
        this.numericPrecedence = TypeCoercion$.MODULE$.numericPrecedence();
        this.findTightestCommonType = CSVInferSchema$::$anonfun$findTightestCommonType$1;
    }

    public static final /* synthetic */ Object $anonfun$findTightestCommonType$2$adapted(Object elem) {
        return BoxesRunTime.boxToBoolean((boolean)CSVInferSchema$.$anonfun$findTightestCommonType$2(elem));
    }

    public static final /* synthetic */ Object $anonfun$findTightestCommonType$3$adapted(DataType t1$1, DataType t2$1, DataType t) {
        return BoxesRunTime.boxToBoolean((boolean)CSVInferSchema$.$anonfun$findTightestCommonType$3(t1$1, t2$1, t));
    }
}

