/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.MultipleWatermarkPolicy;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001>\u0011\u0001cV1uKJl\u0017M]6Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\f\u001d?A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!a\u0007\r\u0003\u000f1{wmZ5oOB\u0011\u0011#H\u0005\u0003=I\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0012A%\u0011\u0011E\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tG\u0001\u0011)\u001a!C\u0001I\u00051\u0001o\u001c7jGf,\u0012!\n\t\u0003M\u001dj\u0011AA\u0005\u0003Q\t\u0011q#T;mi&\u0004H.Z,bi\u0016\u0014X.\u0019:l!>d\u0017nY=\t\u0011)\u0002!\u0011#Q\u0001\n\u0015\nq\u0001]8mS\u000eL\b\u0005C\u0003-\u0001\u0011\u0005Q&\u0001\u0004=S:LGO\u0010\u000b\u0003]=\u0002\"A\n\u0001\t\u000b\rZ\u0003\u0019A\u0013\t\u000fE\u0002!\u0019!C\u0005e\u00051r\u000e]3sCR|'\u000fV8XCR,'/\\1sW6\u000b\u0007/F\u00014!\u0011!\u0014h\u000f \u000e\u0003UR!AN\u001c\u0002\u000f5,H/\u00192mK*\u0011\u0001HE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001e6\u0005\u001dA\u0015m\u001d5NCB\u0004\"!\u0005\u001f\n\u0005u\u0012\"aA%oiB\u0011\u0011cP\u0005\u0003\u0001J\u0011A\u0001T8oO\"1!\t\u0001Q\u0001\nM\nqc\u001c9fe\u0006$xN\u001d+p/\u0006$XM]7be.l\u0015\r\u001d\u0011\t\u000f\u0011\u0003\u0001\u0019!C\u0005\u000b\u0006\tr\r\\8cC2<\u0016\r^3s[\u0006\u00148.T:\u0016\u0003yBqa\u0012\u0001A\u0002\u0013%\u0001*A\u000bhY>\u0014\u0017\r\\,bi\u0016\u0014X.\u0019:l\u001bN|F%Z9\u0015\u0005%c\u0005CA\tK\u0013\tY%C\u0001\u0003V]&$\bbB'G\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\n\u0004BB(\u0001A\u0003&a(\u0001\nhY>\u0014\u0017\r\\,bi\u0016\u0014X.\u0019:l\u001bN\u0004\u0003\"B)\u0001\t\u0003\u0011\u0016\u0001D:fi^\u000bG/\u001a:nCJ\\GCA%T\u0011\u0015!\u0006\u000b1\u0001?\u00039qWm^,bi\u0016\u0014X.\u0019:l\u001bNDQA\u0016\u0001\u0005\u0002]\u000bq\"\u001e9eCR,w+\u0019;fe6\f'o\u001b\u000b\u0003\u0013bCQ!W+A\u0002i\u000bA\"\u001a=fGV$X\r\u001a)mC:\u0004\"a\u0017/\u000e\u0003\u0011I!!\u0018\u0003\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\"B0\u0001\t\u0003)\u0015\u0001E2veJ,g\u000e^,bi\u0016\u0014X.\u0019:l\u0011\u001d\t\u0007!!A\u0005\u0002\t\fAaY8qsR\u0011af\u0019\u0005\bG\u0001\u0004\n\u00111\u0001&\u0011\u001d)\u0007!%A\u0005\u0002\u0019\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001hU\t)\u0003nK\u0001j!\tQw.D\u0001l\u0015\taW.A\u0005v]\u000eDWmY6fI*\u0011aNE\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00019l\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\be\u0002\t\t\u0011\"\u0011t\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006!A.\u00198h\u0015\u0005I\u0018\u0001\u00026bm\u0006L!a\u001f<\u0003\rM#(/\u001b8h\u0011\u001di\b!!A\u0005\u0002y\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a\u000f\u0005\n\u0003\u0003\u0001\u0011\u0011!C\u0001\u0003\u0007\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0006\u0005-\u0001cA\t\u0002\b%\u0019\u0011\u0011\u0002\n\u0003\u0007\u0005s\u0017\u0010C\u0004N\u007f\u0006\u0005\t\u0019A\u001e\t\u0013\u0005=\u0001!!A\u0005B\u0005E\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0001CBA\u000b\u0003/\t)!D\u00018\u0013\r\tIb\u000e\u0002\t\u0013R,'/\u0019;pe\"I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0011qD\u0001\tG\u0006tW)];bYR!\u0011\u0011EA\u0014!\r\t\u00121E\u0005\u0004\u0003K\u0011\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u001b\u0006m\u0011\u0011!a\u0001\u0003\u000bA\u0011\"a\u000b\u0001\u0003\u0003%\t%!\f\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u000f\u0005\n\u0003c\u0001\u0011\u0011!C!\u0003g\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002i\"I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0013\u0011H\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0005\u00121\b\u0005\n\u001b\u0006U\u0012\u0011!a\u0001\u0003\u000b9q!a\u0010\u0003\u0011\u0003\t\t%\u0001\tXCR,'/\\1sWR\u0013\u0018mY6feB\u0019a%a\u0011\u0007\r\u0005\u0011\u0001\u0012AA#'\u0011\t\u0019\u0005E\u0010\t\u000f1\n\u0019\u0005\"\u0001\u0002JQ\u0011\u0011\u0011\t\u0005\t\u0003\u001b\n\u0019\u0005\"\u0001\u0002P\u0005)\u0011\r\u001d9msR\u0019a&!\u0015\t\u0011\u0005M\u00131\na\u0001\u0003+\nAaY8oMB!\u0011qKA-\u001b\u00051\u0011bAA.\r\ti!+\u001e8uS6,7i\u001c8gS\u001eD!\"!\u0014\u0002D\u0005\u0005I\u0011QA0)\rq\u0013\u0011\r\u0005\u0007G\u0005u\u0003\u0019A\u0013\t\u0015\u0005\u0015\u00141IA\u0001\n\u0003\u000b9'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0014q\u000e\t\u0005#\u0005-T%C\u0002\u0002nI\u0011aa\u00149uS>t\u0007\"CA9\u0003G\n\t\u00111\u0001/\u0003\rAH\u0005\r\u0005\u000b\u0003k\n\u0019%!A\u0005\n\u0005]\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u001f\u0011\u0007U\fY(C\u0002\u0002~Y\u0014aa\u00142kK\u000e$\b")
public class WatermarkTracker
implements Logging,
Product,
scala.Serializable {
    private final MultipleWatermarkPolicy policy;
    private final HashMap<Object, Object> operatorToWatermarkMap;
    private long globalWatermarkMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<MultipleWatermarkPolicy> unapply(WatermarkTracker watermarkTracker) {
        return WatermarkTracker$.MODULE$.unapply(watermarkTracker);
    }

    public static WatermarkTracker apply(MultipleWatermarkPolicy multipleWatermarkPolicy) {
        return WatermarkTracker$.MODULE$.apply(multipleWatermarkPolicy);
    }

    public static WatermarkTracker apply(RuntimeConfig runtimeConfig) {
        return WatermarkTracker$.MODULE$.apply(runtimeConfig);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public MultipleWatermarkPolicy policy() {
        return this.policy;
    }

    private HashMap<Object, Object> operatorToWatermarkMap() {
        return this.operatorToWatermarkMap;
    }

    private long globalWatermarkMs() {
        return this.globalWatermarkMs;
    }

    private void globalWatermarkMs_$eq(long x$1) {
        this.globalWatermarkMs = x$1;
    }

    public synchronized void setWatermark(long newWatermarkMs) {
        this.globalWatermarkMs_$eq(newWatermarkMs);
    }

    public synchronized void updateWatermark(SparkPlan executedPlan) {
        Seq watermarkOperators = executedPlan.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermarkExec) {
                    EventTimeWatermarkExec eventTimeWatermarkExec = (EventTimeWatermarkExec)A1;
                    object = eventTimeWatermarkExec;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof EventTimeWatermarkExec;
                return bl;
            }
        });
        if (watermarkOperators.isEmpty()) {
            return;
        }
        ((IterableLike)watermarkOperators.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                EventTimeWatermarkExec e = (EventTimeWatermarkExec)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (e.eventTimeStats().value().count() > 0L) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Observed event time stats ").append(index).append(": ").append(e.eventTimeStats().value()).toString());
                    long newWatermarkMs = e.eventTimeStats().value().max() - e.delayMs();
                    Option prevWatermarkMs = this.operatorToWatermarkMap().get((Object)BoxesRunTime.boxToInteger((int)index));
                    return prevWatermarkMs.isEmpty() || newWatermarkMs > BoxesRunTime.unboxToLong((Object)prevWatermarkMs.get()) ? this.operatorToWatermarkMap().put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToLong((long)newWatermarkMs)) : BoxedUnit.UNIT;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int index = tuple2._2$mcI$sp();
            return !this.operatorToWatermarkMap().isDefinedAt((Object)BoxesRunTime.boxToInteger((int)index)) ? this.operatorToWatermarkMap().put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToLong((long)0L)) : BoxedUnit.UNIT;
        });
        long chosenGlobalWatermark = this.policy().chooseGlobalWatermark((Seq<Object>)this.operatorToWatermarkMap().values().toSeq());
        if (chosenGlobalWatermark > this.globalWatermarkMs()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Updating event-time watermark from ").append(this.globalWatermarkMs()).append(" to ").append(chosenGlobalWatermark).append(" ms").toString());
            this.globalWatermarkMs_$eq(chosenGlobalWatermark);
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Event time watermark didn't move: ").append(chosenGlobalWatermark).append(" < ").append(this.globalWatermarkMs()).toString());
        }
    }

    public synchronized long currentWatermark() {
        return this.globalWatermarkMs();
    }

    public WatermarkTracker copy(MultipleWatermarkPolicy policy) {
        return new WatermarkTracker(policy);
    }

    public MultipleWatermarkPolicy copy$default$1() {
        return this.policy();
    }

    public String productPrefix() {
        return "WatermarkTracker";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.policy();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WatermarkTracker;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WatermarkTracker)) return false;
        boolean bl = true;
        if (!bl) return false;
        WatermarkTracker watermarkTracker = (WatermarkTracker)x$1;
        MultipleWatermarkPolicy multipleWatermarkPolicy = this.policy();
        MultipleWatermarkPolicy multipleWatermarkPolicy2 = watermarkTracker.policy();
        if (multipleWatermarkPolicy == null) {
            if (multipleWatermarkPolicy2 != null) {
                return false;
            }
        } else if (!multipleWatermarkPolicy.equals(multipleWatermarkPolicy2)) return false;
        if (!watermarkTracker.canEqual(this)) return false;
        return true;
    }

    public WatermarkTracker(MultipleWatermarkPolicy policy) {
        this.policy = policy;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.operatorToWatermarkMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.globalWatermarkMs = 0L;
    }
}

