/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.util.Locale;
import java.util.Optional;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.streaming.BaseStreamingSource;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.execution.streaming.StreamingRelationV2;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u00055\u0011\u0001\u0003R1uCN#(/Z1n%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005a1\u000f]1sWN+7o]5p]B\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0007C\u0001!\t\u0001\u0002\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001cA\u0001\u0007A\u0004C\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0003G%BQA\u000b\u0014A\u0002-\naa]8ve\u000e,\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/!5\tqF\u0003\u00021\u0019\u00051AH]8pizJ!A\r\t\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003eAAQa\u000e\u0001\u0005\u0002a\naa]2iK6\fGCA\u0012:\u0011\u00159d\u00071\u0001;!\tYd(D\u0001=\u0015\tiD!A\u0003usB,7/\u0003\u0002@y\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b]\u0002A\u0011A!\u0015\u0005\r\u0012\u0005\"B\"A\u0001\u0004Y\u0013\u0001D:dQ\u0016l\u0017m\u0015;sS:<\u0007\"B#\u0001\t\u00031\u0015AB8qi&|g\u000eF\u0002$\u000f&CQ\u0001\u0013#A\u0002-\n1a[3z\u0011\u0015QE\t1\u0001,\u0003\u00151\u0018\r\\;f\u0011\u0015)\u0005\u0001\"\u0001M)\r\u0019SJ\u0014\u0005\u0006\u0011.\u0003\ra\u000b\u0005\u0006\u0015.\u0003\ra\u0014\t\u0003\u001fAK!!\u0015\t\u0003\u000f\t{w\u000e\\3b]\")Q\t\u0001C\u0001'R\u00191\u0005V+\t\u000b!\u0013\u0006\u0019A\u0016\t\u000b)\u0013\u0006\u0019\u0001,\u0011\u0005=9\u0016B\u0001-\u0011\u0005\u0011auN\\4\t\u000b\u0015\u0003A\u0011\u0001.\u0015\u0007\rZF\fC\u0003I3\u0002\u00071\u0006C\u0003K3\u0002\u0007Q\f\u0005\u0002\u0010=&\u0011q\f\u0005\u0002\u0007\t>,(\r\\3\t\u000b\u0005\u0004A\u0011\u00012\u0002\u000f=\u0004H/[8ogR\u00111e\u0019\u0005\u0006C\u0002\u0004\r\u0001\u001a\t\u0005K\"\\3&D\u0001g\u0015\t9\u0007#\u0001\u0006d_2dWm\u0019;j_:L!!\u001b4\u0003\u00075\u000b\u0007\u000fC\u0003b\u0001\u0011\u00051\u000e\u0006\u0002$Y\")\u0011M\u001ba\u0001[B!an]\u0016,\u001b\u0005y'B\u00019r\u0003\u0011)H/\u001b7\u000b\u0003I\fAA[1wC&\u0011\u0011n\u001c\u0005\u0006k\u0002!\tA^\u0001\u0005Y>\fG\rF\u0001x!\rA\u0018q\u0001\b\u0004s\u0006\rab\u0001>\u0002\u00029\u00111p \b\u0003yzt!AL?\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\r\t)\u0001B\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI!a\u0003\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA\u0003\t!1Q\u000f\u0001C\u0001\u0003\u001f!2a^A\t\u0011\u001d\t\u0019\"!\u0004A\u0002-\nA\u0001]1uQ\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011\u0001\u00026t_:$2a^A\u000e\u0011\u001d\t\u0019\"!\u0006A\u0002-Bq!a\b\u0001\t\u0003\t\t#A\u0002dgZ$2a^A\u0012\u0011\u001d\t\u0019\"!\bA\u0002-Bq!a\n\u0001\t\u0003\tI#A\u0002pe\u000e$2a^A\u0016\u0011\u001d\t\u0019\"!\nA\u0002-Bq!a\f\u0001\t\u0003\t\t$A\u0004qCJ\fX/\u001a;\u0015\u0007]\f\u0019\u0004C\u0004\u0002\u0014\u00055\u0002\u0019A\u0016\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:\u0005!A/\u001a=u)\r9\u00181\b\u0005\b\u0003'\t)\u00041\u0001,\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\n\u0001\u0002^3yi\u001aKG.\u001a\u000b\u0005\u0003\u0007\nI\u0005\u0005\u0003\u001e\u0003\u000bZ\u0013bAA$\t\t9A)\u0019;bg\u0016$\bbBA\n\u0003{\u0001\ra\u000b\u0005\tU\u0001\u0001\r\u0011\"\u0003\u0002NU\t1\u0006C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T\u0005Q1o\\;sG\u0016|F%Z9\u0015\t\u0005U\u00131\f\t\u0004\u001f\u0005]\u0013bAA-!\t!QK\\5u\u0011%\ti&a\u0014\u0002\u0002\u0003\u00071&A\u0002yIEBq!!\u0019\u0001A\u0003&1&A\u0004t_V\u00148-\u001a\u0011\t\u0013\u0005\u0015\u0004\u00011A\u0005\n\u0005\u001d\u0014aE;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fWCAA5!\u0011y\u00111\u000e\u001e\n\u0007\u00055\u0004C\u0001\u0004PaRLwN\u001c\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003g\nq#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006|F%Z9\u0015\t\u0005U\u0013Q\u000f\u0005\u000b\u0003;\ny'!AA\u0002\u0005%\u0004\u0002CA=\u0001\u0001\u0006K!!\u001b\u0002)U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1!\u0011%\ti\b\u0001a\u0001\n\u0013\ty(\u0001\u0007fqR\u0014\u0018m\u00149uS>t7/\u0006\u0002\u0002\u0002B1\u00111QAEW-j!!!\"\u000b\u0007\u0005\u001de-A\u0004nkR\f'\r\\3\n\t\u0005-\u0015Q\u0011\u0002\b\u0011\u0006\u001c\b.T1q\u0011%\ty\t\u0001a\u0001\n\u0013\t\t*\u0001\tfqR\u0014\u0018m\u00149uS>t7o\u0018\u0013fcR!\u0011QKAJ\u0011)\ti&!$\u0002\u0002\u0003\u0007\u0011\u0011\u0011\u0005\t\u0003/\u0003\u0001\u0015)\u0003\u0002\u0002\u0006iQ\r\u001f;sC>\u0003H/[8og\u0002B3\u0001AAN!\u0011\ti*!+\u000f\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\u000b\t+\u0001\nJ]R,'OZ1dKN#\u0018MY5mSRL\u0018\u0002BAV\u0003[\u0013\u0001\"\u0012<pYZLgn\u001a\u0006\u0005\u0003O\u000b\t\u000b")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataStreamReader schema(String schemaString) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString)));
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        Dataset<Row> dataset;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Object ds = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sqlContext().conf()).newInstance();
        SparkSession x$1 = this.sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource v1DataSource = new DataSource(x$1, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8);
        Object obj = ds;
        Object object = obj instanceof StreamSourceProvider ? new Some((Object)StreamingRelation$.MODULE$.apply(v1DataSource)) : None$.MODULE$;
        None$ v1Relation = object;
        Object obj2 = ds;
        if (obj2 instanceof MicroBatchReadSupport) {
            StructType structType;
            MicroBatchReadSupport microBatchReadSupport = (MicroBatchReadSupport)obj2;
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(microBatchReadSupport, this.sparkSession.sessionState().conf());
            scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
            DataSourceOptions dataSourceOptions = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
            BaseStreamingSource tempReader = null;
            try {
                String x$9 = "temporaryReader";
                String x$10 = Utils$.MODULE$.createTempDir$default$1();
                tempReader = microBatchReadSupport.createMicroBatchReader(Optional.ofNullable(this.userSpecifiedSchema().orNull(Predef$.MODULE$.$conforms())), Utils$.MODULE$.createTempDir(x$10, x$9).getCanonicalPath(), dataSourceOptions);
                structType = tempReader.readSchema();
            }
            finally {
                if (tempReader != null) {
                    tempReader.stop();
                    tempReader = null;
                }
            }
            StructType schema = structType;
            dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2(microBatchReadSupport, this.source(), (scala.collection.immutable.Map<String, String>)options, (Seq<Attribute>)schema.toAttributes(), (Option<StreamingRelation>)v1Relation, this.sparkSession));
        } else if (obj2 instanceof ContinuousReadSupport) {
            ContinuousReadSupport continuousReadSupport = (ContinuousReadSupport)obj2;
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(continuousReadSupport, this.sparkSession.sessionState().conf());
            scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
            DataSourceOptions dataSourceOptions = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
            String x$11 = "temporaryReader";
            String x$12 = Utils$.MODULE$.createTempDir$default$1();
            ContinuousReader tempReader = continuousReadSupport.createContinuousReader(Optional.ofNullable(this.userSpecifiedSchema().orNull(Predef$.MODULE$.$conforms())), Utils$.MODULE$.createTempDir(x$12, x$11).getCanonicalPath(), dataSourceOptions);
            dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2(continuousReadSupport, this.source(), (scala.collection.immutable.Map<String, String>)options, (Seq<Attribute>)tempReader.readSchema().toAttributes(), (Option<StreamingRelation>)v1Relation, this.sparkSession));
        } else {
            dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)StreamingRelation$.MODULE$.apply(v1DataSource));
        }
        return dataset;
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load();
    }

    public Dataset<Row> json(String path) {
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    public Dataset<String> textFile(String path) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException("User specified schema not supported with `textFile`", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.text(path).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

