/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.io.sarg.PredicateLeaf;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.apache.orc.storage.ql.io.sarg.SearchArgumentFactory;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class OrcFilters$ {
    public static OrcFilters$ MODULE$;

    static {
        new OrcFilters$();
    }

    public Option<Filter> buildTree(Seq<Filter> filters) {
        None$ none$;
        Seq<Filter> seq = filters;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            none$ = None$.MODULE$;
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                Filter filter = (Filter)((SeqLike)some2.get()).apply(0);
                none$ = new Some((Object)filter);
            } else {
                Some some3 = Seq$.MODULE$.unapplySeq(seq);
                if (!some3.isEmpty() && some3.get() != null && ((SeqLike)some3.get()).lengthCompare(2) == 0) {
                    Filter filter1 = (Filter)((SeqLike)some3.get()).apply(0);
                    Filter filter2 = (Filter)((SeqLike)some3.get()).apply(1);
                    none$ = new Some((Object)new And(filter1, filter2));
                } else {
                    Tuple2 tuple2 = filters.splitAt(filters.length() / 2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Seq left = (Seq)tuple2._1();
                    Seq right = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
                    Tuple2 tuple23 = tuple22;
                    Seq left2 = (Seq)tuple23._1();
                    Seq right2 = (Seq)tuple23._2();
                    none$ = new Some((Object)new And((Filter)this.buildTree((Seq<Filter>)left2).get(), (Filter)this.buildTree((Seq<Filter>)right2).get()));
                }
            }
        }
        return none$;
    }

    private String quoteAttributeNameIfNeeded(String name) {
        return !name.contains("`") && name.contains(".") ? new StringBuilder(2).append("`").append(name).append("`").toString() : name;
    }

    public Option<SearchArgument> createFilter(StructType schema, Seq<Filter> filters) {
        Map dataTypeMap = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq convertibleFilters = (Seq)filters.flatMap((Function1 & Serializable & scala.Serializable)filter -> Option$.MODULE$.option2Iterable(MODULE$.buildSearchArgument((Map<String, DataType>)dataTypeMap, (Filter)filter, SearchArgumentFactory.newBuilder()).map((Function1 & Serializable & scala.Serializable)_ -> filter)), Seq$.MODULE$.canBuildFrom());
        return this.buildTree((Seq<Filter>)convertibleFilters).flatMap((Function1 & Serializable & scala.Serializable)conjunction -> MODULE$.buildSearchArgument((Map<String, DataType>)dataTypeMap, (Filter)conjunction, SearchArgumentFactory.newBuilder()).map((Function1 & Serializable & scala.Serializable)builder -> builder.build()));
    }

    private boolean isSearchableType(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = BinaryType$.MODULE$.equals(dataType2) ? false : dataType2 instanceof AtomicType;
        return bl;
    }

    private PredicateLeaf.Type getPredicateLeafType(DataType dataType) {
        PredicateLeaf.Type type;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            type = PredicateLeaf.Type.BOOLEAN;
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2)));
            if (bl) {
                type = PredicateLeaf.Type.LONG;
            } else {
                boolean bl2 = FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2);
                if (bl2) {
                    type = PredicateLeaf.Type.FLOAT;
                } else if (StringType$.MODULE$.equals(dataType2)) {
                    type = PredicateLeaf.Type.STRING;
                } else if (DateType$.MODULE$.equals(dataType2)) {
                    type = PredicateLeaf.Type.DATE;
                } else if (TimestampType$.MODULE$.equals(dataType2)) {
                    type = PredicateLeaf.Type.TIMESTAMP;
                } else if (dataType2 instanceof DecimalType) {
                    type = PredicateLeaf.Type.DECIMAL;
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(10).append("DataType: ").append(dataType.catalogString()).toString());
                }
            }
        }
        return type;
    }

    private Object castLiteralValue(Object value, DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        boolean bl2 = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2)));
        Object object = bl2 ? BoxesRunTime.boxToLong((long)((Number)value).longValue()) : ((bl = FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2)) ? BoxesRunTime.boxToDouble((double)((Number)value).doubleValue()) : (dataType2 instanceof DecimalType ? new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)value))) : value));
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<SearchArgument.Builder> buildSearchArgument(Map<String, DataType> dataTypeMap, Filter expression, SearchArgument.Builder builder) {
        IsNotNull isNotNull;
        String attribute;
        IsNull isNull;
        String attribute2;
        Filter filter = expression;
        if (filter instanceof And) {
            And and = (And)filter;
            Filter left = and.left();
            Filter right = and.right();
            return this.buildSearchArgument(dataTypeMap, left, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.buildSearchArgument(dataTypeMap, right, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.buildSearchArgument(dataTypeMap, left, builder.startAnd()).flatMap((Function1 & Serializable & scala.Serializable)lhs -> MODULE$.buildSearchArgument(dataTypeMap, right, (SearchArgument.Builder)lhs).map((Function1 & Serializable & scala.Serializable)rhs -> rhs.end()))));
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            Filter left = or.left();
            Filter right = or.right();
            return this.buildSearchArgument(dataTypeMap, left, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.buildSearchArgument(dataTypeMap, right, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.buildSearchArgument(dataTypeMap, left, builder.startOr()).flatMap((Function1 & Serializable & scala.Serializable)lhs -> MODULE$.buildSearchArgument(dataTypeMap, right, (SearchArgument.Builder)lhs).map((Function1 & Serializable & scala.Serializable)rhs -> rhs.end()))));
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            Filter child = not.child();
            return this.buildSearchArgument(dataTypeMap, child, SearchArgumentFactory.newBuilder()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.buildSearchArgument(dataTypeMap, child, builder.startNot()).map((Function1 & Serializable & scala.Serializable)negate -> negate.end()));
        }
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            String attribute3 = equalTo.attribute();
            Object value = equalTo.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute3))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute3);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute3));
                return new Some((Object)builder.startAnd().equals(quotedName, this.getType$1(attribute3, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String attribute4 = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute4))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute4);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute4));
                return new Some((Object)builder.startAnd().nullSafeEquals(quotedName, this.getType$1(attribute4, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            String attribute5 = lessThan.attribute();
            Object value = lessThan.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute5))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute5);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute5));
                return new Some((Object)builder.startAnd().lessThan(quotedName, this.getType$1(attribute5, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            String attribute6 = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute6))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute6);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute6));
                return new Some((Object)builder.startAnd().lessThanEquals(quotedName, this.getType$1(attribute6, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            String attribute7 = greaterThan.attribute();
            Object value = greaterThan.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute7))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute7);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute7));
                return new Some((Object)builder.startNot().lessThanEquals(quotedName, this.getType$1(attribute7, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            String attribute8 = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute8))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute8);
                Object castedValue = this.castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute8));
                return new Some((Object)builder.startNot().lessThan(quotedName, this.getType$1(attribute8, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof IsNull && this.isSearchableType((DataType)dataTypeMap.apply((Object)(attribute2 = (isNull = (IsNull)filter).attribute())))) {
            String quotedName = this.quoteAttributeNameIfNeeded(attribute2);
            return new Some((Object)builder.startAnd().isNull(quotedName, this.getType$1(attribute2, dataTypeMap)).end());
        }
        if (filter instanceof IsNotNull && this.isSearchableType((DataType)dataTypeMap.apply((Object)(attribute = (isNotNull = (IsNotNull)filter).attribute())))) {
            String quotedName = this.quoteAttributeNameIfNeeded(attribute);
            return new Some((Object)builder.startNot().isNull(quotedName, this.getType$1(attribute, dataTypeMap)).end());
        }
        if (!(filter instanceof In)) return None$.MODULE$;
        In in = (In)filter;
        String attribute9 = in.attribute();
        Object[] values = in.values();
        if (!this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute9))) return None$.MODULE$;
        String quotedName = this.quoteAttributeNameIfNeeded(attribute9);
        Object[] castedValues = (Object[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)v -> MODULE$.castLiteralValue(v, (DataType)dataTypeMap.apply((Object)attribute9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return new Some((Object)builder.startAnd().in(quotedName, this.getType$1(attribute9, dataTypeMap), (Object[])Predef$.MODULE$.genericArrayOps((Object)castedValues).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyRef()))).end());
    }

    private final PredicateLeaf.Type getType$1(String attribute, Map dataTypeMap$2) {
        return this.getPredicateLeafType((DataType)dataTypeMap$2.apply((Object)attribute));
    }

    private OrcFilters$() {
        MODULE$ = this;
    }
}

