/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\r\u001b\u0001\u0015BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004D\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019\u0011\u0006\u0001)A\u0005\u0015\")A\u000b\u0001C\u0005+\")q\r\u0001C\u0005Q\")a\u000e\u0001C\u0001_\")1\u000f\u0001C\u0001i\")\u0001\u0010\u0001C\u0001s\"I\u0011\u0011\b\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003'Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0005\u0002p\u0001\t\n\u0011\"\u0001\u0002r!9\u0011q\u000b\u0001\u0005\u0002\u0005U\u0004bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003G\u0003A\u0011BAS\u0011%\t)\fAI\u0001\n\u0013\t\t\bC\u0004\u00028\u0002!\t!!/\t\u000f\u0005]\u0006\u0001\"\u0001\u0002J\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003'\u0004A\u0011AAo\u0011\u001d\tY\u0010\u0001C\u0005\u0003{\u0014AbQ1dQ\u0016l\u0015M\\1hKJT!a\u0007\u000f\u0002\u0013\u0015DXmY;uS>t'BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011c\u0001\u0001'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u0004\"!\f\u0019\u000e\u00039R!a\f\u0010\u0002\u0011%tG/\u001a:oC2L!!\r\u0018\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003k\u0001i\u0011AG\u0001\u000bG\u0006\u001c\u0007.\u001a3ECR\fW#\u0001\u001d\u0011\u0007er\u0004)D\u0001;\u0015\tYD(\u0001\u0003vi&d'\"A\u001f\u0002\t)\fg/Y\u0005\u0003\u007fi\u0012!\u0002T5oW\u0016$G*[:u!\t)\u0014)\u0003\u0002C5\tQ1)Y2iK\u0012$\u0015\r^1\u0002\u0017\r\f7\r[3e\t\u0006$\u0018\r\t\u0015\u0003\u0007\u0015\u0003\"a\n$\n\u0005\u001dC#!\u0003;sC:\u001c\u0018.\u001a8u\u0003%\u0019\u0017m\u00195f\u0019>\u001c7.F\u0001K!\tY\u0005+D\u0001M\u0015\tie*A\u0003m_\u000e\\7O\u0003\u0002Pu\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Ec%A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\u0002\u0015\r\f7\r[3M_\u000e\\\u0007\u0005\u000b\u0002\u0006\u000b\u0006A!/Z1e\u0019>\u001c7.\u0006\u0002W3R\u0011qK\u0019\t\u00031fc\u0001\u0001B\u0003[\r\t\u00071LA\u0001B#\tav\f\u0005\u0002(;&\u0011a\f\u000b\u0002\b\u001d>$\b.\u001b8h!\t9\u0003-\u0003\u0002bQ\t\u0019\u0011I\\=\t\r\r4A\u00111\u0001e\u0003\u00051\u0007cA\u0014f/&\u0011a\r\u000b\u0002\ty\tLh.Y7f}\u0005IqO]5uK2{7m[\u000b\u0003S.$\"A\u001b7\u0011\u0005a[G!\u0002.\b\u0005\u0004Y\u0006BB2\b\t\u0003\u0007Q\u000eE\u0002(K*\f!b\u00197fCJ\u001c\u0015m\u00195f)\u0005\u0001\bCA\u0014r\u0013\t\u0011\bF\u0001\u0003V]&$\u0018aB5t\u000b6\u0004H/_\u000b\u0002kB\u0011qE^\u0005\u0003o\"\u0012qAQ8pY\u0016\fg.\u0001\u0006dC\u000eDW-U;fef$b\u0001\u001d>\u0002\n\u0005%\u0002\"B>\u000b\u0001\u0004a\u0018!B9vKJL\bgA?\u0002\u0006A!ap`A\u0002\u001b\u0005a\u0012bAA\u00019\t9A)\u0019;bg\u0016$\bc\u0001-\u0002\u0006\u0011Q\u0011q\u0001>\u0002\u0002\u0003\u0005)\u0011A.\u0003\u0007}#\u0013\u0007C\u0005\u0002\f)\u0001\n\u00111\u0001\u0002\u000e\u0005IA/\u00192mK:\u000bW.\u001a\t\u0006O\u0005=\u00111C\u0005\u0004\u0003#A#AB(qi&|g\u000e\u0005\u0003\u0002\u0016\u0005\rb\u0002BA\f\u0003?\u00012!!\u0007)\u001b\t\tYBC\u0002\u0002\u001e\u0011\na\u0001\u0010:p_Rt\u0014bAA\u0011Q\u00051\u0001K]3eK\u001aLA!!\n\u0002(\t11\u000b\u001e:j]\u001eT1!!\t)\u0011%\tYC\u0003I\u0001\u0002\u0004\ti#\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019DH\u0001\bgR|'/Y4f\u0013\u0011\t9$!\r\u0003\u0019M#xN]1hK2+g/\u001a7\u0002)\r\f7\r[3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiD\u000b\u0003\u0002\u000e\u0005}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0003&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)\r\f7\r[3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)F\u000b\u0003\u0002.\u0005}\u0012\u0001D;oG\u0006\u001c\u0007.Z)vKJLHc\u00029\u0002\\\u0005\u001d\u00141\u000e\u0005\u0007w6\u0001\r!!\u00181\t\u0005}\u00131\r\t\u0005}~\f\t\u0007E\u0002Y\u0003G\"1\"!\u001a\u0002\\\u0005\u0005\t\u0011!B\u00017\n\u0019q\f\n\u001a\t\r\u0005%T\u00021\u0001v\u0003\u001d\u0019\u0017m]2bI\u0016D\u0001\"!\u001c\u000e!\u0003\u0005\r!^\u0001\tE2|7m[5oO\u00061RO\\2bG\",\u0017+^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0002t)\u001aQ/a\u0010\u0015\u0013A\f9(a \u0002\u0018\u0006e\u0005BB\u0010\u0010\u0001\u0004\tI\bE\u0002\u007f\u0003wJ1!! \u001d\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\t\ti\u0004a\u0001\u0003\u0007\u000bA\u0001\u001d7b]B!\u0011QQAJ\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0005\u0003\u001b\u000by)A\u0003qY\u0006t7OC\u0002\u0002\u0012r\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003+\u000b9IA\u0006M_\u001eL7-\u00197QY\u0006t\u0007BBA5\u001f\u0001\u0007Q\u000f\u0003\u0004\u0002n=\u0001\r!^\u0001\u000ee\u0016\u001c\u0017m\u00195f\u0005f\u0004F.\u00198\u0015\u000bA\fy*!)\t\r}\u0001\u0002\u0019AA=\u0011\u001d\t\t\t\u0005a\u0001\u0003\u0007\u000b!C]3dC\u000eDWMQ=D_:$\u0017\u000e^5p]R9\u0001/a*\u0002*\u0006M\u0006BB\u0010\u0012\u0001\u0004\tI\bC\u0004\u0002,F\u0001\r!!,\u0002\u0013\r|g\u000eZ5uS>t\u0007CB\u0014\u00020\u0006\rU/C\u0002\u00022\"\u0012\u0011BR;oGRLwN\\\u0019\t\u000f9\f\u0002\u0013!a\u0001k\u0006a\"/Z2bG\",')_\"p]\u0012LG/[8oI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u00057p_.,\boQ1dQ\u0016$G)\u0019;b)\u0011\tY,!0\u0011\t\u001d\ny\u0001\u0011\u0005\u0007wN\u0001\r!a01\t\u0005\u0005\u0017Q\u0019\t\u0005}~\f\u0019\rE\u0002Y\u0003\u000b$1\"a2\u0002>\u0006\u0005\t\u0011!B\u00017\n\u0019q\fJ\u001a\u0015\t\u0005m\u00161\u001a\u0005\b\u0003\u0003#\u0002\u0019AAB\u00035)8/Z\"bG\",G\rR1uCR!\u00111QAi\u0011\u001d\t\t)\u0006a\u0001\u0003\u0007\u000bQB]3dC\u000eDWMQ=QCRDG#\u00029\u0002X\u0006e\u0007BB\u0010\u0017\u0001\u0004\tI\bC\u0004\u0002\\Z\u0001\r!a\u0005\u0002\u0019I,7o\\;sG\u0016\u0004\u0016\r\u001e5\u0015\u000fA\fy.!9\u0002t\"1qd\u0006a\u0001\u0003sBq!a7\u0018\u0001\u0004\t\u0019\u000f\u0005\u0003\u0002f\u0006=XBAAt\u0015\u0011\tI/a;\u0002\u0005\u0019\u001c(bAAwA\u00051\u0001.\u00193p_BLA!!=\u0002h\n!\u0001+\u0019;i\u0011\u001d\tIo\u0006a\u0001\u0003k\u0004B!!:\u0002x&!\u0011\u0011`At\u0005)1\u0015\u000e\\3TsN$X-\\\u0001\u0011Y>|7.\u001e9B]\u0012\u0014VM\u001a:fg\"$r!^A\u0000\u0005\u0003\u0011\u0019\u0001C\u0004\u0002\u0002b\u0001\r!a!\t\u000f\u0005%\b\u00041\u0001\u0002v\"9!Q\u0001\rA\u0002\u0005\r\u0018!D9vC2Lg-[3e!\u0006$\b\u000e")
public class CacheManager
implements Logging {
    private final transient LinkedList<CachedData> cachedData;
    private final transient ReentrantReadWriteLock cacheLock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedList<CachedData> cachedData() {
        return this.cachedData;
    }

    private ReentrantReadWriteLock cacheLock() {
        return this.cacheLock;
    }

    private <A> A readLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.ReadLock lock = this.cacheLock().readLock();
        lock.lock();
        try {
            object = f.apply();
        }
        finally {
            lock.unlock();
        }
        return (A)object;
    }

    private <A> A writeLock(Function0<A> f) {
        Object object;
        ReentrantReadWriteLock.WriteLock lock = this.cacheLock().writeLock();
        lock.lock();
        try {
            object = f.apply();
        }
        finally {
            lock.unlock();
        }
        return (A)object;
    }

    public void clearCache() {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.cachedData()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                CacheManager.$anonfun$clearCache$2(x$1);
                return BoxedUnit.UNIT;
            });
            this.cachedData().clear();
        });
    }

    public boolean isEmpty() {
        return BoxesRunTime.unboxToBoolean(this.readLock((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.cachedData().isEmpty()));
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.writeLock((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            LogicalPlan planToCache = query.logicalPlan();
            if (this.lookupCachedData(planToCache).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
                object = BoxedUnit.UNIT;
            } else {
                SparkSession sparkSession = query.sparkSession();
                InMemoryRelation inMemoryRelation = InMemoryRelation$.MODULE$.apply(sparkSession.sessionState().conf().useCompression(), sparkSession.sessionState().conf().columnBatchSize(), storageLevel, sparkSession.sessionState().executePlan(planToCache).executedPlan(), tableName, planToCache);
                object = BoxesRunTime.boxToBoolean((boolean)this.cachedData().add(new CachedData(planToCache, inMemoryRelation)));
            }
            return object;
        });
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, blocking));
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block1: {
                Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$3(plan, x$2)) : (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan));
                Iterator it = this.cachedData().iterator();
                while (it.hasNext()) {
                    CachedData cd = (CachedData)it.next();
                    if (!BoxesRunTime.unboxToBoolean((Object)shouldRemove.apply((Object)cd.plan()))) continue;
                    cd.cachedRepresentation().cacheBuilder().clearCache(blocking);
                    it.remove();
                }
                if (cascade) break block1;
                this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(plan, x$5)), false);
            }
        });
    }

    public boolean uncacheQuery$default$3() {
        return true;
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$2(plan, x$7)), this.recacheByCondition$default$3()));
    }

    private void recacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> condition, boolean clearCache) {
        Iterator it = this.cachedData().iterator();
        ArrayBuffer needToRecache = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (it.hasNext()) {
            BoxedUnit boxedUnit;
            boolean buildNewPlan;
            CachedData cd = (CachedData)it.next();
            boolean bl = buildNewPlan = clearCache || !cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
            if (BoxesRunTime.unboxToBoolean((Object)condition.apply((Object)cd.plan())) && buildNewPlan) {
                InMemoryRelation newCache;
                SparkPlan plan;
                cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
                it.remove();
                SparkPlan x$12 = plan = spark.sessionState().executePlan(cd.plan()).executedPlan();
                boolean x$2 = cd.cachedRepresentation().cacheBuilder().copy$default$1();
                int x$3 = cd.cachedRepresentation().cacheBuilder().copy$default$2();
                StorageLevel x$4 = cd.cachedRepresentation().cacheBuilder().copy$default$3();
                Option<String> x$5 = cd.cachedRepresentation().cacheBuilder().copy$default$5();
                Object x$6 = null;
                InMemoryRelation x$7 = newCache = InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder().copy(x$2, x$3, x$4, x$12, x$5, null), cd.plan());
                LogicalPlan x$8 = cd.copy$default$1();
                boxedUnit = needToRecache.$plus$eq((Object)cd.copy(x$8, x$7));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        needToRecache.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$1(this, x$1)));
    }

    private boolean recacheByCondition$default$3() {
        return true;
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return (Option)this.readLock((Function0 & Serializable & scala.Serializable)() -> this.lookupCachedData(query.logicalPlan()));
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return (Option)this.readLock((Function0 & Serializable & scala.Serializable)() -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.cachedData()).asScala()).find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan()))));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ResolvedHint resolvedHint;
                A1 A1 = x1;
                Object object = A1 instanceof ResolvedHint ? (resolvedHint = (ResolvedHint)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.cachedRepresentation().withOutput((Seq<Attribute>)A1.output())).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof ResolvedHint ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        this.writeLock((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Path qualifiedPath = fs.makeQualified(resourcePath);
            this.recacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$2(this, fs, qualifiedPath, x$10)), this.recacheByCondition$default$3());
        });
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                String prefixToInvalidate = qualifiedPath.toString();
                boolean invalidate = ((IterableLike)hadoopFsRelation.location().rootPaths().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.startsWith(prefixToInvalidate)));
                if (invalidate) {
                    hadoopFsRelation.location().refresh();
                }
                bl2 = invalidate;
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$clearCache$2(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$3(LogicalPlan plan$1, LogicalPlan x$2) {
        return x$2.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(LogicalPlan plan$1, LogicalPlan x$5) {
        return x$5.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$2(LogicalPlan plan$2, LogicalPlan x$7) {
        return x$7.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$1(CacheManager $this, CachedData x$1) {
        return $this.cachedData().add(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$2(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, LogicalPlan x$10) {
        return x$10.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$11, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        this.cachedData = new LinkedList();
        this.cacheLock = new ReentrantReadWriteLock();
    }
}

