/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.distribution;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class UniformDistribution
extends Distribution {
    private double upper;
    private double lower;

    @JsonCreator
    public UniformDistribution(@JsonProperty(value="lower") double lower, @JsonProperty(value="upper") double upper) throws NumberIsTooLargeException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        this.lower = lower;
        this.upper = upper;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double upper) {
        this.upper = upper;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double lower) {
        this.lower = lower;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lower);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.upper);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniformDistribution other = (UniformDistribution)obj;
        if (Double.doubleToLongBits(this.lower) != Double.doubleToLongBits(other.lower)) {
            return false;
        }
        return Double.doubleToLongBits(this.upper) == Double.doubleToLongBits(other.upper);
    }

    public String toString() {
        return "UniformDistribution{lower=" + this.lower + ", upper=" + this.upper + '}';
    }
}

