/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class SubsetVertex
extends BaseGraphVertex {
    private int from;
    private int to;
    private int[] forwardShape;

    public SubsetVertex(ComputationGraph graph, String name, int vertexIndex, int from, int to) {
        this(graph, name, vertexIndex, null, null, from, to);
    }

    public SubsetVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, int from, int to) {
        super(graph, name, vertexIndex, inputVertices, outputVertices);
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public boolean isOutputVertex() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: input not set");
        }
        this.forwardShape = Arrays.copyOf(this.inputs[0].shape(), this.inputs[0].rank());
        switch (this.inputs[0].rank()) {
            case 2: {
                return this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)this.from, (int)this.to, (boolean)true)});
            }
            case 3: {
                return this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)this.from, (int)this.to, (boolean)true), NDArrayIndex.all()});
            }
            case 4: {
                return this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)this.from, (int)this.to, (boolean)true), NDArrayIndex.all(), NDArrayIndex.all()});
            }
        }
        throw new UnsupportedOperationException("Cannot get subset for activations of rank " + this.inputs[0].rank());
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: error not set");
        }
        INDArray out = Nd4j.zeros((int[])this.forwardShape);
        switch (this.forwardShape.length) {
            case 2: {
                out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)this.from, (int)this.to, (boolean)true)}, this.epsilon);
                break;
            }
            case 3: {
                out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)this.from, (int)this.to, (boolean)true), NDArrayIndex.all()}, this.epsilon);
                break;
            }
            case 4: {
                out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.interval((int)this.from, (int)this.to, (boolean)true), NDArrayIndex.all(), NDArrayIndex.all()}, this.epsilon);
                break;
            }
            default: {
                throw new RuntimeException("Invalid activation rank");
            }
        }
        return new Pair(null, (Object)new INDArray[]{out});
    }

    @Override
    public String toString() {
        return "SubsetVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\",fromIdx=" + this.from + ",toIdx=" + this.to + ")";
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length == 0) {
            return null;
        }
        return new Pair((Object)maskArrays[0], (Object)currentMaskState);
    }
}

