/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.feedforward.autoencoder;

import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.layers.BasePretrainNetwork;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public class AutoEncoder
extends BasePretrainNetwork<org.deeplearning4j.nn.conf.layers.AutoEncoder> {
    public AutoEncoder(NeuralNetConfiguration conf) {
        super(conf);
    }

    public AutoEncoder(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<INDArray, INDArray> sampleHiddenGivenVisible(INDArray v) {
        this.setInput(v);
        INDArray ret = this.encode(v, true);
        return new Pair((Object)ret, (Object)ret);
    }

    @Override
    public Pair<INDArray, INDArray> sampleVisibleGivenHidden(INDArray h) {
        INDArray ret = this.decode(h);
        return new Pair((Object)ret, (Object)ret);
    }

    public INDArray encode(INDArray v, boolean training) {
        INDArray W = this.getParam("W");
        if (training && this.conf.isUseDropConnect() && this.conf.getLayer().getDropOut() > 0.0) {
            W = Dropout.applyDropConnect(this, "W");
        }
        INDArray hBias = this.getParam("b");
        INDArray preAct = v.mmul(W).addiRowVector(hBias);
        INDArray ret = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getActivationFn().getActivation(preAct, training);
        return ret;
    }

    public INDArray decode(INDArray y) {
        INDArray W = this.getParam("W");
        INDArray vBias = this.getParam("vb");
        INDArray preAct = y.mmul(W.transposei()).addiRowVector(vBias);
        return ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getActivationFn().getActivation(preAct, true);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.encode(input, training);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.encode(input, true);
    }

    @Override
    public boolean isPretrainLayer() {
        return true;
    }

    @Override
    public INDArray activate(boolean training) {
        return this.decode(this.encode(this.input, training));
    }

    @Override
    public INDArray activate() {
        return this.decode(this.encode(this.input, false));
    }

    @Override
    public void computeGradientAndScore() {
        INDArray W = this.getParam("W");
        double corruptionLevel = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getCorruptionLevel();
        INDArray corruptedX = corruptionLevel > 0.0 ? this.getCorruptedInput(this.input, corruptionLevel) : this.input;
        this.setInput(corruptedX);
        INDArray y = this.encode(corruptedX, true);
        INDArray z = this.decode(y);
        INDArray visibleLoss = this.input.sub(z);
        INDArray hiddenLoss = ((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getSparsity() == 0.0 ? visibleLoss.mmul(W).muli(y).muli(y.rsub((Number)1)) : visibleLoss.mmul(W).muli(y).muli(y.add((Number)(-((org.deeplearning4j.nn.conf.layers.AutoEncoder)this.layerConf()).getSparsity())));
        INDArray wGradient = corruptedX.transposei().mmul(hiddenLoss).addi(visibleLoss.transposei().mmul(y));
        INDArray hBiasGradient = hiddenLoss.sum(new int[]{0});
        INDArray vBiasGradient = visibleLoss.sum(new int[]{0});
        this.gradient = this.createGradient(wGradient, vBiasGradient, hBiasGradient);
        this.setScoreWithZ(z);
    }
}

