/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ErrorPropagation;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ServiceTaskExpressionActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected String serviceTaskId;
    protected Expression expression;
    protected Expression skipExpression;
    protected String resultVariable;
    protected List<MapExceptionEntry> mapExceptions;
    protected boolean useLocalScopeForResultVariable;
    protected boolean triggerable;
    protected boolean storeResultVariableAsTransient;

    public ServiceTaskExpressionActivityBehavior(ServiceTask serviceTask, Expression expression, Expression skipExpression) {
        this.serviceTaskId = serviceTask.getId();
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.resultVariable = serviceTask.getResultVariableName();
        this.mapExceptions = serviceTask.getMapExceptions();
        this.useLocalScopeForResultVariable = serviceTask.isUseLocalScopeForResultVariable();
        this.triggerable = serviceTask.isTriggerable();
        this.storeResultVariableAsTransient = serviceTask.isStoreResultVariableAsTransient();
    }

    @Override
    public void execute(DelegateExecution execution) {
        Object value = null;
        try {
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            String skipExpressionText = null;
            if (this.skipExpression != null) {
                skipExpressionText = this.skipExpression.getExpressionText();
            }
            boolean shouldLeave = !this.triggerable;
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(skipExpressionText, this.serviceTaskId, execution, commandContext);
            if (!isSkipExpressionEnabled || !SkipExpressionUtil.shouldSkipFlowElement(skipExpressionText, this.serviceTaskId, execution, commandContext)) {
                String overrideExpression;
                ObjectNode taskElementProperties;
                if (CommandContextUtil.getProcessEngineConfiguration(commandContext).isEnableProcessDefinitionInfoCache() && (taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.serviceTaskId, execution.getProcessDefinitionId())) != null && taskElementProperties.has("serviceTaskExpression") && StringUtils.isNotEmpty((CharSequence)(overrideExpression = taskElementProperties.get("serviceTaskExpression").asText())) && !overrideExpression.equals(this.expression.getExpressionText())) {
                    this.expression = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager().createExpression(overrideExpression);
                }
                if ((value = this.expression.getValue((VariableContainer)execution)) instanceof CompletableFuture) {
                    shouldLeave = false;
                    CommandContextUtil.getAgenda(commandContext).planFutureOperation((CompletableFuture)value, new FutureCompleteAction(execution));
                } else {
                    this.setExecutionVariableValue(value, execution);
                }
            }
            if (shouldLeave) {
                this.leave(execution);
            }
        }
        catch (Exception exc) {
            this.handleException(exc, execution);
        }
    }

    protected void handleException(Throwable exc, DelegateExecution execution) {
        ErrorPropagation.handleException(exc, (ExecutionEntity)execution, this.mapExceptions);
    }

    protected void setExecutionVariableValue(Object value, DelegateExecution execution) {
        if (this.resultVariable != null) {
            if (this.storeResultVariableAsTransient) {
                if (this.useLocalScopeForResultVariable) {
                    execution.setTransientVariableLocal(this.resultVariable, value);
                } else {
                    execution.setTransientVariable(this.resultVariable, value);
                }
            } else if (this.useLocalScopeForResultVariable) {
                execution.setVariableLocal(this.resultVariable, value);
            } else {
                execution.setVariable(this.resultVariable, value);
            }
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.leave(execution);
    }

    protected class FutureCompleteAction
    implements BiConsumer<Object, Throwable> {
        protected final DelegateExecution execution;

        public FutureCompleteAction(DelegateExecution execution) {
            this.execution = execution;
        }

        @Override
        public void accept(Object value, Throwable throwable) {
            if (throwable == null) {
                ServiceTaskExpressionActivityBehavior.this.setExecutionVariableValue(value, this.execution);
                if (!ServiceTaskExpressionActivityBehavior.this.triggerable) {
                    ServiceTaskExpressionActivityBehavior.this.leave(this.execution);
                }
            } else {
                ServiceTaskExpressionActivityBehavior.this.handleException(throwable, this.execution);
            }
        }
    }
}

