/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.IdentityLinkUtil;

public abstract class AbstractProcessInstanceIdentityLinkCmd {
    protected ExecutionEntity getProcessInstanceEntity(CommandContext commandContext, String processInstanceId) {
        ExecutionEntity processInstance = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(processInstanceId);
        if (processInstance == null) {
            throw new FlowableIllegalArgumentException("The process instance with id '" + processInstanceId + "' could not be found as an active process instance.");
        }
        return processInstance;
    }

    protected void removeIdentityLinkType(CommandContext commandContext, String processInstanceId, String identityType) {
        ExecutionEntity processInstanceEntity = this.getProcessInstanceEntity(commandContext, processInstanceId);
        IdentityLinkUtil.deleteProcessInstanceIdentityLinks(processInstanceEntity, null, null, identityType);
    }

    protected void createIdentityLinkType(CommandContext commandContext, String processInstanceId, String userId, String groupId, String identityType) {
        if (userId == null && groupId == null) {
            return;
        }
        if (userId != null && groupId != null) {
            throw new FlowableIllegalArgumentException("Either set the user id or the group id for an identity link, but not both the same time.");
        }
        ExecutionEntity processInstanceEntity = this.getProcessInstanceEntity(commandContext, processInstanceId);
        IdentityLinkUtil.createProcessInstanceIdentityLink(processInstanceEntity, userId, groupId, identityType);
    }
}

