/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class CompositeHistoryManager
implements HistoryManager {
    protected final Collection<HistoryManager> historyManagers;

    public CompositeHistoryManager(Collection<HistoryManager> historyManagers) {
        this.historyManagers = new ArrayList<HistoryManager>(historyManagers);
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        for (HistoryManager historyManager : this.historyManagers) {
            if (!historyManager.isHistoryLevelAtLeast(level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level, String processDefinitionId) {
        for (HistoryManager historyManager : this.historyManagers) {
            if (!historyManager.isHistoryLevelAtLeast(level, processDefinitionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHistoryEnabled() {
        for (HistoryManager historyManager : this.historyManagers) {
            if (!historyManager.isHistoryEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHistoryEnabled(String processDefinitionId) {
        for (HistoryManager historyManager : this.historyManagers) {
            if (!historyManager.isHistoryEnabled(processDefinitionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void recordProcessInstanceEnd(ExecutionEntity processInstance, String deleteReason, String activityId, Date endTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordProcessInstanceEnd(processInstance, deleteReason, activityId, endTime);
        }
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordProcessInstanceStart(processInstance);
        }
    }

    @Override
    public void recordProcessInstanceNameChange(ExecutionEntity processInstanceExecution, String newName) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordProcessInstanceNameChange(processInstanceExecution, newName);
        }
    }

    @Override
    public void recordProcessInstanceDeleted(String processInstanceId, String processDefinitionId, String processTenantId) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordProcessInstanceDeleted(processInstanceId, processDefinitionId, processTenantId);
        }
    }

    @Override
    public void recordDeleteHistoricProcessInstancesByProcessDefinitionId(String processDefinitionId) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordDeleteHistoricProcessInstancesByProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordBulkDeleteProcessInstances(Collection<String> processInstanceIds) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordBulkDeleteProcessInstances(processInstanceIds);
        }
    }

    @Override
    public void recordActivityStart(ActivityInstance activityInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordActivityStart(activityInstance);
        }
    }

    @Override
    public void recordActivityEnd(ActivityInstance activityInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordActivityEnd(activityInstance);
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason, Date endTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordActivityEnd(executionEntity, deleteReason, endTime);
        }
    }

    @Override
    public HistoricActivityInstanceEntity findHistoricActivityInstance(ExecutionEntity execution, boolean validateEndTimeNull) {
        for (HistoryManager historyManager : this.historyManagers) {
            HistoricActivityInstanceEntity historicActivityInstance = historyManager.findHistoricActivityInstance(execution, validateEndTimeNull);
            if (historicActivityInstance == null) continue;
            return historicActivityInstance;
        }
        return null;
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordProcessDefinitionChange(processInstanceId, processDefinitionId);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordTaskCreated(task, execution);
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, ExecutionEntity execution, String deleteReason, Date endTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordTaskEnd(task, execution, deleteReason, endTime);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity, String activityInstanceId, Date changeTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordTaskInfoChange(taskEntity, activityInstanceId, changeTime);
        }
    }

    @Override
    public void recordHistoricTaskDeleted(HistoricTaskInstance task) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordHistoricTaskDeleted(task);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable, Date createTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordVariableCreate(variable, createTime);
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId, String activityInstanceId, Date createTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordHistoricDetailVariableCreate(variable, sourceActivityExecution, useActivityId, activityInstanceId, createTime);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable, Date updateTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordVariableUpdate(variable, updateTime);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordVariableRemoved(variable);
        }
    }

    @Override
    public void createIdentityLinkComment(TaskEntity task, String userId, String groupId, String type, boolean create) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createIdentityLinkComment(task, userId, groupId, type, create);
        }
    }

    @Override
    public void createUserIdentityLinkComment(TaskEntity task, String userId, String type, boolean create) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createUserIdentityLinkComment(task, userId, type, create);
        }
    }

    @Override
    public void createGroupIdentityLinkComment(TaskEntity task, String groupId, String type, boolean create) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createGroupIdentityLinkComment(task, groupId, type, create);
        }
    }

    @Override
    public void createIdentityLinkComment(TaskEntity task, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createIdentityLinkComment(task, userId, groupId, type, create, forceNullUserId);
        }
    }

    @Override
    public void createUserIdentityLinkComment(TaskEntity task, String userId, String type, boolean create, boolean forceNullUserId) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createUserIdentityLinkComment(task, userId, type, create, forceNullUserId);
        }
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(ExecutionEntity processInstance, String userId, String groupId, String type, boolean create) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createProcessInstanceIdentityLinkComment(processInstance, userId, groupId, type, create);
        }
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(ExecutionEntity processInstance, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createProcessInstanceIdentityLinkComment(processInstance, userId, groupId, type, create, forceNullUserId);
        }
    }

    @Override
    public void createAttachmentComment(TaskEntity task, ExecutionEntity processInstance, String attachmentName, boolean create) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createAttachmentComment(task, processInstance, attachmentName, create);
        }
    }

    @Override
    public void recordFormPropertiesSubmitted(ExecutionEntity processInstance, Map<String, String> properties, String taskId, Date createTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordFormPropertiesSubmitted(processInstance, properties, taskId, createTime);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordIdentityLinkCreated(identityLink);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordIdentityLinkDeleted(identityLink);
        }
    }

    @Override
    public void recordEntityLinkCreated(EntityLinkEntity entityLink) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordEntityLinkCreated(entityLink);
        }
    }

    @Override
    public void recordEntityLinkDeleted(EntityLinkEntity entityLink) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordEntityLinkDeleted(entityLink);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.updateProcessBusinessKeyInHistory(processInstance);
        }
    }

    @Override
    public void updateProcessBusinessStatusInHistory(ExecutionEntity processInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.updateProcessBusinessStatusInHistory(processInstance);
        }
    }

    @Override
    public void updateProcessDefinitionIdInHistory(ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.updateProcessDefinitionIdInHistory(processDefinitionEntity, processInstance);
        }
    }

    @Override
    public void updateActivity(ExecutionEntity executionEntity, String oldActivityId, FlowElement newFlowElement, TaskEntity task, Date updateTime) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.updateActivity(executionEntity, oldActivityId, newFlowElement, task, updateTime);
        }
    }

    @Override
    public void updateHistoricActivityInstance(ActivityInstance activityInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.updateHistoricActivityInstance(activityInstance);
        }
    }

    @Override
    public void createHistoricActivityInstance(ActivityInstance activityInstance) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.createHistoricActivityInstance(activityInstance);
        }
    }

    @Override
    public void recordHistoricUserTaskLogEntry(HistoricTaskLogEntryBuilder taskLogEntryBuilder) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.recordHistoricUserTaskLogEntry(taskLogEntryBuilder);
        }
    }

    @Override
    public void deleteHistoryUserTaskLog(long logNumber) {
        for (HistoryManager historyManager : this.historyManagers) {
            historyManager.deleteHistoryUserTaskLog(logNumber);
        }
    }

    public void addHistoryManager(HistoryManager historyManager) {
        this.historyManagers.add(historyManager);
    }
}

