/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.scripting;

import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.ScriptTraceEnhancer;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.task.service.delegate.DelegateTask;

public class ProcessEngineScriptTraceEnhancer
implements ScriptTraceEnhancer {
    private static final String EMPTY_INDICATOR = "<empty>";

    public void enhanceScriptTrace(ScriptTraceEnhancer.ScriptTraceContext context) {
        this.enhanceScriptTrace(context, context.getVariableContainer());
    }

    protected void enhanceScriptTrace(ScriptTraceEnhancer.ScriptTraceContext context, VariableContainer container) {
        DelegateTask task;
        if (container instanceof DelegateExecution) {
            context.addTraceTag("scopeType", "bpmn");
            DelegateExecution execution = (DelegateExecution)container;
            this.addScopeTags(execution.getProcessDefinitionId(), context);
            context.addTraceTag("subScopeDefinitionKey", execution.getCurrentActivityId());
            this.addTenantId(context, execution.getTenantId());
        } else if (container instanceof DelegateTask && (task = (DelegateTask)container).getProcessInstanceId() != null) {
            context.addTraceTag("scopeType", "bpmn");
            this.addScopeTags(task.getProcessDefinitionId(), context);
            context.addTraceTag("subScopeDefinitionKey", task.getTaskDefinitionKey());
            this.addTenantId(context, task.getTenantId());
        }
    }

    protected void addScopeTags(String processDefinitionId, ScriptTraceEnhancer.ScriptTraceContext context) {
        ProcessDefinition processDefinition = this.getProcessDefinition(processDefinitionId);
        if (processDefinition != null) {
            context.addTraceTag("scopeDefinitionKey", processDefinition.getKey());
            context.addTraceTag("scopeDefinitionId", processDefinition.getId());
        }
    }

    protected void addTenantId(ScriptTraceEnhancer.ScriptTraceContext context, String tenantId) {
        if (tenantId != null && !tenantId.isEmpty()) {
            context.addTraceTag("tenantId", tenantId);
        } else {
            context.addTraceTag("tenantId", EMPTY_INDICATOR);
        }
    }

    protected ProcessDefinition getProcessDefinition(String processDefinitionId) {
        if (processDefinitionId != null) {
            return ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
        }
        return null;
    }
}

