/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class CorrelationUtil {
    public static String getCorrelationKey(String elementName, CommandContext commandContext, ExecutionEntity executionEntity) {
        return CorrelationUtil.getCorrelationKey(elementName, commandContext, executionEntity.getCurrentFlowElement(), executionEntity);
    }

    public static String getCorrelationKey(String elementName, CommandContext commandContext, FlowElement flowElement, ExecutionEntity executionEntity) {
        List eventCorrelations;
        String correlationKey = null;
        if (flowElement != null && (eventCorrelations = (List)flowElement.getExtensionElements().get(elementName)) != null && !eventCorrelations.isEmpty()) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            HashMap<String, Object> correlationParameters = new HashMap<String, Object>();
            for (ExtensionElement eventCorrelation : eventCorrelations) {
                String name = eventCorrelation.getAttributeValue(null, "name");
                String valueExpression = eventCorrelation.getAttributeValue(null, "value");
                if (StringUtils.isNotEmpty((CharSequence)valueExpression)) {
                    if (executionEntity != null) {
                        Object value = expressionManager.createExpression(valueExpression).getValue((VariableContainer)executionEntity);
                        correlationParameters.put(name, value);
                        continue;
                    }
                    correlationParameters.put(name, valueExpression);
                    continue;
                }
                correlationParameters.put(name, null);
            }
            correlationKey = CommandContextUtil.getEventRegistry().generateKey(correlationParameters);
        }
        return correlationKey;
    }
}

