/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class JobUtil {
    public static JobEntity createJob(ExecutionEntity execution, String jobHandlerType, ProcessEngineConfigurationImpl processEngineConfiguration) {
        return JobUtil.createJob(execution, (BaseElement)execution.getCurrentFlowElement(), jobHandlerType, processEngineConfiguration);
    }

    public static JobEntity createJob(ExecutionEntity execution, BaseElement baseElement, String jobHandlerType, ProcessEngineConfigurationImpl processEngineConfiguration) {
        Expression categoryExpression;
        Object categoryValue;
        ExtensionElement jobCategoryElement;
        JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setExecutionId(execution.getId());
        job.setProcessInstanceId(execution.getProcessInstanceId());
        job.setProcessDefinitionId(execution.getProcessDefinitionId());
        job.setElementId(baseElement.getId());
        if (baseElement instanceof FlowElement) {
            job.setElementName(((FlowElement)baseElement).getName());
        }
        job.setJobHandlerType(jobHandlerType);
        List jobCategoryElements = (List)baseElement.getExtensionElements().get("jobCategory");
        if (jobCategoryElements != null && jobCategoryElements.size() > 0 && StringUtils.isNotEmpty((CharSequence)(jobCategoryElement = (ExtensionElement)jobCategoryElements.get(0)).getElementText()) && (categoryValue = (categoryExpression = processEngineConfiguration.getExpressionManager().createExpression(jobCategoryElement.getElementText())).getValue((VariableContainer)execution)) != null) {
            job.setCategory(categoryValue.toString());
        }
        if (execution.getTenantId() != null) {
            job.setTenantId(execution.getTenantId());
        }
        return job;
    }
}

