/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.repository.ProcessDefinition;

public class ProcessDefinitionUtil {
    public static String getDefinitionDeploymentId(String processDefinitionId) {
        return ProcessDefinitionUtil.getDefinitionDeploymentId(processDefinitionId, CommandContextUtil.getProcessEngineConfiguration());
    }

    public static String getDefinitionDeploymentId(String processDefinitionId, ProcessEngineConfigurationImpl processEngineConfiguration) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId, false, processEngineConfiguration);
        return ProcessDefinitionUtil.getDefinitionDeploymentId(processDefinition, processEngineConfiguration);
    }

    public static String getDefinitionDeploymentId(ProcessDefinition processDefinition, ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (processDefinition != null) {
            DeploymentManager deploymentManager = processEngineConfiguration.getDeploymentManager();
            DeploymentEntity processDeployment = (DeploymentEntity)deploymentManager.getDeploymentEntityManager().findById(processDefinition.getDeploymentId());
            if (StringUtils.isEmpty((CharSequence)processDeployment.getParentDeploymentId())) {
                return processDefinition.getDeploymentId();
            }
            return processDeployment.getParentDeploymentId();
        }
        return null;
    }

    public static ProcessDefinition getProcessDefinition(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcessDefinition(processDefinitionId, false);
    }

    public static ProcessDefinition getProcessDefinition(String processDefinitionId, boolean checkCacheOnly) {
        return ProcessDefinitionUtil.getProcessDefinition(processDefinitionId, checkCacheOnly, CommandContextUtil.getProcessEngineConfiguration());
    }

    public static ProcessDefinition getProcessDefinition(String processDefinitionId, boolean checkCacheOnly, ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (checkCacheOnly) {
            ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)processEngineConfiguration.getProcessDefinitionCache().get(processDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getProcessDefinition();
            }
            return null;
        }
        return processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId);
    }

    public static Process getProcess(String processDefinitionId) {
        if (Context.getCommandContext() == null) {
            throw new FlowableException("Cannot get process model: no current command context is active");
        }
        if (CommandContextUtil.getProcessEngineConfiguration() == null) {
            return Flowable5Util.getFlowable5CompatibilityHandler().getProcessDefinitionProcessObject(processDefinitionId);
        }
        DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getProcess();
    }

    public static BpmnModel getBpmnModel(String processDefinitionId) {
        if (CommandContextUtil.getProcessEngineConfiguration() == null) {
            return Flowable5Util.getFlowable5CompatibilityHandler().getProcessDefinitionBpmnModel(processDefinitionId);
        }
        DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getBpmnModel();
    }

    public static BpmnModel getBpmnModelFromCache(String processDefinitionId) {
        ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)CommandContextUtil.getProcessEngineConfiguration().getProcessDefinitionCache().get(processDefinitionId);
        if (cacheEntry != null) {
            return cacheEntry.getBpmnModel();
        }
        return null;
    }

    public static boolean isProcessDefinitionSuspended(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition = ProcessDefinitionUtil.getProcessDefinitionFromDatabase(processDefinitionId);
        return processDefinition.isSuspended();
    }

    public static ProcessDefinitionEntity getProcessDefinitionFromDatabase(String processDefinitionId) {
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessEngineConfiguration().getProcessDefinitionEntityManager();
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)processDefinitionEntityManager.findById(processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("No process definition found with id " + processDefinitionId);
        }
        return processDefinition;
    }
}

