/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.persistence.entity.AbstractVariableServiceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class VariableInstanceEntityImpl
extends AbstractVariableServiceEntity
implements VariableInstanceEntity,
ValueFields,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected VariableType type;
    protected String typeName;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String taskId;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayRef byteArrayRef;
    protected Object cachedValue;
    protected boolean forcedUpdate;
    protected boolean deleted;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("name", this.name);
        if (this.type != null) {
            persistentState.put("typeName", this.type.getTypeName());
        }
        persistentState.put("executionId", this.executionId);
        persistentState.put("scopeId", this.scopeId);
        persistentState.put("subScopeId", this.subScopeId);
        persistentState.put("scopeType", this.scopeType);
        persistentState.put("longValue", this.longValue);
        persistentState.put("doubleValue", this.doubleValue);
        persistentState.put("textValue", this.textValue);
        persistentState.put("textValue2", this.textValue2);
        if (this.byteArrayRef != null && this.byteArrayRef.getId() != null) {
            persistentState.put("byteArrayValueId", this.byteArrayRef.getId());
        }
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        return persistentState;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public byte[] getBytes() {
        this.ensureByteArrayRefInitialized();
        return this.byteArrayRef.getBytes(this.getEngineType());
    }

    public void setBytes(byte[] bytes) {
        this.ensureByteArrayRefInitialized();
        this.byteArrayRef.setValue("var-" + this.name, bytes, this.getEngineType());
    }

    @Override
    public ByteArrayRef getByteArrayRef() {
        return this.byteArrayRef;
    }

    protected void ensureByteArrayRefInitialized() {
        if (this.byteArrayRef == null) {
            this.byteArrayRef = new ByteArrayRef();
        }
    }

    public Object getValue() {
        if (!this.type.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.type.getValue((ValueFields)this);
        }
        return this.cachedValue;
    }

    public void setValue(Object value) {
        this.type.setValue(value, (ValueFields)this);
        this.typeName = this.type.getTypeName();
        this.cachedValue = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        if (this.type != null) {
            return this.type.getTypeName();
        }
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public VariableType getType() {
        return this.type;
    }

    @Override
    public void setType(VariableType type) {
        this.type = type;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public void setSubScopeId(String subScopeId) {
        this.subScopeId = subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue2() {
        return this.textValue2;
    }

    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    protected String getEngineType() {
        if (StringUtils.isNotEmpty((CharSequence)this.scopeType)) {
            return this.scopeType;
        }
        return "bpmn";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VariableInstanceEntity[");
        sb.append("id=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", type=").append(this.type != null ? this.type.getTypeName() : "null");
        if (this.longValue != null) {
            sb.append(", longValue=").append(this.longValue);
        }
        if (this.doubleValue != null) {
            sb.append(", doubleValue=").append(this.doubleValue);
        }
        if (this.textValue != null) {
            sb.append(", textValue=").append(StringUtils.abbreviate((String)this.textValue, (int)40));
        }
        if (this.textValue2 != null) {
            sb.append(", textValue2=").append(StringUtils.abbreviate((String)this.textValue2, (int)40));
        }
        if (this.byteArrayRef != null && this.byteArrayRef.getId() != null) {
            sb.append(", byteArrayValueId=").append(this.byteArrayRef.getId());
        }
        sb.append("]");
        return sb.toString();
    }
}

