/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;

public enum PythonOS {
    PLATFORM_JAVA("java"),
    PLATFORM_CYGWIN("cygwin"),
    PLATFORM_LINUX("linux"),
    PLATFORM_DARWIN("darwin"),
    PLATFORM_WIN32("win32"),
    PLATFORM_SUNOS("sunos"),
    PLATFORM_FREEBSD("freebsd"),
    PLATFORM_ANY(null);

    private final TruffleString name;
    private static final PythonOS current;

    private PythonOS(String name) {
        this.name = PythonUtils.toTruffleStringUncached(name);
    }

    public TruffleString getName() {
        return this.name;
    }

    public static PythonOS getPythonOS() {
        return current;
    }

    static {
        String property = System.getProperty("os.name");
        PythonOS os = PLATFORM_JAVA;
        if (property != null) {
            if ((property = property.toLowerCase()).contains("cygwin")) {
                os = PLATFORM_CYGWIN;
            } else if (property.contains("linux")) {
                os = PLATFORM_LINUX;
            } else if (property.contains("mac")) {
                os = PLATFORM_DARWIN;
            } else if (property.contains("windows")) {
                os = PLATFORM_WIN32;
            } else if (property.contains("sunos")) {
                os = PLATFORM_SUNOS;
            } else if (property.contains("freebsd")) {
                os = PLATFORM_FREEBSD;
            }
        }
        current = os;
    }
}

