/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.lib.PyImportImport;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextImportBuiltins {

    static abstract class PyImport_GetModule
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        private static final TruffleString T__LOCK_UNLOCK_MODULE = PythonUtils.tsLiteral("_lock_unlock_module");

        PyImport_GetModule() {
        }

        @Specialization
        Object getModule(Object name, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItem, @Cached PyObjectGetAttr getAttr, @Cached PyObjectIsTrueNode isTrueNode) {
            Object m;
            PythonContext context = PythonContext.get(inliningTarget);
            PDict modules = context.getSysModules();
            try {
                m = getItem.execute(null, inliningTarget, modules, name);
            }
            catch (PException e) {
                return context.getNativeNull();
            }
            if (m != PNone.NONE) {
                boolean initializing = false;
                try {
                    Object spec = getAttr.execute(null, inliningTarget, m, SpecialAttributeNames.T___SPEC__);
                    Object initializingObj = getAttr.execute(null, inliningTarget, spec, SpecialAttributeNames.T___INITIALIZING__);
                    if (isTrueNode.execute(null, inliningTarget, initializingObj)) {
                        initializing = true;
                    }
                }
                catch (PException pException) {
                    // empty catch block
                }
                if (initializing) {
                    PyImport_GetModule.waitForInitialization(name, context);
                }
            }
            return m;
        }

        @CompilerDirectives.TruffleBoundary
        private static void waitForInitialization(Object name, PythonContext context) {
            PyObjectCallMethodObjArgs.executeUncached(context.getImportlib(), T__LOCK_UNLOCK_MODULE, name);
        }
    }

    static abstract class PyImport_ImportModuleLevelObject
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyImport_ImportModuleLevelObject() {
        }

        @Specialization
        Object importModuleLevelObject(TruffleString name, Object globals, Object locals, Object fromlist, int level, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallNode callNode) {
            Object importFunc = getAttrNode.execute(null, inliningTarget, this.getContext().getBuiltins(), BuiltinNames.T___IMPORT__);
            return callNode.executeWithoutFrame(importFunc, new Object[]{name}, new PKeyword[]{new PKeyword(BuiltinNames.T_GLOBALS, globals), new PKeyword(BuiltinNames.T_LOCALS, locals), new PKeyword(PyImportImport.T_FROMLIST, fromlist), new PKeyword(PyImportImport.T_LEVEL, level)});
        }
    }

    static abstract class PyImport_GetModuleDict
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyImport_GetModuleDict() {
        }

        @Specialization
        Object getModuleDict() {
            return this.getContext().getSysModules();
        }
    }

    static abstract class PyImport_ImportModule
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyImport_ImportModule() {
        }

        @Specialization
        static Object imp(TruffleString name) {
            return AbstractImportNode.importModule(name);
        }
    }
}

