/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBytesBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.GetNextVaArgNode;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectAsFileDescriptor;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.lib.PyObjectDir;
import com.oracle.graal.python.lib.PyObjectGetAttrO;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttrO;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.PrintWriter;

public abstract class PythonCextObjectBuiltins {
    private PythonCextObjectBuiltins() {
    }

    static abstract class PyTruffleObject_GenericGetDict
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleObject_GenericGetDict() {
        }

        @Specialization
        static Object getDict(Object object, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, object);
        }
    }

    static abstract class PyObject_Dir
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Dir() {
        }

        @Specialization
        static Object dir(Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectDir dir) {
            return dir.execute(null, inliningTarget, object);
        }
    }

    static abstract class PyCallable_Check
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCallable_Check() {
        }

        @Specialization
        static int doGeneric(Object object, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck) {
            return PInt.intValue(callableCheck.execute(inliningTarget, object));
        }
    }

    static abstract class PyObject_Hash
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Hash() {
        }

        @Specialization
        static long hash(Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode) {
            return hashNode.execute(null, inliningTarget, object);
        }
    }

    static abstract class PyObject_GetIter
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_GetIter() {
        }

        @Specialization
        static Object iter(Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter) {
            return getIter.execute(null, inliningTarget, object);
        }
    }

    static abstract class PyObject_Format
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_Format() {
        }

        @Specialization
        static Object ascii(Object obj, Object spec, @Cached BuiltinFunctions.FormatNode format) {
            return format.execute(null, obj, spec);
        }
    }

    static abstract class PyObject_ASCII
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_ASCII() {
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static TruffleString ascii(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectAsciiNode asciiNode) {
            return asciiNode.execute(null, inliningTarget, obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        static TruffleString asciiNone(PNone obj) {
            return StringLiterals.T_NULL_RESULT;
        }
    }

    static abstract class _PyObject_Dump
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyObject_Dump() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int doGeneric(Object ptrObject, @Cached CStructAccess.ReadI64Node readI64) {
            PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper;
            Object resolved;
            PythonContext context = this.getContext();
            PrintWriter stderr = new PrintWriter(context.getStandardErr());
            boolean isWrapper = CApiGuards.isNativeWrapper(ptrObject);
            Object object = resolved = isWrapper ? ptrObject : CExtNodes.ResolvePointerNode.executeUncached(ptrObject);
            long refCnt = resolved instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper ? ((objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)resolved).isNative() ? objectNativeWrapper.getRefCount() : 10L) : readI64.read(CApiTransitions.PythonToNativeNode.executeUncached(resolved), CFields.PyObject__ob_refcnt);
            Object pythonObject = CApiTransitions.NativeToPythonNode.executeUncached(ptrObject);
            stderr.println("ptrObject address  : " + String.valueOf(ptrObject));
            stderr.println("ptrObject refcount : " + refCnt);
            stderr.flush();
            Object type = GetClassNode.executeUncached(pythonObject);
            stderr.println("object type     : " + String.valueOf(type));
            stderr.println("object type name: " + String.valueOf(TypeNodes.GetNameNode.executeUncached(type)));
            stderr.println("object repr     : ");
            stderr.flush();
            try {
                Object reprObj = PyObjectCallMethodObjArgs.executeUncached(context.getBuiltins(), BuiltinNames.T_REPR, pythonObject);
                stderr.println(CastToJavaStringNode.getUncached().execute(reprObj));
            }
            catch (CannotCastException | PException object2) {
                // empty catch block
            }
            stderr.flush();
            return 0;
        }
    }

    static abstract class _PyTruffle_SET_SIZE
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyTruffle_SET_SIZE() {
        }

        @Specialization
        static PNone set(PSequence obj, long size, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached InlinedBranchProfile basicProfile, @Cached InlinedBranchProfile nativeProfile) {
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, obj);
            if (storage instanceof ArrayBasedSequenceStorage) {
                ArrayBasedSequenceStorage basicStorage = (ArrayBasedSequenceStorage)storage;
                basicProfile.enter(inliningTarget);
                basicStorage.setNewLength((int)size);
            } else if (storage instanceof NativeSequenceStorage) {
                NativeSequenceStorage nativeStorage = (NativeSequenceStorage)storage;
                nativeProfile.enter(inliningTarget);
                nativeStorage.setNewLength((int)size);
            } else if (storage instanceof EmptySequenceStorage) {
                if (size > 0L) {
                    throw CompilerDirectives.shouldNotReachHere((String)"invalid Py_SET_SIZE call");
                }
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"unhandled storage type");
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyTruffle_None
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffle_None() {
        }

        @Specialization
        static PNone doNativeNone() {
            return PNone.NONE;
        }
    }

    static abstract class PyTruffle_NoValue
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffle_NoValue() {
        }

        @Specialization
        static PNone doNoValue() {
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyTruffle_NotImplemented
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffle_NotImplemented() {
        }

        @Specialization
        static Object run() {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    static abstract class PyObject_Bytes
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Bytes() {
        }

        @Specialization
        static Object bytes(PBytesLike bytes) {
            return bytes;
        }

        @Specialization(guards={"!isBytes(bytes)", "isBytesSubtype(inliningTarget, bytes, getClassNode, isSubtypeNode)"}, limit="1")
        static Object bytes(Object bytes, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode) {
            return bytes;
        }

        @Specialization(guards={"!isBytes(obj)", "!isBytesSubtype(this, obj, getClassNode, isSubtypeNode)", "!isNoValue(obj)", "hasBytes(inliningTarget, obj, lookupAttrNode)"}, limit="1")
        static Object bytes(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached PyObjectLookupAttr lookupAttrNode, @Cached BuiltinConstructors.BytesNode bytesNode) {
            return bytesNode.execute(null, (Object)PythonBuiltinClassType.PBytes, obj, PNone.NO_VALUE, PNone.NO_VALUE);
        }

        @Specialization(guards={"!isBytes(obj)", "!isBytesSubtype(this, obj, getClassNode, isSubtypeNode)", "!isNoValue(obj)", "!hasBytes(inliningTarget, obj, lookupAttrNode)"}, limit="1")
        static Object bytes(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtypeNode, @Cached.Exclusive @Cached PyObjectLookupAttr lookupAttrNode, @Cached PythonCextBytesBuiltins.PyBytes_FromObject fromObjectNode) {
            return fromObjectNode.execute(obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        static Object bytesNoValue(Object obj, @Cached PythonObjectFactory factory) {
            return factory.createBytes(BytesUtils.NULL_STRING);
        }

        protected static boolean hasBytes(Node inliningTarget, Object obj, PyObjectLookupAttr lookupAttrNode) {
            return lookupAttrNode.execute(null, inliningTarget, obj, SpecialMethodNames.T___BYTES__) != PNone.NO_VALUE;
        }

        protected static boolean isBytesSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PBytes);
        }
    }

    static abstract class PyObject_IsTrue
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_IsTrue() {
        }

        @Specialization
        static int isTrue(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
            return isTrueNode.execute(null, inliningTarget, obj) ? 1 : 0;
        }
    }

    static abstract class PyObject_HashNotImplemented
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_HashNotImplemented() {
        }

        @Specialization
        static Object unhashable(Object obj, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, obj);
        }
    }

    static abstract class PyObject_HasAttr
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_HasAttr() {
        }

        @Specialization
        static int hasAttr(Object obj, Object attr, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttrO lookupAttrNode, @Cached InlinedBranchProfile exceptioBranchProfile) {
            try {
                return lookupAttrNode.execute(null, inliningTarget, obj, attr) != PNone.NO_VALUE ? 1 : 0;
            }
            catch (PException e) {
                exceptioBranchProfile.enter(inliningTarget);
                return 0;
            }
        }
    }

    static abstract class PyTruffleObject_GenericSetAttr
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleObject_GenericSetAttr() {
        }

        @Specialization
        static int setAttr(Object obj, Object attr, Object value, @Cached ObjectBuiltins.SetattrNode setAttrNode) {
            setAttrNode.execute(null, obj, attr, value);
            return 0;
        }
    }

    static abstract class PyTruffleObject_GenericGetAttr
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleObject_GenericGetAttr() {
        }

        @Specialization
        static Object getAttr(Object obj, Object attr, @Cached ObjectBuiltins.GetAttributeNode getAttrNode) {
            return getAttrNode.execute(null, obj, attr);
        }
    }

    static abstract class PyObject_AsFileDescriptor
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_AsFileDescriptor() {
        }

        @Specialization
        static Object asFileDescriptor(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyLongCheckNode longCheckNode, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached TruffleString.EqualNode eqNode, @Cached PyObjectAsFileDescriptor asFileDescriptorNode, @Cached PRaiseNode.Lazy raiseNode) {
            PosixSupport posixSupport;
            if (!longCheckNode.execute(inliningTarget, obj) && eqNode.execute((AbstractTruffleString)StringLiterals.T_JAVA, (AbstractTruffleString)posixLib.getBackend(posixSupport = PythonContext.get(inliningTarget).getPosixSupport()), PythonUtils.TS_ENCODING)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.S_NOT_SUPPORTED_ON_JAVA_POSIX_BACKEND, "PyObject_AsFileDescriptor");
            }
            return asFileDescriptorNode.execute(null, inliningTarget, obj);
        }
    }

    static abstract class PyObject_IsSubclass
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_IsSubclass() {
        }

        @Specialization
        static int doGeneric(Object obj, Object typ, @Cached BuiltinFunctions.IsSubClassNode isSubclassNode) {
            return PInt.intValue((Boolean)isSubclassNode.execute(null, obj, typ));
        }
    }

    static abstract class PyObject_IsInstance
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_IsInstance() {
        }

        @Specialization
        static int doGeneric(Object obj, Object typ, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode) {
            return PInt.intValue((Boolean)isInstanceNode.execute(null, obj, typ));
        }
    }

    static abstract class PyObject_SetItem
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyObject_SetItem() {
        }

        @Specialization
        static Object doGeneric(Object obj, Object k, Object v, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetItem setItemNode) {
            setItemNode.execute(null, inliningTarget, obj, k, v);
            return 0;
        }
    }

    static abstract class PyObject_DelItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_DelItem() {
        }

        @Specialization
        static Object doGeneric(Object obj, Object k, @Bind(value="this") Node inliningTarget, @Cached PyObjectDelItem delNode) {
            delNode.execute(null, inliningTarget, obj, k);
            return 0;
        }
    }

    static abstract class PyObject_Repr
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Repr() {
        }

        @Specialization(guards={"!isNoValue(obj)"})
        Object doGeneric(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsObjectNode reprNode) {
            return reprNode.execute(null, inliningTarget, obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        static TruffleString asciiNone(PNone obj) {
            return StringLiterals.T_NULL_RESULT;
        }
    }

    static abstract class PyObject_Str
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_Str() {
        }

        @Specialization(guards={"!isNoValue(obj)"})
        Object doGeneric(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectStrAsObjectNode strNode) {
            return strNode.execute(inliningTarget, obj);
        }

        @Specialization(guards={"isNoValue(obj)"})
        static TruffleString asciiNone(PNone obj) {
            return StringLiterals.T_NULL_RESULT;
        }
    }

    static abstract class _PyObject_MakeTpCall
    extends PythonCextBuiltins.CApi5BuiltinNode {
        _PyObject_MakeTpCall() {
        }

        @Specialization
        static Object doGeneric(Object threadState, Object callable, Object argsArray, long nargs, Object kwargs, @Cached CStructAccess.ReadObjectNode readNode, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadObjectNode readKwNode, @Cached ExpandKeywordStarargsNode castKwargsNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached CallNode callNode, @Cached CastToTruffleStringNode castToTruffleStringNode) {
            try {
                PKeyword[] keywords;
                Object[] args = readNode.readPyObjectArray(argsArray, (int)nargs);
                if (kwargs instanceof PNone) {
                    keywords = PKeyword.EMPTY_KEYWORDS;
                } else if (kwargs instanceof PDict) {
                    keywords = castKwargsNode.execute(inliningTarget, kwargs);
                } else if (kwargs instanceof PTuple) {
                    PTuple kwTuple = (PTuple)kwargs;
                    SequenceStorage storage = kwTuple.getSequenceStorage();
                    int kwcount = storage.length();
                    Object[] kwValues = readKwNode.readPyObjectArray(argsArray, kwcount, (int)nargs);
                    keywords = new PKeyword[kwcount];
                    for (int i = 0; i < kwcount; ++i) {
                        TruffleString name = castToTruffleStringNode.execute(inliningTarget, getItemScalarNode.execute(inliningTarget, storage, i));
                        keywords[i] = new PKeyword(name, kwValues[i]);
                    }
                } else {
                    throw CompilerDirectives.shouldNotReachHere((String)"_PyObject_MakeTpCall: keywords must be NULL, a tuple or a dict");
                }
                return callNode.execute((Frame)null, callable, args, keywords);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
        }
    }

    static abstract class _PyTruffleObject_CallMethod1
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        _PyTruffleObject_CallMethod1() {
        }

        @Specialization
        static Object doGeneric(Object receiver, TruffleString methodName, Object argsObj, int singleArg, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PythonCextBuiltins.CastArgsNode castArgsNode) {
            Object[] args = singleArg != 0 ? new Object[]{argsObj} : castArgsNode.execute(null, inliningTarget, argsObj);
            return callMethod.execute(null, inliningTarget, receiver, methodName, args);
        }
    }

    static abstract class PyTruffleObject_CallMethodObjArgs
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleObject_CallMethodObjArgs() {
        }

        @Specialization
        static Object doMethod(Object receiver, Object methodName, Object vaList, @Bind(value="this") Node inliningTarget, @Cached GetNextVaArgNode getVaArgs, @CachedLibrary(limit="2") InteropLibrary argLib, @Cached CallNode callNode, @Cached PyObjectGetAttrO getAnyAttributeNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode) {
            Object method = getAnyAttributeNode.execute(null, inliningTarget, receiver, methodName);
            return PyTruffleObject_CallFunctionObjArgs.callFunction(inliningTarget, method, vaList, getVaArgs, argLib, callNode, toJavaNode);
        }
    }

    static abstract class PyTruffleObject_CallFunctionObjArgs
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleObject_CallFunctionObjArgs() {
        }

        @Specialization
        static Object doFunction(Object callable, Object vaList, @Bind(value="this") Node inliningTarget, @Cached GetNextVaArgNode getVaArgs, @CachedLibrary(limit="2") InteropLibrary argLib, @Cached CallNode callNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode) {
            return PyTruffleObject_CallFunctionObjArgs.callFunction(inliningTarget, callable, vaList, getVaArgs, argLib, callNode, toJavaNode);
        }

        static Object callFunction(Node inliningTarget, Object callable, Object vaList, GetNextVaArgNode getVaArgs, InteropLibrary argLib, CallNode callNode, CApiTransitions.NativeToPythonNode toJavaNode) {
            Object[] args = new Object[4];
            int filled = 0;
            while (true) {
                Object object;
                try {
                    object = getVaArgs.execute(inliningTarget, vaList);
                }
                catch (InteropException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                if (argLib.isNull(object)) break;
                if (filled >= args.length) {
                    args = PythonUtils.arrayCopyOf(args, args.length * 2);
                }
                args[filled++] = toJavaNode.execute(object);
            }
            if (filled < args.length) {
                args = PythonUtils.arrayCopyOf(args, filled);
            }
            return callNode.executeWithoutFrame(callable, args);
        }
    }

    static abstract class _PyTruffleObject_Call1
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        _PyTruffleObject_Call1() {
        }

        @Specialization
        static Object doGeneric(Object callable, Object argsObj, Object kwargsObj, int singleArg, @Bind(value="this") Node inliningTarget, @Cached PythonCextBuiltins.CastArgsNode castArgsNode, @Cached PythonCextBuiltins.CastKwargsNode castKwargsNode, @Cached CallNode callNode) {
            Object[] args = singleArg != 0 ? new Object[]{argsObj} : castArgsNode.execute(null, inliningTarget, argsObj);
            PKeyword[] keywords = castKwargsNode.execute(inliningTarget, kwargsObj);
            return callNode.execute((Frame)null, callable, args, keywords);
        }
    }

    static abstract class PyTruffle_BulkNotifyRefCount
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_BulkNotifyRefCount() {
        }

        @Specialization
        static Object doGeneric(Object arrayPointer, int len, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.UpdateStrongRefNode updateRefNode, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CApiTransitions.ToPythonWrapperNode toPythonWrapperNode) {
            int i;
            PythonNativeWrapper[] resolved = new PythonNativeWrapper[len];
            for (i = 0; i < resolved.length; ++i) {
                Object elem = readPointerNode.readArrayElement(arrayPointer, i);
                resolved[i] = toPythonWrapperNode.executeWrapper(elem, false);
            }
            for (i = 0; i < resolved.length; ++i) {
                PythonNativeWrapper pythonNativeWrapper = resolved[i];
                if (!(pythonNativeWrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper)) continue;
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)pythonNativeWrapper;
                long refCount = CApiTransitions.readNativeRefCount(CApiTransitions.HandlePointerConverter.pointerToStub(objectNativeWrapper.getNativePointer()));
                assert (refCount != 0x3FFFFFFFFFFFFFFFL);
                updateRefNode.execute(inliningTarget, objectNativeWrapper, refCount);
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyTruffle_NotifyRefCount
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_NotifyRefCount() {
        }

        @Specialization
        static Object doGeneric(PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper, long refCount, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.UpdateStrongRefNode updateRefNode) {
            assert (CApiTransitions.readNativeRefCount(CApiTransitions.HandlePointerConverter.pointerToStub(wrapper.getNativePointer())) == refCount);
            assert (refCount != 0x3FFFFFFFFFFFFFFFL);
            updateRefNode.execute(inliningTarget, wrapper, refCount);
            return PNone.NO_VALUE;
        }
    }
}

