/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes.memory;

import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNode;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=PointerNodes.class)
public final class PointerNodesFactory {
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=PointerNodes.PointerIsNativeNode.class)
    public static final class PointerIsNativeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.PointerIsNativeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.PointerIsNativeNode inline(@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.PointerIsNativeNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.PointerIsNativeNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            boolean execute(Node arg0Value, Pointer.Storage arg1Value) {
                if (arg1Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg1Value_ = (Pointer.LongPointerStorage)arg1Value;
                    return PointerNodes.PointerIsNativeNode.doLongPointer(arg1Value_);
                }
                if (arg1Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg1Value_ = (Pointer.ObjectPointerStorage)arg1Value;
                    return PointerNodes.PointerIsNativeNode.doObjectPointer(arg1Value_);
                }
                return PointerNodes.PointerIsNativeNode.doOther(arg1Value);
            }
        }

        @GeneratedBy(value=PointerNodes.PointerIsNativeNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.PointerIsNativeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.PointerIsNativeNode.class));
                this.state_0_ = target.getState(0, 3);
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.Storage arg1Value) {
                if ((state_0 & 1) == 0 && arg1Value instanceof Pointer.LongPointerStorage) {
                    return false;
                }
                return (state_0 & 2) != 0 || !(arg1Value instanceof Pointer.ObjectPointerStorage);
            }

            @Override
            boolean execute(Node arg0Value, Pointer.Storage arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg1Value_ = (Pointer.LongPointerStorage)arg1Value;
                        return PointerNodes.PointerIsNativeNode.doLongPointer(arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && arg1Value instanceof Pointer.ObjectPointerStorage) {
                        Pointer.ObjectPointerStorage arg1Value_ = (Pointer.ObjectPointerStorage)arg1Value;
                        return PointerNodes.PointerIsNativeNode.doObjectPointer(arg1Value_);
                    }
                    if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return PointerNodes.PointerIsNativeNode.doOther(arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private boolean executeAndSpecialize(Node arg0Value, Pointer.Storage arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg1Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg1Value_ = (Pointer.LongPointerStorage)arg1Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.PointerIsNativeNode.doLongPointer(arg1Value_);
                }
                if (arg1Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg1Value_ = (Pointer.ObjectPointerStorage)arg1Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PointerNodes.PointerIsNativeNode.doObjectPointer(arg1Value_);
                }
                this.state_0_.set(arg0Value, state_0 |= 4);
                return PointerNodes.PointerIsNativeNode.doOther(arg1Value);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.PointerArrayToBytesNode.class)
    static final class PointerArrayToBytesNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        PointerArrayToBytesNodeGen() {
        }

        @NeverDefault
        public static PointerNodes.PointerArrayToBytesNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.PointerArrayToBytesNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=8, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.PointerArrayToBytesNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.PointerArrayToBytesNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Pointer.ByteArrayStorage execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.PointerArrayStorage arg2Value) {
                return PointerNodes.PointerArrayToBytesNode.convert(arg0Value, arg1Value, arg2Value, GetPointerValueAsLongNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.PointerArrayToBytesNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.PointerArrayToBytesNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Node> toNativeNode__field1_;
            private final InlineSupport.ReferenceField<Node> toNativeNode__field2_;
            private final InlineSupport.ReferenceField<Node> toNativeNode__field3_;
            private final PointerNodes.GetPointerValueAsLongNode toNativeNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.PointerArrayToBytesNode.class));
                this.state_0_ = target.getState(0, 8);
                this.toNativeNode__field1_ = target.getReference(1, Node.class);
                this.toNativeNode__field2_ = target.getReference(2, Node.class);
                this.toNativeNode__field3_ = target.getReference(3, Node.class);
                this.toNativeNode_ = GetPointerValueAsLongNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.GetPointerValueAsLongNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 8), this.toNativeNode__field1_, this.toNativeNode__field2_, this.toNativeNode__field3_}));
            }

            @Override
            Pointer.ByteArrayStorage execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.PointerArrayStorage arg2Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.toNativeNode__field1_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.toNativeNode__field2_, this.toNativeNode__field3_}));
                return PointerNodes.PointerArrayToBytesNode.convert(arg0Value, arg1Value, arg2Value, this.toNativeNode_);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.WritePointerNode.class)
    public static final class WritePointerNodeGen {
        private static final InlineSupport.StateField FALLBACK_WRITE_POINTER_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.WritePointerNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.WritePointerNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.WritePointerNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.WritePointerNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer arg4Value) {
                Pointer.Storage arg2Value_;
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    if (PointerNodes.isMultipleOf8(arg3Value)) {
                        PointerNodes.WritePointerNode.doPointerArray(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    PointerNodes.WritePointerNode.doZero(arg1Value, (Pointer.ZeroStorage)arg2Value_, arg3Value, arg4Value);
                    return;
                }
                PointerNodes.WritePointerNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, WriteLongNodeGen.getUncached(), GetPointerValueAsLongNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.WritePointerNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.WritePointerNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.WriteLongNode fallback_writeLongNode_;
            private final PointerNodes.GetPointerValueAsLongNode fallback_toNativeNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.WritePointerNode.class));
                this.state_0_ = target.getState(0, 3);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_writeLongNode_ = WriteLongNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.WriteLongNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_WRITE_POINTER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeLongNode__field1_", Node.class)}));
                this.fallback_toNativeNode_ = GetPointerValueAsLongNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.GetPointerValueAsLongNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_WRITE_POINTER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(5, 8), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_toNativeNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_toNativeNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_toNativeNode__field3_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer arg4Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.PointerArrayStorage && PointerNodes.isMultipleOf8(arg3Value)) {
                    return false;
                }
                return (state_0 & 2) != 0 || !(arg2Value instanceof Pointer.ZeroStorage);
            }

            @Override
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s2_;
                    Pointer.Storage arg2Value_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                        arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        if (PointerNodes.isMultipleOf8(arg3Value)) {
                            PointerNodes.WritePointerNode.doPointerArray(arg1Value, arg2Value_, arg3Value, arg4Value);
                            return;
                        }
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        PointerNodes.WritePointerNode.doZero(arg1Value, (Pointer.ZeroStorage)arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 4) != 0 && (s2_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value)) {
                        PointerNodes.WritePointerNode.doOther(s2_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeLongNode_, this.fallback_toNativeNode_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer arg4Value) {
                Pointer.Storage arg2Value_;
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    if (PointerNodes.isMultipleOf8(arg3Value)) {
                        this.state_0_.set(arg0Value, state_0 |= 1);
                        PointerNodes.WritePointerNode.doPointerArray(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    PointerNodes.WritePointerNode.doZero(arg1Value, (Pointer.ZeroStorage)arg2Value_, arg3Value, arg4Value);
                    return;
                }
                FallbackData s2_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s2_);
                this.state_0_.set(arg0Value, state_0 |= 4);
                PointerNodes.WritePointerNode.doOther(s2_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeLongNode_, this.fallback_toNativeNode_);
            }
        }

        @GeneratedBy(value=PointerNodes.WritePointerNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeLongNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_toNativeNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_toNativeNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_toNativeNode__field3_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.ReadPythonObject.class)
    public static final class ReadPythonObjectNodeGen {
        private static final InlineSupport.StateField FALLBACK_READ_PYTHON_OBJECT_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.ReadPythonObject getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.ReadPythonObject inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=2, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.ReadPythonObject.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.ReadPythonObject
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Object execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.PythonObjectStorage) {
                    Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                    if (arg3Value == 0) {
                        return PointerNodes.ReadPythonObject.doPythonObject(arg1Value, arg2Value_, arg3Value);
                    }
                }
                return PointerNodes.ReadPythonObject.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, GetPointerValueAsObjectNodeGen.getUncached(), CExtNodesFactory.ResolvePointerNodeGen.getUncached(), CApiTransitions.NativeToPythonNode.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.ReadPythonObject.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.ReadPythonObject
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.GetPointerValueAsObjectNode fallback_getPointerValueAsObjectNode_;
            private final CExtNodes.ResolvePointerNode fallback_resolveHandleNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.ReadPythonObject.class));
                this.state_0_ = target.getState(0, 2);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_getPointerValueAsObjectNode_ = GetPointerValueAsObjectNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.GetPointerValueAsObjectNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_READ_PYTHON_OBJECT_FALLBACK_STATE_0_UPDATER.subUpdater(0, 8), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_getPointerValueAsObjectNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_getPointerValueAsObjectNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_getPointerValueAsObjectNode__field3_", Node.class)}));
                this.fallback_resolveHandleNode_ = CExtNodesFactory.ResolvePointerNodeGen.inline(InlineSupport.InlineTarget.create(CExtNodes.ResolvePointerNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_READ_PYTHON_OBJECT_FALLBACK_STATE_0_UPDATER.subUpdater(8, 19), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field6_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field7_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field8_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field9_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field10_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_resolveHandleNode__field11_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                return (state_0 & 1) != 0 || !(arg2Value instanceof Pointer.PythonObjectStorage) || arg3Value != 0;
            }

            @Override
            protected Object execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s1_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.PythonObjectStorage) {
                        Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                        if (arg3Value == 0) {
                            return PointerNodes.ReadPythonObject.doPythonObject(arg1Value, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 2) != 0 && (s1_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        return PointerNodes.ReadPythonObject.doGeneric(s1_, arg1Value, arg2Value, arg3Value, this.fallback_getPointerValueAsObjectNode_, this.fallback_resolveHandleNode_, s1_.nativeToPythonNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private Object executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.PythonObjectStorage) {
                    Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                    if (arg3Value == 0) {
                        this.state_0_.set(arg0Value, state_0 |= 1);
                        return PointerNodes.ReadPythonObject.doPythonObject(arg1Value, arg2Value_, arg3Value);
                    }
                }
                FallbackData s1_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                CApiTransitions.NativeToPythonNode nativeToPythonNode__ = (CApiTransitions.NativeToPythonNode)s1_.insert(CApiTransitions.NativeToPythonNode.create());
                Objects.requireNonNull(nativeToPythonNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.nativeToPythonNode_ = nativeToPythonNode__;
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s1_);
                this.state_0_.set(arg0Value, state_0 |= 2);
                return PointerNodes.ReadPythonObject.doGeneric(s1_, arg1Value, arg2Value, arg3Value, this.fallback_getPointerValueAsObjectNode_, this.fallback_resolveHandleNode_, nativeToPythonNode__);
            }
        }

        @GeneratedBy(value=PointerNodes.ReadPythonObject.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_getPointerValueAsObjectNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_getPointerValueAsObjectNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_getPointerValueAsObjectNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private Object fallback_resolveHandleNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field4_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field5_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field6_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field7_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field8_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field9_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field10_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_resolveHandleNode__field11_;
            @Node.Child
            CApiTransitions.NativeToPythonNode nativeToPythonNode_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.ReadPointerNode.class)
    public static final class ReadPointerNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.ReadPointerNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.ReadPointerNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.ReadPointerNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.ReadPointerNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Pointer execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    if (PointerNodes.isMultipleOf8(arg3Value)) {
                        return PointerNodes.ReadPointerNode.doPointerArray(arg1Value, arg2Value_, arg3Value);
                    }
                }
                return PointerNodes.ReadPointerNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, ReadLongNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.ReadPointerNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.ReadPointerNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Node> fallback_readLongNode__field1_;
            private final PointerNodes.ReadLongNode fallback_readLongNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.ReadPointerNode.class));
                this.state_0_ = target.getState(0, 6);
                this.fallback_readLongNode__field1_ = target.getReference(1, Node.class);
                this.fallback_readLongNode_ = ReadLongNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadLongNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(2, 4), this.fallback_readLongNode__field1_}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                return (state_0 & 1) != 0 || !(arg2Value instanceof Pointer.PointerArrayStorage) || !PointerNodes.isMultipleOf8(arg3Value);
            }

            @Override
            protected Pointer execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                        Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        if (PointerNodes.isMultipleOf8(arg3Value)) {
                            return PointerNodes.ReadPointerNode.doPointerArray(arg1Value, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 2) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.fallback_readLongNode__field1_));
                        return PointerNodes.ReadPointerNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, this.fallback_readLongNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private Pointer executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    if (PointerNodes.isMultipleOf8(arg3Value)) {
                        this.state_0_.set(arg0Value, state_0 |= 1);
                        return PointerNodes.ReadPointerNode.doPointerArray(arg1Value, arg2Value_, arg3Value);
                    }
                }
                this.state_0_.set(arg0Value, state_0 |= 2);
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.fallback_readLongNode__field1_));
                return PointerNodes.ReadPointerNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, this.fallback_readLongNode_);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.PointerFromLongNode.class)
    public static final class PointerFromLongNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.PointerFromLongNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.PointerFromLongNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=9, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.PointerFromLongNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.PointerFromLongNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Pointer execute(Node arg0Value, Object arg1Value) {
                if (arg1Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                    return PointerNodes.PointerFromLongNode.doNativeVoidPtr(arg1Value_);
                }
                return PointerNodes.PointerFromLongNode.doLong(arg0Value, arg1Value, CastToJavaUnsignedLongNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.PointerFromLongNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.PointerFromLongNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Node> fallback_cast__field1_;
            private final CastToJavaUnsignedLongNode fallback_cast_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.PointerFromLongNode.class));
                this.state_0_ = target.getState(0, 9);
                this.fallback_cast__field1_ = target.getReference(1, Node.class);
                this.fallback_cast_ = CastToJavaUnsignedLongNodeGen.inline(InlineSupport.InlineTarget.create(CastToJavaUnsignedLongNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(2, 7), this.fallback_cast__field1_}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof PythonNativeVoidPtr);
            }

            @Override
            public Pointer execute(Node arg0Value, Object arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                        return PointerNodes.PointerFromLongNode.doNativeVoidPtr(arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.fallback_cast__field1_));
                        return PointerNodes.PointerFromLongNode.doLong(arg0Value, arg1Value, this.fallback_cast_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Pointer executeAndSpecialize(Node arg0Value, Object arg1Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg1Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.PointerFromLongNode.doNativeVoidPtr(arg1Value_);
                }
                this.state_0_.set(arg0Value, state_0 |= 2);
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.fallback_cast__field1_));
                return PointerNodes.PointerFromLongNode.doLong(arg0Value, arg1Value, this.fallback_cast_);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.FreeNode.class)
    public static final class FreeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.FreeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.FreeNode inline(@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.FreeNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.FreeNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            void execute(Node arg0Value, Pointer.Storage arg1Value, int arg2Value) {
                if (arg1Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg1Value_ = (Pointer.LongPointerStorage)arg1Value;
                    this.doNativeMemory(arg0Value, arg1Value_, arg2Value);
                    return;
                }
                if (arg1Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg1Value_ = (Pointer.ObjectPointerStorage)arg1Value;
                    this.doObjectPointer(arg1Value_, arg2Value);
                    return;
                }
                this.doNothing(arg1Value, arg2Value);
            }
        }

        @GeneratedBy(value=PointerNodes.FreeNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.FreeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.FreeNode.class));
                this.state_0_ = target.getState(0, 3);
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.Storage arg1Value, int arg2Value) {
                if ((state_0 & 1) == 0 && arg1Value instanceof Pointer.LongPointerStorage) {
                    return false;
                }
                return (state_0 & 2) != 0 || !(arg1Value instanceof Pointer.ObjectPointerStorage);
            }

            @Override
            void execute(Node arg0Value, Pointer.Storage arg1Value, int arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg1Value_ = (Pointer.LongPointerStorage)arg1Value;
                        this.doNativeMemory(arg0Value, arg1Value_, arg2Value);
                        return;
                    }
                    if ((state_0 & 2) != 0 && arg1Value instanceof Pointer.ObjectPointerStorage) {
                        Pointer.ObjectPointerStorage arg1Value_ = (Pointer.ObjectPointerStorage)arg1Value;
                        this.doObjectPointer(arg1Value_, arg2Value);
                        return;
                    }
                    if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                        this.doNothing(arg1Value, arg2Value);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void executeAndSpecialize(Node arg0Value, Pointer.Storage arg1Value, int arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg1Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg1Value_ = (Pointer.LongPointerStorage)arg1Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    this.doNativeMemory(arg0Value, arg1Value_, arg2Value);
                    return;
                }
                if (arg1Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg1Value_ = (Pointer.ObjectPointerStorage)arg1Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    this.doObjectPointer(arg1Value_, arg2Value);
                    return;
                }
                this.state_0_.set(arg0Value, state_0 |= 4);
                this.doNothing(arg1Value, arg2Value);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.GetPointerValueAsLongNode.class)
    public static final class GetPointerValueAsLongNodeGen
    extends PointerNodes.GetPointerValueAsLongNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private PointerNodes.GetPointerValueAsLongNode pointerArray_toNativeNode_;
        @Node.Child
        private MemoryViewData memoryView_cache;
        @Node.Child
        private PythonObjectData pythonObject_cache;

        private GetPointerValueAsLongNodeGen() {
        }

        @Override
        protected long execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                Pointer.Storage arg2Value_;
                if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.NullStorage) {
                    Pointer.NullStorage arg2Value_2 = (Pointer.NullStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_2, arg3Value);
                }
                if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_3 = (Pointer.LongPointerStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_3, arg3Value);
                }
                if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_4 = (Pointer.ByteArrayStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doBytes(this, arg1Value, arg2Value_4, arg3Value);
                }
                if ((state_0 & 8) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_5 = (Pointer.ZeroStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doZero(this, arg1Value, arg2Value_5, arg3Value);
                }
                if ((state_0 & 0x10) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                    arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    PointerNodes.GetPointerValueAsLongNode toNativeNode__ = this.pointerArray_toNativeNode_;
                    if (toNativeNode__ != null) {
                        return PointerNodes.AbstractGetPointerValueNode.doPointerArray(this, arg1Value, arg2Value_, arg3Value, toNativeNode__);
                    }
                }
                if ((state_0 & 0x20) != 0 && arg2Value instanceof Pointer.MemoryViewStorage) {
                    arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    MemoryViewData s5_ = this.memoryView_cache;
                    if (s5_ != null) {
                        return PointerNodes.AbstractGetPointerValueNode.doMemoryView(this, arg1Value, (Pointer.MemoryViewStorage)arg2Value_, arg3Value, s5_.ilib_, s5_.bufferLib_);
                    }
                }
                if ((state_0 & 0x40) != 0 && arg2Value instanceof Pointer.PythonObjectStorage) {
                    arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                    PythonObjectData s6_ = this.pythonObject_cache;
                    if (s6_ != null) {
                        return PointerNodes.AbstractGetPointerValueNode.doPythonObject(this, arg1Value, (Pointer.PythonObjectStorage)arg2Value_, arg3Value, s6_.toNativeNode_, s6_.lib_);
                    }
                }
                if ((state_0 & 0x80) != 0 && arg2Value instanceof Pointer.ObjectPointerStorage) {
                    arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                    return PointerNodes.GetPointerValueAsLongNode.doObjectPointer(this, arg1Value, (Pointer.ObjectPointerStorage)arg2Value_, arg3Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private long executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
            int state_0 = this.state_0_;
            if (arg2Value instanceof Pointer.NullStorage) {
                Pointer.NullStorage arg2Value_ = (Pointer.NullStorage)arg2Value;
                this.state_0_ = state_0 |= 1;
                return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_, arg3Value);
            }
            if (arg2Value instanceof Pointer.LongPointerStorage) {
                Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                this.state_0_ = state_0 |= 2;
                return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_, arg3Value);
            }
            if (arg2Value instanceof Pointer.ByteArrayStorage) {
                Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                this.state_0_ = state_0 |= 4;
                return PointerNodes.AbstractGetPointerValueNode.doBytes(this, arg1Value, arg2Value_, arg3Value);
            }
            if (arg2Value instanceof Pointer.ZeroStorage) {
                Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                this.state_0_ = state_0 |= 8;
                return PointerNodes.AbstractGetPointerValueNode.doZero(this, arg1Value, arg2Value_, arg3Value);
            }
            if (arg2Value instanceof Pointer.PointerArrayStorage) {
                Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                PointerNodes.GetPointerValueAsLongNode toNativeNode__ = (PointerNodes.GetPointerValueAsLongNode)this.insert(GetPointerValueAsLongNodeGen.create());
                Objects.requireNonNull(toNativeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.pointerArray_toNativeNode_ = toNativeNode__;
                this.state_0_ = state_0 |= 0x10;
                return PointerNodes.AbstractGetPointerValueNode.doPointerArray(this, arg1Value, arg2Value_, arg3Value, toNativeNode__);
            }
            if (arg2Value instanceof Pointer.MemoryViewStorage) {
                Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                MemoryViewData s5_ = (MemoryViewData)this.insert(new MemoryViewData());
                InteropLibrary ilib__ = (InteropLibrary)s5_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(ilib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s5_.ilib_ = ilib__;
                PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)s5_.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s5_.bufferLib_ = bufferLib__;
                VarHandle.storeStoreFence();
                this.memoryView_cache = s5_;
                this.state_0_ = state_0 |= 0x20;
                return PointerNodes.AbstractGetPointerValueNode.doMemoryView(this, arg1Value, arg2Value_, arg3Value, ilib__, bufferLib__);
            }
            if (arg2Value instanceof Pointer.PythonObjectStorage) {
                Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                PythonObjectData s6_ = (PythonObjectData)this.insert(new PythonObjectData());
                CApiTransitions.PythonToNativeNode toNativeNode__1 = (CApiTransitions.PythonToNativeNode)s6_.insert(CApiTransitions.PythonToNativeNode.create());
                Objects.requireNonNull(toNativeNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s6_.toNativeNode_ = toNativeNode__1;
                InteropLibrary lib__ = (InteropLibrary)s6_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                Objects.requireNonNull(lib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s6_.lib_ = lib__;
                VarHandle.storeStoreFence();
                this.pythonObject_cache = s6_;
                this.state_0_ = state_0 |= 0x40;
                return PointerNodes.AbstractGetPointerValueNode.doPythonObject(this, arg1Value, arg2Value_, arg3Value, toNativeNode__1, lib__);
            }
            if (arg2Value instanceof Pointer.ObjectPointerStorage) {
                Pointer.ObjectPointerStorage arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                this.state_0_ = state_0 |= 0x80;
                return PointerNodes.GetPointerValueAsLongNode.doObjectPointer(this, arg1Value, arg2Value_, arg3Value);
            }
            throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLLI(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }

        @NeverDefault
        public static PointerNodes.GetPointerValueAsLongNode create() {
            return new GetPointerValueAsLongNodeGen();
        }

        @NeverDefault
        public static PointerNodes.GetPointerValueAsLongNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.GetPointerValueAsLongNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=8, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsLongNode.class)
        @DenyReplace
        private static final class MemoryViewData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropLibrary ilib_;
            @Node.Child
            PythonBufferAccessLibrary bufferLib_;

            MemoryViewData() {
            }
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsLongNode.class)
        @DenyReplace
        private static final class PythonObjectData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            CApiTransitions.PythonToNativeNode toNativeNode_;
            @Node.Child
            InteropLibrary lib_;

            PythonObjectData() {
            }
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsLongNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.GetPointerValueAsLongNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected long execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.NullStorage) {
                    Pointer.NullStorage arg2Value_ = (Pointer.NullStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doBytes(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doZero(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doPointerArray(arg0Value, arg1Value, arg2Value_, arg3Value, GetPointerValueAsLongNodeGen.getUncached());
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doMemoryView(arg0Value, arg1Value, arg2Value_, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                }
                if (arg2Value instanceof Pointer.PythonObjectStorage) {
                    Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doPythonObject(arg0Value, arg1Value, arg2Value_, arg3Value, CApiTransitions.PythonToNativeNode.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
                }
                if (arg2Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                    return PointerNodes.GetPointerValueAsLongNode.doObjectPointer(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                throw GetPointerValueAsLongNodeGen.newUnsupportedSpecializationException4LLLI(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsLongNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.GetPointerValueAsLongNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<PointerNodes.GetPointerValueAsLongNode> pointerArray_toNativeNode_;
            private final InlineSupport.ReferenceField<MemoryViewData> memoryView_cache;
            private final InlineSupport.ReferenceField<PythonObjectData> pythonObject_cache;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.GetPointerValueAsLongNode.class));
                this.state_0_ = target.getState(0, 8);
                this.pointerArray_toNativeNode_ = target.getReference(1, PointerNodes.GetPointerValueAsLongNode.class);
                this.memoryView_cache = target.getReference(2, MemoryViewData.class);
                this.pythonObject_cache = target.getReference(3, PythonObjectData.class);
            }

            @Override
            protected long execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    Pointer.Storage arg2Value_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.NullStorage) {
                        Pointer.NullStorage arg2Value_2 = (Pointer.NullStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_2, arg3Value);
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_3 = (Pointer.LongPointerStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_3, arg3Value);
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_4 = (Pointer.ByteArrayStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doBytes(arg0Value, arg1Value, arg2Value_4, arg3Value);
                    }
                    if ((state_0 & 8) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_5 = (Pointer.ZeroStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doZero(arg0Value, arg1Value, arg2Value_5, arg3Value);
                    }
                    if ((state_0 & 0x10) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                        arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        PointerNodes.GetPointerValueAsLongNode toNativeNode__ = (PointerNodes.GetPointerValueAsLongNode)((Object)this.pointerArray_toNativeNode_.get(arg0Value));
                        if (toNativeNode__ != null) {
                            return PointerNodes.AbstractGetPointerValueNode.doPointerArray(arg0Value, arg1Value, arg2Value_, arg3Value, toNativeNode__);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && arg2Value instanceof Pointer.MemoryViewStorage) {
                        arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                        MemoryViewData s5_ = (MemoryViewData)((Object)this.memoryView_cache.get(arg0Value));
                        if (s5_ != null) {
                            return PointerNodes.AbstractGetPointerValueNode.doMemoryView(arg0Value, arg1Value, (Pointer.MemoryViewStorage)arg2Value_, arg3Value, s5_.ilib_, s5_.bufferLib_);
                        }
                    }
                    if ((state_0 & 0x40) != 0 && arg2Value instanceof Pointer.PythonObjectStorage) {
                        arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                        PythonObjectData s6_ = (PythonObjectData)((Object)this.pythonObject_cache.get(arg0Value));
                        if (s6_ != null) {
                            return PointerNodes.AbstractGetPointerValueNode.doPythonObject(arg0Value, arg1Value, (Pointer.PythonObjectStorage)arg2Value_, arg3Value, s6_.toNativeNode_, s6_.lib_);
                        }
                    }
                    if ((state_0 & 0x80) != 0 && arg2Value instanceof Pointer.ObjectPointerStorage) {
                        arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                        return PointerNodes.GetPointerValueAsLongNode.doObjectPointer(arg0Value, arg1Value, (Pointer.ObjectPointerStorage)arg2Value_, arg3Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private long executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.NullStorage) {
                    Pointer.NullStorage arg2Value_ = (Pointer.NullStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return PointerNodes.AbstractGetPointerValueNode.doBytes(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return PointerNodes.AbstractGetPointerValueNode.doZero(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    PointerNodes.GetPointerValueAsLongNode toNativeNode__ = (PointerNodes.GetPointerValueAsLongNode)arg0Value.insert((Node)GetPointerValueAsLongNodeGen.create());
                    Objects.requireNonNull(toNativeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.pointerArray_toNativeNode_.set(arg0Value, (Object)toNativeNode__);
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return PointerNodes.AbstractGetPointerValueNode.doPointerArray(arg0Value, arg1Value, arg2Value_, arg3Value, toNativeNode__);
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    MemoryViewData s5_ = (MemoryViewData)arg0Value.insert((Node)new MemoryViewData());
                    InteropLibrary ilib__ = (InteropLibrary)s5_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(ilib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s5_.ilib_ = ilib__;
                    PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)s5_.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s5_.bufferLib_ = bufferLib__;
                    VarHandle.storeStoreFence();
                    this.memoryView_cache.set(arg0Value, (Object)s5_);
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return PointerNodes.AbstractGetPointerValueNode.doMemoryView(arg0Value, arg1Value, arg2Value_, arg3Value, ilib__, bufferLib__);
                }
                if (arg2Value instanceof Pointer.PythonObjectStorage) {
                    Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                    PythonObjectData s6_ = (PythonObjectData)arg0Value.insert((Node)new PythonObjectData());
                    CApiTransitions.PythonToNativeNode toNativeNode__1 = (CApiTransitions.PythonToNativeNode)s6_.insert(CApiTransitions.PythonToNativeNode.create());
                    Objects.requireNonNull(toNativeNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s6_.toNativeNode_ = toNativeNode__1;
                    InteropLibrary lib__ = (InteropLibrary)s6_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(lib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s6_.lib_ = lib__;
                    VarHandle.storeStoreFence();
                    this.pythonObject_cache.set(arg0Value, (Object)s6_);
                    this.state_0_.set(arg0Value, state_0 |= 0x40);
                    return PointerNodes.AbstractGetPointerValueNode.doPythonObject(arg0Value, arg1Value, arg2Value_, arg3Value, toNativeNode__1, lib__);
                }
                if (arg2Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 0x80);
                    return PointerNodes.GetPointerValueAsLongNode.doObjectPointer(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                throw GetPointerValueAsLongNodeGen.newUnsupportedSpecializationException4LLLI(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.GetPointerValueAsObjectNode.class)
    public static final class GetPointerValueAsObjectNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLLI(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value});
        }

        @NeverDefault
        public static PointerNodes.GetPointerValueAsObjectNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.GetPointerValueAsObjectNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=8, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsObjectNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.GetPointerValueAsObjectNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected Object execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.NullStorage) {
                    Pointer.NullStorage arg2Value_ = (Pointer.NullStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doBytes(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doZero(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doPointerArray(arg0Value, arg1Value, arg2Value_, arg3Value, GetPointerValueAsLongNodeGen.getUncached());
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doMemoryView(arg0Value, arg1Value, arg2Value_, arg3Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(), (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached());
                }
                if (arg2Value instanceof Pointer.PythonObjectStorage) {
                    Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                    return PointerNodes.AbstractGetPointerValueNode.doPythonObject(arg0Value, arg1Value, arg2Value_, arg3Value, CApiTransitions.PythonToNativeNode.getUncached(), (InteropLibrary)INTEROP_LIBRARY_.getUncached());
                }
                if (arg2Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                    return PointerNodes.GetPointerValueAsObjectNode.doObjectPointer(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                throw GetPointerValueAsObjectNodeGen.newUnsupportedSpecializationException4LLLI(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsObjectNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.GetPointerValueAsObjectNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<PointerNodes.GetPointerValueAsLongNode> pointerArray_toNativeNode_;
            private final InlineSupport.ReferenceField<MemoryViewData> memoryView_cache;
            private final InlineSupport.ReferenceField<PythonObjectData> pythonObject_cache;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.GetPointerValueAsObjectNode.class));
                this.state_0_ = target.getState(0, 8);
                this.pointerArray_toNativeNode_ = target.getReference(1, PointerNodes.GetPointerValueAsLongNode.class);
                this.memoryView_cache = target.getReference(2, MemoryViewData.class);
                this.pythonObject_cache = target.getReference(3, PythonObjectData.class);
            }

            @Override
            protected Object execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    Pointer.Storage arg2Value_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.NullStorage) {
                        Pointer.NullStorage arg2Value_2 = (Pointer.NullStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_2, arg3Value);
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_3 = (Pointer.LongPointerStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_3, arg3Value);
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_4 = (Pointer.ByteArrayStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doBytes(arg0Value, arg1Value, arg2Value_4, arg3Value);
                    }
                    if ((state_0 & 8) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_5 = (Pointer.ZeroStorage)arg2Value;
                        return PointerNodes.AbstractGetPointerValueNode.doZero(arg0Value, arg1Value, arg2Value_5, arg3Value);
                    }
                    if ((state_0 & 0x10) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                        arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        PointerNodes.GetPointerValueAsLongNode toNativeNode__ = (PointerNodes.GetPointerValueAsLongNode)((Object)this.pointerArray_toNativeNode_.get(arg0Value));
                        if (toNativeNode__ != null) {
                            return PointerNodes.AbstractGetPointerValueNode.doPointerArray(arg0Value, arg1Value, arg2Value_, arg3Value, toNativeNode__);
                        }
                    }
                    if ((state_0 & 0x20) != 0 && arg2Value instanceof Pointer.MemoryViewStorage) {
                        arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                        MemoryViewData s5_ = (MemoryViewData)((Object)this.memoryView_cache.get(arg0Value));
                        if (s5_ != null) {
                            return PointerNodes.AbstractGetPointerValueNode.doMemoryView(arg0Value, arg1Value, (Pointer.MemoryViewStorage)arg2Value_, arg3Value, s5_.ilib_, s5_.bufferLib_);
                        }
                    }
                    if ((state_0 & 0x40) != 0 && arg2Value instanceof Pointer.PythonObjectStorage) {
                        arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                        PythonObjectData s6_ = (PythonObjectData)((Object)this.pythonObject_cache.get(arg0Value));
                        if (s6_ != null) {
                            return PointerNodes.AbstractGetPointerValueNode.doPythonObject(arg0Value, arg1Value, (Pointer.PythonObjectStorage)arg2Value_, arg3Value, s6_.toNativeNode_, s6_.lib_);
                        }
                    }
                    if ((state_0 & 0x80) != 0 && arg2Value instanceof Pointer.ObjectPointerStorage) {
                        arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                        return PointerNodes.GetPointerValueAsObjectNode.doObjectPointer(arg0Value, arg1Value, (Pointer.ObjectPointerStorage)arg2Value_, arg3Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private Object executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.NullStorage) {
                    Pointer.NullStorage arg2Value_ = (Pointer.NullStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.AbstractGetPointerValueNode.doNull(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PointerNodes.AbstractGetPointerValueNode.doNativePointer(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return PointerNodes.AbstractGetPointerValueNode.doBytes(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return PointerNodes.AbstractGetPointerValueNode.doZero(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    PointerNodes.GetPointerValueAsLongNode toNativeNode__ = (PointerNodes.GetPointerValueAsLongNode)arg0Value.insert((Node)GetPointerValueAsLongNodeGen.create());
                    Objects.requireNonNull(toNativeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.pointerArray_toNativeNode_.set(arg0Value, (Object)toNativeNode__);
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return PointerNodes.AbstractGetPointerValueNode.doPointerArray(arg0Value, arg1Value, arg2Value_, arg3Value, toNativeNode__);
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    MemoryViewData s5_ = (MemoryViewData)arg0Value.insert((Node)new MemoryViewData());
                    InteropLibrary ilib__ = (InteropLibrary)s5_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(ilib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s5_.ilib_ = ilib__;
                    PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)s5_.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s5_.bufferLib_ = bufferLib__;
                    VarHandle.storeStoreFence();
                    this.memoryView_cache.set(arg0Value, (Object)s5_);
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return PointerNodes.AbstractGetPointerValueNode.doMemoryView(arg0Value, arg1Value, arg2Value_, arg3Value, ilib__, bufferLib__);
                }
                if (arg2Value instanceof Pointer.PythonObjectStorage) {
                    Pointer.PythonObjectStorage arg2Value_ = (Pointer.PythonObjectStorage)arg2Value;
                    PythonObjectData s6_ = (PythonObjectData)arg0Value.insert((Node)new PythonObjectData());
                    CApiTransitions.PythonToNativeNode toNativeNode__1 = (CApiTransitions.PythonToNativeNode)s6_.insert(CApiTransitions.PythonToNativeNode.create());
                    Objects.requireNonNull(toNativeNode__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s6_.toNativeNode_ = toNativeNode__1;
                    InteropLibrary lib__ = (InteropLibrary)s6_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(lib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s6_.lib_ = lib__;
                    VarHandle.storeStoreFence();
                    this.pythonObject_cache.set(arg0Value, (Object)s6_);
                    this.state_0_.set(arg0Value, state_0 |= 0x40);
                    return PointerNodes.AbstractGetPointerValueNode.doPythonObject(arg0Value, arg1Value, arg2Value_, arg3Value, toNativeNode__1, lib__);
                }
                if (arg2Value instanceof Pointer.ObjectPointerStorage) {
                    Pointer.ObjectPointerStorage arg2Value_ = (Pointer.ObjectPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 0x80);
                    return PointerNodes.GetPointerValueAsObjectNode.doObjectPointer(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                throw GetPointerValueAsObjectNodeGen.newUnsupportedSpecializationException4LLLI(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsObjectNode.class)
        @DenyReplace
        private static final class PythonObjectData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            CApiTransitions.PythonToNativeNode toNativeNode_;
            @Node.Child
            InteropLibrary lib_;

            PythonObjectData() {
            }
        }

        @GeneratedBy(value=PointerNodes.GetPointerValueAsObjectNode.class)
        @DenyReplace
        private static final class MemoryViewData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            InteropLibrary ilib_;
            @Node.Child
            PythonBufferAccessLibrary bufferLib_;

            MemoryViewData() {
            }
        }
    }

    @GeneratedBy(value=PointerNodes.WCsLenNode.class)
    public static final class WCsLenNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.WCsLenNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.WCsLenNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.WCsLenNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.WCsLenNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected int execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                return PointerNodes.WCsLenNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, ReadByteNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.WCsLenNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.WCsLenNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Node> readByteNode__field1_;
            private final InlineSupport.ReferenceField<Node> readByteNode__field2_;
            private final PointerNodes.ReadByteNode readByteNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.WCsLenNode.class));
                this.state_0_ = target.getState(0, 6);
                this.readByteNode__field1_ = target.getReference(1, Node.class);
                this.readByteNode__field2_ = target.getReference(2, Node.class);
                this.readByteNode_ = ReadByteNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadByteNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 6), this.readByteNode__field1_, this.readByteNode__field2_}));
            }

            @Override
            protected int execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.readByteNode__field1_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.readByteNode__field2_}));
                return PointerNodes.WCsLenNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.readByteNode_);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.StrLenNode.class)
    public static final class StrLenNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.StrLenNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.StrLenNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.StrLenNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.StrLenNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected int execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                return PointerNodes.StrLenNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, ReadByteNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.StrLenNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.StrLenNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<Node> readByteNode__field1_;
            private final InlineSupport.ReferenceField<Node> readByteNode__field2_;
            private final PointerNodes.ReadByteNode readByteNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.StrLenNode.class));
                this.state_0_ = target.getState(0, 6);
                this.readByteNode__field1_ = target.getReference(1, Node.class);
                this.readByteNode__field2_ = target.getReference(2, Node.class);
                this.readByteNode_ = ReadByteNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadByteNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(0, 6), this.readByteNode__field1_, this.readByteNode__field2_}));
            }

            @Override
            protected int execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, this.readByteNode__field1_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.readByteNode__field2_}));
                return PointerNodes.StrLenNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.readByteNode_);
            }
        }
    }

    @GeneratedBy(value=PointerNodes.MemcpyNode.class)
    public static final class MemcpyNodeGen {
        private static final InlineSupport.StateField FALLBACK_MEMCPY_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.MemcpyNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.MemcpyNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.MemcpyNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.MemcpyNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer.MemoryBlock arg4Value, Pointer.Storage arg5Value, int arg6Value, int arg7Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    if (arg5Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg5Value_ = (Pointer.ByteArrayStorage)arg5Value;
                        PointerNodes.MemcpyNode.doBytesBytes(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                        return;
                    }
                }
                if (arg5Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.Storage arg2Value_;
                    Pointer.PointerArrayStorage arg5Value_ = (Pointer.PointerArrayStorage)arg5Value;
                    if (arg2Value instanceof Pointer.PointerArrayStorage) {
                        arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        if (PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                            PointerNodes.MemcpyNode.doPointerPointer(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                            return;
                        }
                    }
                    if (arg2Value instanceof Pointer.ZeroStorage) {
                        arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        if (PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                            PointerNodes.MemcpyNode.doZeroPointer(arg1Value, (Pointer.ZeroStorage)arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                            return;
                        }
                    }
                }
                PointerNodes.MemcpyNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, ReadBytesNodeGen.getUncached(), WriteBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.MemcpyNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.MemcpyNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.ReadBytesNode fallback_readBytesNode_;
            private final PointerNodes.WriteBytesNode fallback_writeBytesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.MemcpyNode.class));
                this.state_0_ = target.getState(0, 4);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_readBytesNode_ = ReadBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_MEMCPY_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_readBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_readBytesNode__field2_", Node.class)}));
                this.fallback_writeBytesNode_ = WriteBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.WriteBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_MEMCPY_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(7, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer.MemoryBlock arg4Value, Pointer.Storage arg5Value, int arg6Value, int arg7Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage && arg5Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if (arg5Value instanceof Pointer.PointerArrayStorage) {
                    if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.PointerArrayStorage && PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                        return false;
                    }
                    if ((state_0 & 4) == 0 && arg2Value instanceof Pointer.ZeroStorage && PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer.MemoryBlock arg4Value, Pointer.Storage arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s3_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                        if (arg5Value instanceof Pointer.ByteArrayStorage) {
                            Pointer.ByteArrayStorage arg5Value_ = (Pointer.ByteArrayStorage)arg5Value;
                            PointerNodes.MemcpyNode.doBytesBytes(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                            return;
                        }
                    }
                    if ((state_0 & 6) != 0 && arg5Value instanceof Pointer.PointerArrayStorage) {
                        Pointer.Storage arg2Value_;
                        Pointer.PointerArrayStorage arg5Value_ = (Pointer.PointerArrayStorage)arg5Value;
                        if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                            arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                            if (PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                                PointerNodes.MemcpyNode.doPointerPointer(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                                return;
                            }
                        }
                        if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                            arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                            if (PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                                PointerNodes.MemcpyNode.doZeroPointer(arg1Value, (Pointer.ZeroStorage)arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                                return;
                            }
                        }
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value)) {
                        PointerNodes.MemcpyNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_readBytesNode_, this.fallback_writeBytesNode_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private void executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, Pointer.MemoryBlock arg4Value, Pointer.Storage arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    if (arg5Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg5Value_ = (Pointer.ByteArrayStorage)arg5Value;
                        this.state_0_.set(arg0Value, state_0 |= 1);
                        PointerNodes.MemcpyNode.doBytesBytes(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                        return;
                    }
                }
                if (arg5Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.Storage arg2Value_;
                    Pointer.PointerArrayStorage arg5Value_ = (Pointer.PointerArrayStorage)arg5Value;
                    if (arg2Value instanceof Pointer.PointerArrayStorage) {
                        arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        if (PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                            this.state_0_.set(arg0Value, state_0 |= 2);
                            PointerNodes.MemcpyNode.doPointerPointer(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                            return;
                        }
                    }
                    if (arg2Value instanceof Pointer.ZeroStorage) {
                        arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        if (PointerNodes.isMultipleOf8(arg7Value) && PointerNodes.isMultipleOf8(arg3Value) && PointerNodes.isMultipleOf8(arg6Value)) {
                            this.state_0_.set(arg0Value, state_0 |= 4);
                            PointerNodes.MemcpyNode.doZeroPointer(arg1Value, (Pointer.ZeroStorage)arg2Value_, arg3Value, arg4Value, arg5Value_, arg6Value, arg7Value);
                            return;
                        }
                    }
                }
                FallbackData s3_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s3_);
                this.state_0_.set(arg0Value, state_0 |= 8);
                PointerNodes.MemcpyNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_readBytesNode_, this.fallback_writeBytesNode_);
            }
        }

        @GeneratedBy(value=PointerNodes.MemcpyNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_readBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_readBytesNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.WriteLongNode.class)
    public static final class WriteLongNodeGen {
        private static final InlineSupport.StateField FALLBACK_WRITE_LONG_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.WriteLongNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.WriteLongNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.WriteLongNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.WriteLongNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, long arg4Value) {
                Pointer.Storage arg2Value_;
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_2 = (Pointer.ByteArrayStorage)arg2Value;
                    PointerNodes.WriteLongNode.doBytes(arg1Value, arg2Value_2, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_3 = (Pointer.ZeroStorage)arg2Value;
                    PointerNodes.WriteLongNode.doZero(arg1Value, arg2Value_3, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    if (arg4Value == 0L && PointerNodes.isMultipleOf8(arg3Value)) {
                        PointerNodes.WriteLongNode.doPointerArray(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    PointerNodes.WriteLongNode.doNativeMemory(arg0Value, arg1Value, (Pointer.LongPointerStorage)arg2Value_, arg3Value, arg4Value);
                    return;
                }
                PointerNodes.WriteLongNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, WriteBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.WriteLongNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.WriteLongNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.WriteBytesNode fallback_writeBytesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.WriteLongNode.class));
                this.state_0_ = target.getState(0, 5);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_writeBytesNode_ = WriteBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.WriteBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_WRITE_LONG_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, long arg4Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                if ((state_0 & 4) == 0 && arg2Value instanceof Pointer.PointerArrayStorage && arg4Value == 0L && PointerNodes.isMultipleOf8(arg3Value)) {
                    return false;
                }
                return (state_0 & 8) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, long arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s4_;
                    Pointer.Storage arg2Value_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_2 = (Pointer.ByteArrayStorage)arg2Value;
                        PointerNodes.WriteLongNode.doBytes(arg1Value, arg2Value_2, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_3 = (Pointer.ZeroStorage)arg2Value;
                        PointerNodes.WriteLongNode.doZero(arg1Value, arg2Value_3, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                        arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        if (arg4Value == 0L && PointerNodes.isMultipleOf8(arg3Value)) {
                            PointerNodes.WriteLongNode.doPointerArray(arg1Value, arg2Value_, arg3Value, arg4Value);
                            return;
                        }
                    }
                    if ((state_0 & 8) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        PointerNodes.WriteLongNode.doNativeMemory(arg0Value, arg1Value, (Pointer.LongPointerStorage)arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 0x10) != 0 && (s4_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value)) {
                        PointerNodes.WriteLongNode.doOther(s4_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, long arg4Value) {
                Pointer.Storage arg2Value_;
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_2 = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    PointerNodes.WriteLongNode.doBytes(arg1Value, arg2Value_2, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_3 = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    PointerNodes.WriteLongNode.doZero(arg1Value, arg2Value_3, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    if (arg4Value == 0L && PointerNodes.isMultipleOf8(arg3Value)) {
                        this.state_0_.set(arg0Value, state_0 |= 4);
                        PointerNodes.WriteLongNode.doPointerArray(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    PointerNodes.WriteLongNode.doNativeMemory(arg0Value, arg1Value, (Pointer.LongPointerStorage)arg2Value_, arg3Value, arg4Value);
                    return;
                }
                FallbackData s4_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s4_);
                this.state_0_.set(arg0Value, state_0 |= 0x10);
                PointerNodes.WriteLongNode.doOther(s4_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
            }
        }

        @GeneratedBy(value=PointerNodes.WriteLongNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.WriteIntNode.class)
    public static final class WriteIntNodeGen {
        private static final InlineSupport.StateField FALLBACK_WRITE_INT_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.WriteIntNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.WriteIntNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.WriteIntNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.WriteIntNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    PointerNodes.WriteIntNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    PointerNodes.WriteIntNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    PointerNodes.WriteIntNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                PointerNodes.WriteIntNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, WriteBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.WriteIntNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.WriteIntNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.WriteBytesNode fallback_writeBytesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.WriteIntNode.class));
                this.state_0_ = target.getState(0, 4);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_writeBytesNode_ = WriteBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.WriteBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_WRITE_INT_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                return (state_0 & 4) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s3_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                        PointerNodes.WriteIntNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        PointerNodes.WriteIntNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        PointerNodes.WriteIntNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value)) {
                        PointerNodes.WriteIntNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, int arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    PointerNodes.WriteIntNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    PointerNodes.WriteIntNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    PointerNodes.WriteIntNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                FallbackData s3_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s3_);
                this.state_0_.set(arg0Value, state_0 |= 8);
                PointerNodes.WriteIntNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
            }
        }

        @GeneratedBy(value=PointerNodes.WriteIntNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.WriteShortNode.class)
    public static final class WriteShortNodeGen {
        private static final InlineSupport.StateField FALLBACK_WRITE_SHORT_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.WriteShortNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.WriteShortNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.WriteShortNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.WriteShortNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, short arg4Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    PointerNodes.WriteShortNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    PointerNodes.WriteShortNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    PointerNodes.WriteShortNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                PointerNodes.WriteShortNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, WriteBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.WriteShortNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.WriteShortNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.WriteBytesNode fallback_writeBytesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.WriteShortNode.class));
                this.state_0_ = target.getState(0, 4);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_writeBytesNode_ = WriteBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.WriteBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_WRITE_SHORT_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, short arg4Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                return (state_0 & 4) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, short arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s3_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                        PointerNodes.WriteShortNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        PointerNodes.WriteShortNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        PointerNodes.WriteShortNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value)) {
                        PointerNodes.WriteShortNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, short arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    PointerNodes.WriteShortNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    PointerNodes.WriteShortNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    PointerNodes.WriteShortNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                FallbackData s3_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s3_);
                this.state_0_.set(arg0Value, state_0 |= 8);
                PointerNodes.WriteShortNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
            }
        }

        @GeneratedBy(value=PointerNodes.WriteShortNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.WriteByteNode.class)
    public static final class WriteByteNodeGen {
        private static final InlineSupport.StateField FALLBACK_WRITE_BYTE_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.WriteByteNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.WriteByteNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.WriteByteNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.WriteByteNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, byte arg4Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    PointerNodes.WriteByteNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    PointerNodes.WriteByteNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    PointerNodes.WriteByteNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                PointerNodes.WriteByteNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, WriteBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.WriteByteNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.WriteByteNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.WriteBytesNode fallback_writeBytesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.WriteByteNode.class));
                this.state_0_ = target.getState(0, 4);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_writeBytesNode_ = WriteBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.WriteBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_WRITE_BYTE_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 6), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_writeBytesNode__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, byte arg4Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                return (state_0 & 4) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, byte arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s3_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                        PointerNodes.WriteByteNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        PointerNodes.WriteByteNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        PointerNodes.WriteByteNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                        return;
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value)) {
                        PointerNodes.WriteByteNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, byte arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    PointerNodes.WriteByteNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    PointerNodes.WriteByteNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    PointerNodes.WriteByteNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value);
                    return;
                }
                FallbackData s3_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s3_);
                this.state_0_.set(arg0Value, state_0 |= 8);
                PointerNodes.WriteByteNode.doOther(s3_, arg1Value, arg2Value, arg3Value, arg4Value, this.fallback_writeBytesNode_);
            }
        }

        @GeneratedBy(value=PointerNodes.WriteByteNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_writeBytesNode__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.WriteBytesNode.class)
    public static final class WriteBytesNodeGen {
        private static final InlineSupport.StateField POINTER_ARRAY_WRITE_BYTES_NODE_POINTER_ARRAY_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLILII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value});
        }

        @NeverDefault
        public static PointerNodes.WriteBytesNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.WriteBytesNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.WriteBytesNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.WriteBytesNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, byte[] arg4Value, int arg5Value, int arg6Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    PointerNodes.WriteBytesNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    PointerNodes.WriteBytesNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    PointerNodes.WriteBytesNode.doMemoryView(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg2Value_.memoryView));
                    return;
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    PointerNodes.WriteBytesNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    PointerNodes.WriteBytesNode.doPointerArray(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, PointerArrayToBytesNodeGen.getUncached());
                    return;
                }
                throw WriteBytesNodeGen.newUnsupportedSpecializationException7LLLILII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }

        @GeneratedBy(value=PointerNodes.WriteBytesNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.WriteBytesNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<MemoryView0Data> memoryView0_cache;
            private final InlineSupport.ReferenceField<PointerArrayData> pointerArray_cache;
            private final PointerNodes.PointerArrayToBytesNode pointerArray_toBytesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.WriteBytesNode.class));
                this.state_0_ = target.getState(0, 6);
                this.memoryView0_cache = target.getReference(1, MemoryView0Data.class);
                this.pointerArray_cache = target.getReference(2, PointerArrayData.class);
                this.pointerArray_toBytesNode_ = PointerArrayToBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.PointerArrayToBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{POINTER_ARRAY_WRITE_BYTES_NODE_POINTER_ARRAY_STATE_0_UPDATER.subUpdater(0, 8), InlineSupport.ReferenceField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_toBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_toBytesNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_toBytesNode__field3_", Node.class)}));
            }

            @Override
            protected void execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, byte[] arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    Pointer.Storage arg2Value_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_2 = (Pointer.ByteArrayStorage)arg2Value;
                        PointerNodes.WriteBytesNode.doBytes(arg1Value, arg2Value_2, arg3Value, arg4Value, arg5Value, arg6Value);
                        return;
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_3 = (Pointer.ZeroStorage)arg2Value;
                        PointerNodes.WriteBytesNode.doZero(arg1Value, arg2Value_3, arg3Value, arg4Value, arg5Value, arg6Value);
                        return;
                    }
                    if ((state_0 & 0xC) != 0 && arg2Value instanceof Pointer.MemoryViewStorage) {
                        MemoryView0Data s2_;
                        arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                        if ((state_0 & 4) != 0 && (s2_ = (MemoryView0Data)((Object)this.memoryView0_cache.get(arg0Value))) != null && s2_.bufferLib_.accepts(arg2Value_.memoryView)) {
                            PointerNodes.WriteBytesNode.doMemoryView(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, s2_.bufferLib_);
                            return;
                        }
                        if ((state_0 & 8) != 0) {
                            this.memoryView1Boundary(state_0, arg0Value, arg1Value, (Pointer.MemoryViewStorage)arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x10) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        PointerNodes.WriteBytesNode.doNativeMemory(arg0Value, arg1Value, (Pointer.LongPointerStorage)arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                        return;
                    }
                    if ((state_0 & 0x20) != 0 && arg2Value instanceof Pointer.PointerArrayStorage) {
                        arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                        PointerArrayData s5_ = (PointerArrayData)((Object)this.pointerArray_cache.get(arg0Value));
                        if (s5_ != null) {
                            PointerNodes.WriteBytesNode.doPointerArray(s5_, arg1Value, (Pointer.PointerArrayStorage)arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, this.pointerArray_toBytesNode_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private void memoryView1Boundary(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.MemoryViewStorage arg2Value_, int arg3Value, byte[] arg4Value, int arg5Value, int arg6Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(arg0Value);
                try {
                    PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg2Value_.memoryView);
                    PointerNodes.WriteBytesNode.doMemoryView(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, bufferLib__);
                    return;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value, byte[] arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    PointerNodes.WriteBytesNode.doBytes(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    PointerNodes.WriteBytesNode.doZero(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    if ((state_0 & 8) == 0) {
                        MemoryView0Data s2_;
                        block12: {
                            MemoryView0Data s2_original;
                            do {
                                int count2_ = 0;
                                s2_original = s2_ = (MemoryView0Data)((Object)this.memoryView0_cache.getVolatile(arg0Value));
                                if (s2_ != null && !s2_.bufferLib_.accepts(arg2Value_.memoryView)) {
                                    ++count2_;
                                    s2_ = null;
                                }
                                if (s2_ != null || count2_ >= true) break block12;
                                s2_ = (MemoryView0Data)arg0Value.insert((Node)new MemoryView0Data());
                                PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)s2_.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.create((Object)arg2Value_.memoryView)));
                                Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.bufferLib_ = bufferLib__;
                            } while (!this.memoryView0_cache.compareAndSet(arg0Value, (Object)s2_original, (Object)s2_));
                            this.state_0_.set(arg0Value, state_0 |= 4);
                        }
                        if (s2_ != null) {
                            PointerNodes.WriteBytesNode.doMemoryView(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, s2_.bufferLib_);
                            return;
                        }
                    }
                    PythonBufferAccessLibrary bufferLib__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(arg0Value);
                    try {
                        bufferLib__ = (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg2Value_.memoryView);
                        this.memoryView0_cache.set(arg0Value, null);
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_.set(arg0Value, state_0 |= 8);
                        PointerNodes.WriteBytesNode.doMemoryView(arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, bufferLib__);
                        return;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    PointerNodes.WriteBytesNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value);
                    return;
                }
                if (arg2Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg2Value_ = (Pointer.PointerArrayStorage)arg2Value;
                    PointerArrayData s5_ = (PointerArrayData)arg0Value.insert((Node)new PointerArrayData());
                    VarHandle.storeStoreFence();
                    this.pointerArray_cache.set(arg0Value, (Object)s5_);
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    PointerNodes.WriteBytesNode.doPointerArray(s5_, arg1Value, arg2Value_, arg3Value, arg4Value, arg5Value, arg6Value, this.pointerArray_toBytesNode_);
                    return;
                }
                throw WriteBytesNodeGen.newUnsupportedSpecializationException7LLLILII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }

        @GeneratedBy(value=PointerNodes.WriteBytesNode.class)
        @DenyReplace
        private static final class PointerArrayData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int pointerArray_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pointerArray_toBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pointerArray_toBytesNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pointerArray_toBytesNode__field3_;

            PointerArrayData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=PointerNodes.WriteBytesNode.class)
        @DenyReplace
        private static final class MemoryView0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            PythonBufferAccessLibrary bufferLib_;

            MemoryView0Data() {
            }
        }
    }

    @GeneratedBy(value=PointerNodes.ReadLongNode.class)
    public static final class ReadLongNodeGen {
        private static final InlineSupport.StateField FALLBACK_READ_LONG_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.ReadLongNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.ReadLongNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.ReadLongNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.ReadLongNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected long execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    return PointerNodes.ReadLongNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    return PointerNodes.ReadLongNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    return PointerNodes.ReadLongNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                return PointerNodes.ReadLongNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, ReadBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.ReadLongNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.ReadLongNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.ReadBytesNode fallback_read_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.ReadLongNode.class));
                this.state_0_ = target.getState(0, 4);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_read_ = ReadBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_READ_LONG_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                return (state_0 & 4) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected long execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s3_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                        return PointerNodes.ReadLongNode.doBytes(arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        return PointerNodes.ReadLongNode.doZero(arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        return PointerNodes.ReadLongNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        return PointerNodes.ReadLongNode.doOther(s3_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private long executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.ReadLongNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PointerNodes.ReadLongNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return PointerNodes.ReadLongNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                FallbackData s3_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s3_);
                this.state_0_.set(arg0Value, state_0 |= 8);
                return PointerNodes.ReadLongNode.doOther(s3_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
            }
        }

        @GeneratedBy(value=PointerNodes.ReadLongNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.ReadIntNode.class)
    public static final class ReadIntNodeGen {
        private static final InlineSupport.StateField FALLBACK_READ_INT_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.ReadIntNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.ReadIntNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.ReadIntNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.ReadIntNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected int execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    return PointerNodes.ReadIntNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    return PointerNodes.ReadIntNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    return PointerNodes.ReadIntNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                return PointerNodes.ReadIntNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, ReadBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.ReadIntNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.ReadIntNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.ReadBytesNode fallback_read_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.ReadIntNode.class));
                this.state_0_ = target.getState(0, 4);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_read_ = ReadBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_READ_INT_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                return (state_0 & 4) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected int execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s3_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                        return PointerNodes.ReadIntNode.doBytes(arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        return PointerNodes.ReadIntNode.doZero(arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        return PointerNodes.ReadIntNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        return PointerNodes.ReadIntNode.doOther(s3_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.ReadIntNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PointerNodes.ReadIntNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return PointerNodes.ReadIntNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                FallbackData s3_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s3_);
                this.state_0_.set(arg0Value, state_0 |= 8);
                return PointerNodes.ReadIntNode.doOther(s3_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
            }
        }

        @GeneratedBy(value=PointerNodes.ReadIntNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.ReadShortNode.class)
    public static final class ReadShortNodeGen {
        private static final InlineSupport.StateField FALLBACK_READ_SHORT_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.ReadShortNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.ReadShortNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.ReadShortNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.ReadShortNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected short execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    return PointerNodes.ReadShortNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    return PointerNodes.ReadShortNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    return PointerNodes.ReadShortNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                return PointerNodes.ReadShortNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, ReadBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.ReadShortNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.ReadShortNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.ReadBytesNode fallback_read_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.ReadShortNode.class));
                this.state_0_ = target.getState(0, 4);
                this.fallback_cache = target.getReference(1, FallbackData.class);
                this.fallback_read_ = ReadBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_READ_SHORT_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                return (state_0 & 4) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected short execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s3_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                        return PointerNodes.ReadShortNode.doBytes(arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                        return PointerNodes.ReadShortNode.doZero(arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 4) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        return PointerNodes.ReadShortNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 8) != 0 && (s3_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        return PointerNodes.ReadShortNode.doOther(s3_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private short executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.ReadShortNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PointerNodes.ReadShortNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return PointerNodes.ReadShortNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                FallbackData s3_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s3_);
                this.state_0_.set(arg0Value, state_0 |= 8);
                return PointerNodes.ReadShortNode.doOther(s3_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
            }
        }

        @GeneratedBy(value=PointerNodes.ReadShortNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=PointerNodes.ReadByteNode.class)
    public static final class ReadByteNodeGen {
        private static final InlineSupport.StateField FALLBACK_READ_BYTE_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @NeverDefault
        public static PointerNodes.ReadByteNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.ReadByteNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.ReadByteNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.ReadByteNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected byte execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    return PointerNodes.ReadByteNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    return PointerNodes.ReadByteNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    return PointerNodes.ReadByteNode.doMemoryView(arg1Value, arg2Value_, arg3Value, (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg2Value_.memoryView));
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    return PointerNodes.ReadByteNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                return PointerNodes.ReadByteNode.doOther(arg0Value, arg1Value, arg2Value, arg3Value, ReadBytesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=PointerNodes.ReadByteNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.ReadByteNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<MemoryView0Data> memoryView0_cache;
            private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
            private final PointerNodes.ReadBytesNode fallback_read_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.ReadByteNode.class));
                this.state_0_ = target.getState(0, 6);
                this.memoryView0_cache = target.getReference(1, MemoryView0Data.class);
                this.fallback_cache = target.getReference(2, FallbackData.class);
                this.fallback_read_ = ReadBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.ReadBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_READ_BYTE_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_read__field2_", Node.class)}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                if ((state_0 & 1) == 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                    return false;
                }
                if ((state_0 & 2) == 0 && arg2Value instanceof Pointer.ZeroStorage) {
                    return false;
                }
                if ((state_0 & 8) == 0 && arg2Value instanceof Pointer.MemoryViewStorage) {
                    return false;
                }
                return (state_0 & 0x10) != 0 || !(arg2Value instanceof Pointer.LongPointerStorage);
            }

            @Override
            protected byte execute(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    FallbackData s5_;
                    Pointer.Storage arg2Value_;
                    if ((state_0 & 1) != 0 && arg2Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg2Value_2 = (Pointer.ByteArrayStorage)arg2Value;
                        return PointerNodes.ReadByteNode.doBytes(arg1Value, arg2Value_2, arg3Value);
                    }
                    if ((state_0 & 2) != 0 && arg2Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg2Value_3 = (Pointer.ZeroStorage)arg2Value;
                        return PointerNodes.ReadByteNode.doZero(arg1Value, arg2Value_3, arg3Value);
                    }
                    if ((state_0 & 0xC) != 0 && arg2Value instanceof Pointer.MemoryViewStorage) {
                        MemoryView0Data s2_;
                        arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                        if ((state_0 & 4) != 0 && (s2_ = (MemoryView0Data)((Object)this.memoryView0_cache.get(arg0Value))) != null && s2_.bufferLib_.accepts(arg2Value_.memoryView)) {
                            return PointerNodes.ReadByteNode.doMemoryView(arg1Value, arg2Value_, arg3Value, s2_.bufferLib_);
                        }
                        if ((state_0 & 8) != 0) {
                            return this.memoryView1Boundary(state_0, arg0Value, arg1Value, (Pointer.MemoryViewStorage)arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 0x10) != 0 && arg2Value instanceof Pointer.LongPointerStorage) {
                        arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                        return PointerNodes.ReadByteNode.doNativeMemory(arg0Value, arg1Value, (Pointer.LongPointerStorage)arg2Value_, arg3Value);
                    }
                    if ((state_0 & 0x20) != 0 && (s5_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        return PointerNodes.ReadByteNode.doOther(s5_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private byte memoryView1Boundary(int state_0, Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.MemoryViewStorage arg2Value_, int arg3Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(arg0Value);
                try {
                    PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg2Value_.memoryView);
                    byte by = PointerNodes.ReadByteNode.doMemoryView(arg1Value, arg2Value_, arg3Value, bufferLib__);
                    return by;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte executeAndSpecialize(Node arg0Value, Pointer.MemoryBlock arg1Value, Pointer.Storage arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg2Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg2Value_ = (Pointer.ByteArrayStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return PointerNodes.ReadByteNode.doBytes(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg2Value_ = (Pointer.ZeroStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return PointerNodes.ReadByteNode.doZero(arg1Value, arg2Value_, arg3Value);
                }
                if (arg2Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg2Value_ = (Pointer.MemoryViewStorage)arg2Value;
                    if ((state_0 & 8) == 0) {
                        MemoryView0Data s2_;
                        block11: {
                            MemoryView0Data s2_original;
                            do {
                                int count2_ = 0;
                                s2_original = s2_ = (MemoryView0Data)((Object)this.memoryView0_cache.getVolatile(arg0Value));
                                if (s2_ != null && !s2_.bufferLib_.accepts(arg2Value_.memoryView)) {
                                    ++count2_;
                                    s2_ = null;
                                }
                                if (s2_ != null || count2_ >= true) break block11;
                                s2_ = (MemoryView0Data)arg0Value.insert((Node)new MemoryView0Data());
                                PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)s2_.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.create((Object)arg2Value_.memoryView)));
                                Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.bufferLib_ = bufferLib__;
                            } while (!this.memoryView0_cache.compareAndSet(arg0Value, (Object)s2_original, (Object)s2_));
                            this.state_0_.set(arg0Value, state_0 |= 4);
                        }
                        if (s2_ != null) {
                            return PointerNodes.ReadByteNode.doMemoryView(arg1Value, arg2Value_, arg3Value, s2_.bufferLib_);
                        }
                    }
                    PythonBufferAccessLibrary bufferLib__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(arg0Value);
                    try {
                        bufferLib__ = (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg2Value_.memoryView);
                        this.memoryView0_cache.set(arg0Value, null);
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_.set(arg0Value, state_0 |= 8);
                        byte by = PointerNodes.ReadByteNode.doMemoryView(arg1Value, arg2Value_, arg3Value, bufferLib__);
                        return by;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                if (arg2Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg2Value_ = (Pointer.LongPointerStorage)arg2Value;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return PointerNodes.ReadByteNode.doNativeMemory(arg0Value, arg1Value, arg2Value_, arg3Value);
                }
                FallbackData s5_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                VarHandle.storeStoreFence();
                this.fallback_cache.set(arg0Value, (Object)s5_);
                this.state_0_.set(arg0Value, state_0 |= 0x20);
                return PointerNodes.ReadByteNode.doOther(s5_, arg1Value, arg2Value, arg3Value, this.fallback_read_);
            }
        }

        @GeneratedBy(value=PointerNodes.ReadByteNode.class)
        @DenyReplace
        private static final class FallbackData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int fallback_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node fallback_read__field2_;

            FallbackData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=PointerNodes.ReadByteNode.class)
        @DenyReplace
        private static final class MemoryView0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            PythonBufferAccessLibrary bufferLib_;

            MemoryView0Data() {
            }
        }
    }

    @GeneratedBy(value=PointerNodes.ReadBytesNode.class)
    public static final class ReadBytesNodeGen {
        private static final InlineSupport.StateField POINTER_ARRAY_READ_BYTES_NODE_POINTER_ARRAY_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLILLII(Node thisNode_, Object arg0Value, Object arg1Value, int arg2Value, Object arg3Value, Object arg4Value, int arg5Value, int arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value});
        }

        @NeverDefault
        public static PointerNodes.ReadBytesNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static PointerNodes.ReadBytesNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=7, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=PointerNodes.ReadBytesNode.class)
        @DenyReplace
        private static final class Uncached
        extends PointerNodes.ReadBytesNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected void execute(Node arg0Value, byte[] arg1Value, int arg2Value, Pointer.MemoryBlock arg3Value, Pointer.Storage arg4Value, int arg5Value, int arg6Value) {
                if (arg4Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg4Value_ = (Pointer.ZeroStorage)arg4Value;
                    PointerNodes.ReadBytesNode.doZero(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                if (arg4Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg4Value_ = (Pointer.ByteArrayStorage)arg4Value;
                    PointerNodes.ReadBytesNode.doBytes(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                if (arg4Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg4Value_ = (Pointer.MemoryViewStorage)arg4Value;
                    PointerNodes.ReadBytesNode.doMemoryView(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value, (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg4Value_.memoryView));
                    return;
                }
                if (arg4Value instanceof Pointer.NullStorage) {
                    Pointer.NullStorage arg4Value_ = (Pointer.NullStorage)arg4Value;
                    PointerNodes.ReadBytesNode.doNull(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                if (arg4Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg4Value_ = (Pointer.PointerArrayStorage)arg4Value;
                    PointerNodes.ReadBytesNode.doPointerArray(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value, PointerArrayToBytesNodeGen.getUncached());
                    return;
                }
                if (arg4Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg4Value_ = (Pointer.LongPointerStorage)arg4Value;
                    PointerNodes.ReadBytesNode.doNativeMemory(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                throw ReadBytesNodeGen.newUnsupportedSpecializationException7LLILLII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }

        @GeneratedBy(value=PointerNodes.ReadBytesNode.class)
        @DenyReplace
        private static final class Inlined
        extends PointerNodes.ReadBytesNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<MemoryView0Data> memoryView0_cache;
            private final InlineSupport.ReferenceField<PointerArrayData> pointerArray_cache;
            private final PointerNodes.PointerArrayToBytesNode pointerArray_toBytesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(PointerNodes.ReadBytesNode.class));
                this.state_0_ = target.getState(0, 7);
                this.memoryView0_cache = target.getReference(1, MemoryView0Data.class);
                this.pointerArray_cache = target.getReference(2, PointerArrayData.class);
                this.pointerArray_toBytesNode_ = PointerArrayToBytesNodeGen.inline(InlineSupport.InlineTarget.create(PointerNodes.PointerArrayToBytesNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{POINTER_ARRAY_READ_BYTES_NODE_POINTER_ARRAY_STATE_0_UPDATER.subUpdater(0, 8), InlineSupport.ReferenceField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_toBytesNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_toBytesNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)PointerArrayData.lookup_(), (String)"pointerArray_toBytesNode__field3_", Node.class)}));
            }

            @Override
            protected void execute(Node arg0Value, byte[] arg1Value, int arg2Value, Pointer.MemoryBlock arg3Value, Pointer.Storage arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    Pointer.Storage arg4Value_;
                    if ((state_0 & 1) != 0 && arg4Value instanceof Pointer.ZeroStorage) {
                        Pointer.ZeroStorage arg4Value_2 = (Pointer.ZeroStorage)arg4Value;
                        PointerNodes.ReadBytesNode.doZero(arg1Value, arg2Value, arg3Value, arg4Value_2, arg5Value, arg6Value);
                        return;
                    }
                    if ((state_0 & 2) != 0 && arg4Value instanceof Pointer.ByteArrayStorage) {
                        Pointer.ByteArrayStorage arg4Value_3 = (Pointer.ByteArrayStorage)arg4Value;
                        PointerNodes.ReadBytesNode.doBytes(arg1Value, arg2Value, arg3Value, arg4Value_3, arg5Value, arg6Value);
                        return;
                    }
                    if ((state_0 & 0xC) != 0 && arg4Value instanceof Pointer.MemoryViewStorage) {
                        MemoryView0Data s2_;
                        arg4Value_ = (Pointer.MemoryViewStorage)arg4Value;
                        if ((state_0 & 4) != 0 && (s2_ = (MemoryView0Data)((Object)this.memoryView0_cache.get(arg0Value))) != null && s2_.bufferLib_.accepts(arg4Value_.memoryView)) {
                            PointerNodes.ReadBytesNode.doMemoryView(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value, s2_.bufferLib_);
                            return;
                        }
                        if ((state_0 & 8) != 0) {
                            this.memoryView1Boundary(state_0, arg0Value, arg1Value, arg2Value, arg3Value, (Pointer.MemoryViewStorage)arg4Value_, arg5Value, arg6Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x10) != 0 && arg4Value instanceof Pointer.NullStorage) {
                        arg4Value_ = (Pointer.NullStorage)arg4Value;
                        PointerNodes.ReadBytesNode.doNull(arg1Value, arg2Value, arg3Value, (Pointer.NullStorage)arg4Value_, arg5Value, arg6Value);
                        return;
                    }
                    if ((state_0 & 0x20) != 0 && arg4Value instanceof Pointer.PointerArrayStorage) {
                        arg4Value_ = (Pointer.PointerArrayStorage)arg4Value;
                        PointerArrayData s5_ = (PointerArrayData)((Object)this.pointerArray_cache.get(arg0Value));
                        if (s5_ != null) {
                            PointerNodes.ReadBytesNode.doPointerArray(s5_, arg1Value, arg2Value, arg3Value, (Pointer.PointerArrayStorage)arg4Value_, arg5Value, arg6Value, this.pointerArray_toBytesNode_);
                            return;
                        }
                    }
                    if ((state_0 & 0x40) != 0 && arg4Value instanceof Pointer.LongPointerStorage) {
                        arg4Value_ = (Pointer.LongPointerStorage)arg4Value;
                        PointerNodes.ReadBytesNode.doNativeMemory(arg0Value, arg1Value, arg2Value, arg3Value, (Pointer.LongPointerStorage)arg4Value_, arg5Value, arg6Value);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private void memoryView1Boundary(int state_0, Node arg0Value, byte[] arg1Value, int arg2Value, Pointer.MemoryBlock arg3Value, Pointer.MemoryViewStorage arg4Value_, int arg5Value, int arg6Value) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(arg0Value);
                try {
                    PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg4Value_.memoryView);
                    PointerNodes.ReadBytesNode.doMemoryView(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value, bufferLib__);
                    return;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void executeAndSpecialize(Node arg0Value, byte[] arg1Value, int arg2Value, Pointer.MemoryBlock arg3Value, Pointer.Storage arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg4Value instanceof Pointer.ZeroStorage) {
                    Pointer.ZeroStorage arg4Value_ = (Pointer.ZeroStorage)arg4Value;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    PointerNodes.ReadBytesNode.doZero(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                if (arg4Value instanceof Pointer.ByteArrayStorage) {
                    Pointer.ByteArrayStorage arg4Value_ = (Pointer.ByteArrayStorage)arg4Value;
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    PointerNodes.ReadBytesNode.doBytes(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                if (arg4Value instanceof Pointer.MemoryViewStorage) {
                    Pointer.MemoryViewStorage arg4Value_ = (Pointer.MemoryViewStorage)arg4Value;
                    if ((state_0 & 8) == 0) {
                        MemoryView0Data s2_;
                        block13: {
                            MemoryView0Data s2_original;
                            do {
                                int count2_ = 0;
                                s2_original = s2_ = (MemoryView0Data)((Object)this.memoryView0_cache.getVolatile(arg0Value));
                                if (s2_ != null && !s2_.bufferLib_.accepts(arg4Value_.memoryView)) {
                                    ++count2_;
                                    s2_ = null;
                                }
                                if (s2_ != null || count2_ >= true) break block13;
                                s2_ = (MemoryView0Data)arg0Value.insert((Node)new MemoryView0Data());
                                PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)s2_.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.create((Object)arg4Value_.memoryView)));
                                Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.bufferLib_ = bufferLib__;
                            } while (!this.memoryView0_cache.compareAndSet(arg0Value, (Object)s2_original, (Object)s2_));
                            this.state_0_.set(arg0Value, state_0 |= 4);
                        }
                        if (s2_ != null) {
                            PointerNodes.ReadBytesNode.doMemoryView(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value, s2_.bufferLib_);
                            return;
                        }
                    }
                    PythonBufferAccessLibrary bufferLib__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(arg0Value);
                    try {
                        bufferLib__ = (PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.getUncached((Object)arg4Value_.memoryView);
                        this.memoryView0_cache.set(arg0Value, null);
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_.set(arg0Value, state_0 |= 8);
                        PointerNodes.ReadBytesNode.doMemoryView(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value, bufferLib__);
                        return;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                if (arg4Value instanceof Pointer.NullStorage) {
                    Pointer.NullStorage arg4Value_ = (Pointer.NullStorage)arg4Value;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    PointerNodes.ReadBytesNode.doNull(arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                if (arg4Value instanceof Pointer.PointerArrayStorage) {
                    Pointer.PointerArrayStorage arg4Value_ = (Pointer.PointerArrayStorage)arg4Value;
                    PointerArrayData s5_ = (PointerArrayData)arg0Value.insert((Node)new PointerArrayData());
                    VarHandle.storeStoreFence();
                    this.pointerArray_cache.set(arg0Value, (Object)s5_);
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    PointerNodes.ReadBytesNode.doPointerArray(s5_, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value, this.pointerArray_toBytesNode_);
                    return;
                }
                if (arg4Value instanceof Pointer.LongPointerStorage) {
                    Pointer.LongPointerStorage arg4Value_ = (Pointer.LongPointerStorage)arg4Value;
                    this.state_0_.set(arg0Value, state_0 |= 0x40);
                    PointerNodes.ReadBytesNode.doNativeMemory(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value_, arg5Value, arg6Value);
                    return;
                }
                throw ReadBytesNodeGen.newUnsupportedSpecializationException7LLILLII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }

        @GeneratedBy(value=PointerNodes.ReadBytesNode.class)
        @DenyReplace
        private static final class PointerArrayData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int pointerArray_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pointerArray_toBytesNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pointerArray_toBytesNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node pointerArray_toBytesNode__field3_;

            PointerArrayData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=PointerNodes.ReadBytesNode.class)
        @DenyReplace
        private static final class MemoryView0Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            PythonBufferAccessLibrary bufferLib_;

            MemoryView0Data() {
            }
        }
    }
}

