/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.map;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.map.MapBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.map.PMap;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMap})
public final class MapBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MapBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonBuiltinNode {
        @Specialization
        static PTuple doit(PMap self, Object ignored, @Cached PythonObjectFactory factory) {
            Object[] iterators = self.getIterators();
            Object[] args = new Object[iterators.length + 1];
            args[0] = self.getFunction();
            System.arraycopy(iterators, 0, args, 1, iterators.length);
            return factory.createTuple(new Object[]{PythonBuiltinClassType.PMap, factory.createTuple(args)});
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PMap iter(PMap self) {
            return self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getIterators().length == 1"})
        Object doOne(VirtualFrame frame, PMap self, @Cached.Shared @Cached CallVarargsMethodNode callNode, @Cached.Shared @Cached GetNextNode next) {
            return callNode.execute((Frame)frame, self.getFunction(), new Object[]{next.execute((Frame)frame, self.getIterators()[0])}, PKeyword.EMPTY_KEYWORDS);
        }

        @Specialization(replaces={"doOne"})
        Object doNext(VirtualFrame frame, PMap self, @Cached.Shared @Cached CallVarargsMethodNode callNode, @Cached.Shared @Cached GetNextNode next) {
            Object[] iterators = self.getIterators();
            Object[] arguments = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                arguments[i] = next.execute((Frame)frame, iterators[i]);
            }
            return callNode.execute((Frame)frame, self.getFunction(), arguments, PKeyword.EMPTY_KEYWORDS);
        }
    }
}

