/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;

public class TpSlotGetAttr {

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class CallManagedSlotGetAttrNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot.TpSlotManaged var3, Object var4, Object var5);

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot.TpSlotManaged var3, Object var4, TruffleString var5);

        @Specialization(guards={"slot == cachedSlot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotGetAttrBuiltin slot, Object self, TruffleString name, @Cached(value="slot") TpSlotGetAttrBuiltin cachedSlot, @Cached(value="cachedSlot.createSlotNode()") GetAttrBuiltinNode slotNode) {
            return slotNode.executeGetAttr(frame, self, name);
        }

        @Specialization(guards={"!slot.hasGetattr()"})
        static Object callPythonSimple(VirtualFrame frame, Node inliningTarget, TpSlotGetAttrPython slot, Object self, Object name, @Cached.Exclusive @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode callPythonFun) {
            return callPythonFun.execute(frame, inliningTarget, slot.getGetattribute(), slot.getType(), self, name);
        }

        @Specialization(guards={"slot.hasGetattr()"})
        static Object callPythonSimple(VirtualFrame frame, Node inliningTarget, TpSlotGetAttrPython slot, Object self, Object name, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached CallBinaryMethodNode callGetAttributeNode, @Cached.Exclusive @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode callPythonFun, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            Object type = slot.getType();
            Object getattr = slot.getGetattr();
            try {
                Object bound = bindDescriptorNode.execute((Frame)frame, inliningTarget, slot.getGetattribute(), self, type);
                return callGetAttributeNode.executeObject((Frame)frame, bound, self, name);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonErrorType.AttributeError, errorProfile);
                if (getattr == null) {
                    throw pe;
                }
                return callPythonFun.execute(frame, inliningTarget, getattr, type, self, name);
            }
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotGetAttrBuiltin slot, Object self, Object name, @Cached(inline=false) ExecutionContext.CallContext callContext, @Cached InlinedConditionProfile isNullFrameProfile, @Cached(inline=false) IndirectCallNode indirectCallNode) {
            Object[] arguments = PArguments.create(2);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, name);
            return BuiltinDispatchers.callGenericBuiltin(frame, inliningTarget, slot.callTargetIndex, arguments, callContext, isNullFrameProfile, indirectCallNode);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class CallNativeSlotGetAttrNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "tp_getattr");

        CallNativeSlotGetAttrNode() {
        }

        abstract Object execute(VirtualFrame var1, TpSlots var2, TpSlot.TpSlotNative var3, Object var4, Object var5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object callNative(VirtualFrame frame, TpSlots slots, TpSlot.TpSlotNative slot, Object self, Object name, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached InlinedConditionProfile isGetAttrProfile, @Cached CExtNodes.AsCharPointerNode asCharPointerNode, @Cached CStructAccess.FreeNode freeNode, @Cached CApiTransitions.PythonToNativeNode nameToNativeNode, @Cached CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            Object result;
            boolean isGetAttr = isGetAttrProfile.profile(inliningTarget, slots.tp_getattr() == slot);
            Object nameArg = isGetAttr ? asCharPointerNode.execute(name) : nameToNativeNode.execute(name);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, null);
            try {
                result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___GETATTR__, slot.callable, selfToNativeNode.execute(self), nameArg);
            }
            finally {
                if (isGetAttr) {
                    freeNode.free(nameArg);
                }
            }
            return checkResultNode.execute(threadState, SpecialMethodNames.T___GETATTR__, toPythonNode.execute(result));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotGetAttrONode
    extends Node {
        public final Object execute(VirtualFrame frame, Node inliningTarget, TpSlots slots, Object self, Object name) {
            assert (slots.combined_tp_getattro_getattr() != null);
            return this.executeImpl(frame, inliningTarget, slots, slots.combined_tp_getattro_getattr(), self, name);
        }

        abstract Object executeImpl(VirtualFrame var1, Node var2, TpSlots var3, TpSlot var4, Object var5, Object var6);

        @Specialization
        static Object callManagedSlot(VirtualFrame frame, Node inliningTarget, TpSlots slots, TpSlot.TpSlotManaged slot, Object self, Object name, @Cached CallManagedSlotGetAttrNode slotNode) {
            return slotNode.execute(frame, inliningTarget, slot, self, name);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object callNative(VirtualFrame frame, TpSlots slots, TpSlot.TpSlotNative slot, Object self, Object name, @Cached(inline=false) CallNativeSlotGetAttrNode callNativeSlot) {
            return callNativeSlot.execute(frame, slots, slot, self, name);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotGetAttrNode
    extends Node {
        public final Object execute(VirtualFrame frame, Node inliningTarget, TpSlots slots, Object self, TruffleString name) {
            assert (slots.combined_tp_getattro_getattr() != null);
            return this.executeImpl(frame, inliningTarget, slots, slots.combined_tp_getattro_getattr(), self, name);
        }

        abstract Object executeImpl(VirtualFrame var1, Node var2, TpSlots var3, TpSlot var4, Object var5, TruffleString var6);

        @Specialization
        static Object callManagedSlot(VirtualFrame frame, Node inliningTarget, TpSlots slots, TpSlot.TpSlotManaged slot, Object self, TruffleString name, @Cached CallManagedSlotGetAttrNode slotNode) {
            return slotNode.execute(frame, inliningTarget, slot, self, name);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object callNative(VirtualFrame frame, TpSlots slots, TpSlot.TpSlotNative slot, Object self, TruffleString name, @Cached(inline=false) CallNativeSlotGetAttrNode callNativeSlot) {
            return callNativeSlot.execute(frame, slots, slot, self, name);
        }
    }

    public static final class TpSlotGetAttrPython
    extends TpSlot.TpSlotPython {
        private final TruffleWeakReference<Object> getattr;
        private final TruffleWeakReference<Object> getattribute;
        private final TruffleWeakReference<Object> type;

        public TpSlotGetAttrPython(Object getattribute, Object getattr, Object type) {
            this.getattr = TpSlotGetAttrPython.asWeakRef(getattr);
            this.getattribute = TpSlotGetAttrPython.asWeakRef(getattribute);
            this.type = new TruffleWeakReference(type);
        }

        public static TpSlotGetAttrPython create(Object[] callables, TruffleString[] callableNames, Object type) {
            assert (callables.length == 2);
            assert (callableNames == null || callableNames[0].equals((Object)SpecialMethodNames.T___GETATTRIBUTE__) && callableNames[1].equals((Object)SpecialMethodNames.T___GETATTR__));
            return new TpSlotGetAttrPython(callables[0], callables[1], type);
        }

        @Override
        public TpSlot.TpSlotPython forNewType(Object klass) {
            Object newGetattribute = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___GETATTRIBUTE__);
            Object newGetattr = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___GETATTR__);
            if (newGetattr != this.getGetattr() || newGetattribute != this.getGetattribute()) {
                return new TpSlotGetAttrPython(newGetattribute, newGetattr, this.getType());
            }
            return this;
        }

        public Object getGetattr() {
            return this.safeGet(this.getattr);
        }

        public boolean hasGetattr() {
            return this.getattr != null;
        }

        public Object getGetattribute() {
            return this.safeGet(this.getattribute);
        }

        public Object getType() {
            return this.safeGet(this.type);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class GetAttrBuiltinNode
    extends PythonBinaryBuiltinNode {
        public abstract Object executeGetAttr(VirtualFrame var1, Object var2, TruffleString var3);
    }

    public static abstract class TpSlotGetAttrBuiltin<T extends GetAttrBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotGetAttrBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, BuiltinSlotWrapperSignature.BINARY, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC);
        }

        final GetAttrBuiltinNode createSlotNode() {
            return (GetAttrBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget target = TpSlotGetAttrBuiltin.createBuiltinCallTarget(language, BuiltinSlotWrapperSignature.BINARY, this.getNodeFactory(), "__getattribute__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, target);
        }
    }
}

