/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.bytecode.UnpackExNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
public abstract class UnpackExNode
extends PNodeWithContext {
    public abstract int execute(Frame var1, int var2, Object var3, int var4, int var5);

    @Specialization(guards={"isBuiltinSequence(sequence)"})
    static int doUnpackSequence(VirtualFrame frame, int initialStackTop, PSequence sequence, int countBefore, int countAfter, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
        int resultStackTop;
        CompilerAsserts.partialEvaluationConstant((int)countBefore);
        CompilerAsserts.partialEvaluationConstant((int)countAfter);
        int stackTop = resultStackTop = initialStackTop + countBefore + 1 + countAfter;
        SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
        int len = storage.length();
        int starLen = len - countBefore - countAfter;
        if (starLen < 0) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, len);
        }
        stackTop = UnpackExNode.moveItemsToStack(frame, inliningTarget, storage, stackTop, 0, countBefore, getItemNode);
        PList starList = factory.createList(getItemSliceNode.execute(storage, countBefore, countBefore + starLen, 1, starLen));
        frame.setObject(stackTop--, (Object)starList);
        UnpackExNode.moveItemsToStack(frame, inliningTarget, storage, stackTop, len - countAfter, countAfter, getItemNode);
        return resultStackTop;
    }

    @Fallback
    static int doUnpackIterable(VirtualFrame frame, int initialStackTop, Object collection, int countBefore, int countAfter, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached ListNodes.ConstructListNode constructListNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemSliceNode getItemSliceNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
        Object iterator;
        int resultStackTop;
        CompilerAsserts.partialEvaluationConstant((int)countBefore);
        CompilerAsserts.partialEvaluationConstant((int)countAfter);
        int stackTop = resultStackTop = initialStackTop + countBefore + 1 + countAfter;
        try {
            iterator = getIter.execute((Frame)frame, inliningTarget, collection);
        }
        catch (PException e) {
            e.expectTypeError(inliningTarget, notIterableProfile);
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
        }
        stackTop = UnpackExNode.moveItemsToStack(frame, inliningTarget, iterator, stackTop, 0, countBefore, countBefore + countAfter, getNextNode, stopIterationProfile, raiseNode);
        PList starAndAfter = constructListNode.execute((Frame)frame, iterator);
        SequenceStorage storage = starAndAfter.getSequenceStorage();
        int lenAfter = storage.length();
        if (lenAfter < countAfter) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, countBefore + countAfter, countBefore + lenAfter);
        }
        if (countAfter == 0) {
            frame.setObject(stackTop, (Object)starAndAfter);
        } else {
            int starLen = lenAfter - countAfter;
            PList starList = factory.createList(getItemSliceNode.execute(storage, 0, starLen, 1, starLen));
            frame.setObject(stackTop--, (Object)starList);
            UnpackExNode.moveItemsToStack(frame, inliningTarget, storage, stackTop, starLen, countAfter, getItemNode);
        }
        return resultStackTop;
    }

    @ExplodeLoop
    private static int moveItemsToStack(VirtualFrame frame, Node inliningTarget, Object iterator, int initialStackTop, int offset, int length, int totalLength, GetNextNode getNextNode, BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, PRaiseNode.Lazy raiseNode) {
        CompilerAsserts.partialEvaluationConstant((int)length);
        int stackTop = initialStackTop;
        for (int i = 0; i < length; ++i) {
            try {
                Object item = getNextNode.execute((Frame)frame, iterator);
                frame.setObject(stackTop--, item);
                continue;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, stopIterationProfile);
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK_EX, totalLength, offset + i);
            }
        }
        return stackTop;
    }

    @ExplodeLoop
    private static int moveItemsToStack(VirtualFrame frame, Node inliningTarget, SequenceStorage storage, int initialStackTop, int offset, int length, SequenceStorageNodes.GetItemScalarNode getItemNode) {
        CompilerAsserts.partialEvaluationConstant((int)length);
        int stackTop = initialStackTop;
        for (int i = 0; i < length; ++i) {
            frame.setObject(stackTop--, getItemNode.execute(inliningTarget, storage, offset + i));
        }
        return stackTop;
    }

    public static UnpackExNode create() {
        return UnpackExNodeGen.create();
    }

    public static UnpackExNode getUncached() {
        return UnpackExNodeGen.getUncached();
    }
}

