/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntToBooleanConverterNodeGen;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class JavaIntToBooleanConverterNode
extends ArgumentCastNode {
    protected final boolean defaultValue;
    protected final boolean useDefaultForNone;

    protected JavaIntToBooleanConverterNode(boolean defaultValue, boolean useDefaultForNone) {
        this.defaultValue = defaultValue;
        this.useDefaultForNone = useDefaultForNone;
    }

    @Specialization(guards={"!useDefaultForNone", "isNoValue(none)"})
    boolean doNoValue(PNone none) {
        return this.defaultValue;
    }

    @Specialization(guards={"!useDefaultForNone", "isNone(none)"})
    static boolean doNone(PNone none) {
        return false;
    }

    @Specialization(guards={"useDefaultForNone"})
    boolean doNoValueAndNone(PNone none) {
        return this.defaultValue;
    }

    @Specialization
    static boolean doBoolean(boolean b) {
        return b;
    }

    @Specialization
    static boolean doInt(int i) {
        return i != 0;
    }

    @Specialization
    static boolean doLong(long i) {
        return i != 0L;
    }

    @Specialization(guards={"!isNoValue(value)"})
    static Object doOthers(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyLongAsIntNode asIntNode) {
        return asIntNode.execute((Frame)frame, inliningTarget, value) != 0;
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Boolean})
    @NeverDefault
    public static JavaIntToBooleanConverterNode create(@ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone, @ClinicConverterFactory.DefaultValue boolean defaultValue) {
        if (!defaultValue) {
            return JavaIntToBooleanConverterNodeGen.create(false, true);
        }
        return JavaIntToBooleanConverterNodeGen.create(defaultValue, useDefaultForNone);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Boolean})
    @NeverDefault
    public static JavaIntToBooleanConverterNode create(@ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        assert (!useDefaultForNone) : "defaultValue must be provided if useDefaultForNone is true";
        return JavaIntToBooleanConverterNode.create(false, false);
    }
}

