/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeine;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jim.common.cache.caffeine.CaffeineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)CaffeineConfigurationFactory.class.getName());
    private static final String DEFAULT_CLASSPATH_CONFIGURATION_FILE = "caffeine.properties";

    private CaffeineConfigurationFactory() {
    }

    public static List<CaffeineConfiguration> parseConfiguration(File file) throws Exception {
        if (file == null) {
            throw new Exception("Attempt to configure caffeine from null file.");
        }
        LOG.debug("Configuring caffeine from file: {}", (Object)file);
        List<CaffeineConfiguration> configurations = null;
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            configurations = CaffeineConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new Exception("Error configuring from " + file + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.error("IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configurations;
    }

    public static List<CaffeineConfiguration> parseConfiguration(URL url) throws Exception {
        List<CaffeineConfiguration> configurations;
        LOG.debug("Configuring caffeine from URL: {}", (Object)url);
        InputStream input = null;
        try {
            input = url.openStream();
            configurations = CaffeineConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new Exception("Error configuring from " + url + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.error("IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configurations;
    }

    public static List<CaffeineConfiguration> parseConfiguration() throws Exception {
        ClassLoader standardClassloader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url == null) {
            url = CaffeineConfigurationFactory.class.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url != null) {
            LOG.debug("Configuring caffeine from caffeine.properties found in the classpath: " + url);
        } else {
            LOG.warn("No configuration found. Configuring caffeine from caffeine.properties  found in the classpath: {}", (Object)url);
        }
        List<CaffeineConfiguration> configurations = CaffeineConfigurationFactory.parseConfiguration(url);
        return configurations;
    }

    public static List<CaffeineConfiguration> parseConfiguration(InputStream inputStream) throws Exception {
        LOG.debug("Configuring caffeine from InputStream");
        ArrayList<CaffeineConfiguration> configurations = new ArrayList<CaffeineConfiguration>();
        try {
            Properties props = new Properties();
            props.load(inputStream);
            for (String key : props.stringPropertyNames()) {
                configurations.add(new CaffeineConfiguration(key, props));
            }
        }
        catch (Exception e) {
            throw new Exception("Error configuring from input stream. Initial cause was " + e.getMessage(), e);
        }
        return configurations;
    }
}

