/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeineredis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jim.common.cache.caffeine.CaffeineCache;
import org.jim.common.cache.caffeine.CaffeineCacheManager;
import org.jim.common.cache.caffeine.CaffeineConfiguration;
import org.jim.common.cache.caffeine.CaffeineConfigurationFactory;
import org.jim.common.cache.caffeineredis.CaffeineRedisCache;
import org.jim.common.cache.caffeineredis.RedisAsyncRunnable;
import org.jim.common.cache.redis.RedisCache;
import org.jim.common.cache.redis.RedisCacheManager;
import org.jim.common.cache.redis.SubRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineRedisCacheManager {
    private static Logger log = LoggerFactory.getLogger(CaffeineRedisCacheManager.class);
    private static Map<String, CaffeineRedisCache> map = new HashMap<String, CaffeineRedisCache>();
    private static boolean inited = false;
    public static final String CACHE_CHANGE_TOPIC = "REDIS_CACHE_CHANGE_TOPIC_CAFFEINE";
    private static RedisAsyncRunnable asyncRedisQueue = new RedisAsyncRunnable();
    public static int MAX_EXPIRE_IN_LOCAL = 1800;

    private CaffeineRedisCacheManager() {
    }

    public static CaffeineRedisCache getCache(String cacheName) {
        CaffeineRedisCache caffeineRedisCache = map.get(cacheName);
        if (caffeineRedisCache == null) {
            log.warn("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)CaffeineRedisCache.class.getSimpleName());
        }
        return caffeineRedisCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (inited) return;
        Class<CaffeineRedisCacheManager> clazz = CaffeineRedisCacheManager.class;
        synchronized (CaffeineRedisCacheManager.class) {
            if (inited) return;
            new Thread(new SubRunnable(CACHE_CHANGE_TOPIC)).start();
            new Thread(asyncRedisQueue).start();
            inited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaffeineRedisCache register(String cacheName, Integer timeToLiveSeconds, Integer timeToIdleSeconds) {
        CaffeineRedisCacheManager.init();
        CaffeineRedisCache caffeineRedisCache = map.get(cacheName);
        if (caffeineRedisCache != null) return caffeineRedisCache;
        Class<CaffeineRedisCacheManager> clazz = CaffeineRedisCacheManager.class;
        synchronized (CaffeineRedisCacheManager.class) {
            caffeineRedisCache = map.get(cacheName);
            if (caffeineRedisCache != null) return caffeineRedisCache;
            RedisCache redisCache = RedisCacheManager.register(cacheName, timeToLiveSeconds, timeToIdleSeconds);
            Integer timeToLiveSecondsForCaffeine = timeToLiveSeconds;
            Integer timeToIdleSecondsForCaffeine = timeToIdleSeconds;
            if (timeToLiveSecondsForCaffeine != null) {
                timeToLiveSecondsForCaffeine = Math.min(timeToLiveSecondsForCaffeine, MAX_EXPIRE_IN_LOCAL);
            }
            if (timeToIdleSecondsForCaffeine != null) {
                timeToIdleSecondsForCaffeine = Math.min(timeToIdleSecondsForCaffeine, MAX_EXPIRE_IN_LOCAL);
            }
            CaffeineCache caffeineCache = CaffeineCacheManager.register(cacheName, timeToLiveSecondsForCaffeine, timeToIdleSecondsForCaffeine);
            caffeineRedisCache = new CaffeineRedisCache(cacheName, caffeineCache, redisCache);
            map.put(cacheName, caffeineRedisCache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return caffeineRedisCache;
        }
    }

    public static RedisAsyncRunnable getAsyncRedisQueue() {
        return asyncRedisQueue;
    }

    static {
        try {
            List<CaffeineConfiguration> configurations = CaffeineConfigurationFactory.parseConfiguration();
            for (CaffeineConfiguration configuration : configurations) {
                CaffeineRedisCacheManager.register(configuration.getCacheName(), configuration.getTimeToLiveSeconds(), configuration.getTimeToIdleSeconds());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

