/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.caffeineredis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.jim.common.cache.CacheChangeType;
import org.jim.common.cache.CacheChangedVo;
import org.jim.common.cache.caffeineredis.RedisL2Vo;
import org.jim.common.cache.redis.JedisTemplate;
import org.jim.common.cache.redis.RedisCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisAsyncRunnable
implements Runnable {
    private LinkedBlockingQueue<RedisL2Vo> redisL2VoQueue = new LinkedBlockingQueue();
    private static boolean started = false;
    private Logger LOG = LoggerFactory.getLogger(RedisAsyncRunnable.class);

    public void add(RedisL2Vo redisL2Vo) {
        this.redisL2VoQueue.offer(redisL2Vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (started) {
            return;
        }
        Class<RedisAsyncRunnable> clazz = RedisAsyncRunnable.class;
        synchronized (RedisAsyncRunnable.class) {
            if (started) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            started = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            HashMap pairMap = new HashMap();
            ArrayList<String> cacheChangeVos = new ArrayList<String>();
            int count = 0;
            block7: while (true) {
                try {
                    while (true) {
                        RedisL2Vo redisL2Vo;
                        if ((redisL2Vo = this.redisL2VoQueue.poll()) != null) {
                            String cacheName = redisL2Vo.getRedisCache().getCacheName();
                            if (pairMap.get(cacheName) == null) {
                                ArrayList pairDatas = new ArrayList();
                                pairMap.put(cacheName, pairDatas);
                            }
                            ((List)pairMap.get(cacheName)).add(JedisTemplate.me().makePair(redisL2Vo.getKey(), redisL2Vo.getValue()));
                            cacheChangeVos.add(new CacheChangedVo(redisL2Vo.getRedisCache().getCacheName(), redisL2Vo.getKey(), CacheChangeType.PUT).toString());
                            ++count;
                        }
                        if (count > 0 && redisL2Vo == null) {
                            for (String cacheName : pairMap.keySet()) {
                                RedisCacheManager.getCache(cacheName).putAll((List)pairMap.get(cacheName));
                            }
                            JedisTemplate.me().publishAll("REDIS_CACHE_CHANGE_TOPIC_CAFFEINE", cacheChangeVos);
                            pairMap.clear();
                            cacheChangeVos.clear();
                            count = 0;
                            continue;
                        }
                        if (count != 0 || redisL2Vo != null) continue;
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            continue block7;
                        }
                        catch (InterruptedException e) {
                            this.LOG.error(e.toString(), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.LOG.error(e.toString(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

