/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jim.common.cache.redis.RedisConfiguration;
import org.jim.common.cache.redis.RedisConfigurationFactory;
import org.jim.common.cache.redis.RedisLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

public class JedisTemplate
implements Serializable {
    private static final long serialVersionUID = 9135301078135982677L;
    private static final Logger logger = LoggerFactory.getLogger(JedisTemplate.class);
    private static JedisTemplate instance = null;
    private static JedisPool jedisPool = null;
    private static Jedis jedis = null;
    private static RedisConfiguration redisConfig = null;

    private JedisTemplate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JedisTemplate me() throws Exception {
        if (instance != null) return instance;
        Class<JedisTemplate> clazz = JedisTemplate.class;
        synchronized (JedisTemplate.class) {
            if (instance != null) return instance;
            redisConfig = RedisConfigurationFactory.parseConfiguration();
            JedisTemplate.init();
            instance = new JedisTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static final void init() throws Exception {
        if (redisConfig.getHost() == null) {
            logger.error("the server ip of redis  must be not null!");
            throw new Exception("the server ip of redis  must be not null!");
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(redisConfig.getMaxActive());
        poolConfig.setMaxIdle(redisConfig.getMaxIdle());
        poolConfig.setMaxWaitMillis(redisConfig.getMaxWait());
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        try {
            jedisPool = StringUtils.isEmpty((CharSequence)redisConfig.getAuth()) ? new JedisPool((GenericObjectPoolConfig)poolConfig, redisConfig.getHost(), redisConfig.getPort(), redisConfig.getTimeout()) : new JedisPool((GenericObjectPoolConfig)poolConfig, redisConfig.getHost(), redisConfig.getPort(), redisConfig.getTimeout(), redisConfig.getAuth());
        }
        catch (Exception e) {
            logger.error("cann't create JedisPool for server" + redisConfig.getHost());
            throw new Exception("cann't create JedisPool for server" + redisConfig.getHost());
        }
    }

    public JedisPool getDefaultPool() {
        return jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Jedis getSingletonJedis() {
        if (jedis != null) return jedis;
        Class<JedisTemplate> clazz = JedisTemplate.class;
        synchronized (JedisTemplate.class) {
            if (jedis != null) return jedis;
            jedis = this.getJedis();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jedis;
        }
    }

    public Jedis getJedis() {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (jedis != null) {
                jedisPool.returnBrokenResource(jedis);
            }
        }
        if (jedis != null) {
            return jedis;
        }
        int count = 0;
        while ((jedis = jedisPool.getResource()) == null && ++count < redisConfig.getRetryNum()) {
        }
        return jedis;
    }

    public void close(Jedis jedis) {
        if (jedis != null) {
            jedisPool.returnResource(jedis);
        }
    }

    public Set<String> keys(final String likeKey) {
        return (Set)new Executor<Set<String>>(jedisPool){

            @Override
            Set<String> execute() {
                Set keys = this.jedis.keys(likeKey + "*");
                return keys;
            }
        }.getResult();
    }

    public long delKeysLike(final String likeKey) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                Set keys = this.jedis.keys(likeKey + "*");
                return this.jedis.del(keys.toArray(new String[keys.size()]));
            }
        }.getResult();
    }

    public Long delKey(final String key) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.del(key);
            }
        }.getResult();
    }

    public Long delKeys(final String[] keys) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.del(keys);
            }
        }.getResult();
    }

    public Long expire(final String key, final int expire) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.expire(key, expire);
            }
        }.getResult();
    }

    public long makeId(final String key) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                long id = this.jedis.incr(key);
                if (id + 75807L >= Long.MAX_VALUE) {
                    this.jedis.getSet(key, "0");
                }
                return id;
            }
        }.getResult();
    }

    public long decr(final String key, final long increment) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.decrBy(key, increment);
            }
        }.getResult();
    }

    public long incr(final String key, final long increment) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.incrBy(key, increment);
            }
        }.getResult();
    }

    public String setString(final String key, final String value) {
        return (String)new Executor<String>(jedisPool){

            @Override
            String execute() {
                return this.jedis.set(key, value);
            }
        }.getResult();
    }

    public boolean setString2Boolean(final String key, final String value, final int expire) {
        return (Boolean)new Executor<Boolean>(jedisPool){

            @Override
            Boolean execute() {
                this.jedis.setex(key, expire, value);
                return true;
            }
        }.getResult();
    }

    public String setString(final String key, final String value, final int expire) {
        return (String)new Executor<String>(jedisPool){

            @Override
            String execute() {
                return this.jedis.setex(key, expire, value);
            }
        }.getResult();
    }

    public Long setStringIfNotExists(final String key, final String value) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.setnx(key, value);
            }
        }.getResult();
    }

    public boolean setStringIfNotExists(final String key, final String value, final int timeout) {
        return (Boolean)new Executor<Boolean>(jedisPool){

            @Override
            Boolean execute() {
                Boolean result = this.jedis.setnx(key, value) == 1L;
                if (result.booleanValue()) {
                    this.jedis.expire(key, timeout);
                }
                return result;
            }
        }.getResult();
    }

    public String getString(final String key) {
        return (String)new Executor<String>(jedisPool){

            @Override
            String execute() {
                return this.jedis.get(key);
            }
        }.getResult();
    }

    public List<Object> batchSetString(final List<Pair<String, String>> pairs) {
        return (List)new Executor<List<Object>>(jedisPool){

            @Override
            List<Object> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.set((String)pair.getKey(), (String)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<Object> batchSetStringEx(final List<PairEx<String, String, Integer>> pairs) {
        return (List)new Executor<List<Object>>(jedisPool){

            @Override
            List<Object> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (PairEx pair : pairs) {
                    pipeline.setex((String)pair.getKey(), ((Integer)pair.getExpire()).intValue(), (String)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<String> batchGetString(final String[] keys) {
        return (List)new Executor<List<String>>(jedisPool){

            @Override
            List<String> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                ArrayList<String> result = new ArrayList<String>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.get(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((String)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Long hashSet(final String key, final String field, final String value) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.hset(key, field, value);
            }
        }.getResult();
    }

    public Long hashSet(final String key, final String field, final String value, final int expire) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hset(key, field, value);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public String hashGet(final String key, final String field) {
        return (String)new Executor<String>(jedisPool){

            @Override
            String execute() {
                return this.jedis.hget(key, field);
            }
        }.getResult();
    }

    public String hashGet(final String key, final String field, final int expire) {
        return (String)new Executor<String>(jedisPool){

            @Override
            String execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hget(key, field);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public String hashMultipleSet(final String key, final Map<String, String> hash) {
        return (String)new Executor<String>(jedisPool){

            @Override
            String execute() {
                return this.jedis.hmset(key, hash);
            }
        }.getResult();
    }

    public String hashMultipleSet(final String key, final Map<String, String> hash, final int expire) {
        return (String)new Executor<String>(jedisPool){

            @Override
            String execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hmset(key, hash);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (String)result.get();
            }
        }.getResult();
    }

    public List<String> hashMultipleGet(final String key, final String ... fields) {
        return (List)new Executor<List<String>>(jedisPool){

            @Override
            List<String> execute() {
                return this.jedis.hmget(key, fields);
            }
        }.getResult();
    }

    public List<String> hashMultipleGet(final String key, final int expire, final String ... fields) {
        return (List)new Executor<List<String>>(jedisPool){

            @Override
            List<String> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hmget(key, fields);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (List)result.get();
            }
        }.getResult();
    }

    public List<Object> batchHashMultipleSet(final List<Pair<String, Map<String, String>>> pairs) {
        return (List)new Executor<List<Object>>(jedisPool){

            @Override
            List<Object> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (Pair pair : pairs) {
                    pipeline.hmset((String)pair.getKey(), (Map)pair.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<Object> batchHashMultipleSet(final Map<String, Map<String, String>> data) {
        return (List)new Executor<List<Object>>(jedisPool){

            @Override
            List<Object> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (Map.Entry iter : data.entrySet()) {
                    pipeline.hmset((String)iter.getKey(), (Map)iter.getValue());
                }
                return pipeline.syncAndReturnAll();
            }
        }.getResult();
    }

    public List<List<String>> batchHashMultipleGet(final List<Pair<String, String[]>> pairs) {
        return (List)new Executor<List<List<String>>>(jedisPool){

            @Override
            List<List<String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                ArrayList<List<String>> result = new ArrayList<List<String>>(pairs.size());
                ArrayList<Response> responses = new ArrayList<Response>(pairs.size());
                for (Pair pair : pairs) {
                    responses.add(pipeline.hmget((String)pair.getKey(), (String[])pair.getValue()));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((List<String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Map<String, String> hashGetAll(final String key) {
        return (Map)new Executor<Map<String, String>>(jedisPool){

            @Override
            Map<String, String> execute() {
                return this.jedis.hgetAll(key);
            }
        }.getResult();
    }

    public void batchSetExpire(final List<PairEx<String, Void, Integer>> pairDatas) {
        if (pairDatas == null || pairDatas.size() == 0) {
            return;
        }
        new Executor<Void>(jedisPool){

            @Override
            Void execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (PairEx pairEx : pairDatas) {
                    pipeline.expire((String)pairEx.getKey(), ((Integer)pairEx.getExpire()).intValue());
                }
                pipeline.sync();
                return null;
            }
        }.getResult();
    }

    public Map<String, String> hashGetAll(final String key, final int expire) {
        return (Map)new Executor<Map<String, String>>(jedisPool){

            @Override
            Map<String, String> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.hgetAll(key);
                pipeline.expire(key, expire);
                pipeline.sync();
                return (Map)result.get();
            }
        }.getResult();
    }

    public List<Map<String, String>> batchHashGetAll(final String ... keys) {
        return (List)new Executor<List<Map<String, String>>>(jedisPool){

            @Override
            List<Map<String, String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(keys.length);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (Response resp : responses) {
                    result.add((Map<String, String>)resp.get());
                }
                return result;
            }
        }.getResult();
    }

    public Map<String, Map<String, String>> batchHashGetAllForMap(final String ... keys) {
        return (Map)new Executor<Map<String, Map<String, String>>>(jedisPool){

            @Override
            Map<String, Map<String, String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                int capacity = 1;
                while ((int)((double)capacity * 0.75) <= keys.length) {
                    capacity <<= 1;
                }
                HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(capacity);
                ArrayList<Response> responses = new ArrayList<Response>(keys.length);
                for (String key : keys) {
                    responses.add(pipeline.hgetAll(key));
                }
                pipeline.sync();
                for (int i = 0; i < keys.length; ++i) {
                    result.put(keys[i], (Map<String, String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public Long hashDel(final String key, final String[] fields) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.hdel(key, fields);
            }
        }.getResult();
    }

    public Long listPushTail(final String key, final String ... values) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.rpush(key, values);
            }
        }.getResult();
    }

    public Long listPushHead(final String key, final String value) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.lpush(key, new String[]{value});
            }
        }.getResult();
    }

    public Long listRemove(final String key, final int count, final String value) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.lrem(key, (long)count, value);
            }
        }.getResult();
    }

    public Long listPushHeadAndTrim(final String key, final String value, final long size) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                Pipeline pipeline = this.jedis.pipelined();
                Response result = pipeline.lpush(key, new String[]{value});
                pipeline.ltrim(key, 0L, size - 1L);
                pipeline.sync();
                return (Long)result.get();
            }
        }.getResult();
    }

    public void batchListPushTail(final String key, final String[] values, final boolean delOld) {
        new Executor<Object>(jedisPool){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Object execute() {
                if (delOld) {
                    RedisLock lock = new RedisLock(key, this.jedisPool);
                    lock.lock();
                    try {
                        Pipeline pipeline = this.jedis.pipelined();
                        pipeline.del(key);
                        for (String value : values) {
                            pipeline.rpush(key, new String[]{value});
                        }
                        pipeline.sync();
                    }
                    finally {
                        lock.unlock();
                    }
                } else {
                    Pipeline pipeline = this.jedis.pipelined();
                    for (String value : values) {
                        pipeline.rpush(key, new String[]{value});
                    }
                    pipeline.sync();
                }
                return null;
            }
        }.getResult();
    }

    public Object updateListInTransaction(final String key, final List<String> values) {
        return new Executor<Object>(jedisPool){

            @Override
            Object execute() {
                Transaction transaction = this.jedis.multi();
                transaction.del(key);
                for (String value : values) {
                    transaction.rpush(key, new String[]{value});
                }
                transaction.exec();
                return null;
            }
        }.getResult();
    }

    public Long insertListIfNotExists(final String key, final String[] values) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                RedisLock lock = new RedisLock(key, this.jedisPool);
                lock.lock();
                try {
                    if (!this.jedis.exists(key).booleanValue()) {
                        Long l = this.jedis.rpush(key, values);
                        return l;
                    }
                }
                finally {
                    lock.unlock();
                }
                return 0L;
            }
        }.getResult();
    }

    public List<String> listGetAll(final String key) {
        return (List)new Executor<List<String>>(jedisPool){

            @Override
            List<String> execute() {
                return this.jedis.lrange(key, 0L, -1L);
            }
        }.getResult();
    }

    public List<String> listRange(final String key, final long beginIndex, final long endIndex) {
        return (List)new Executor<List<String>>(jedisPool){

            @Override
            List<String> execute() {
                return this.jedis.lrange(key, beginIndex, endIndex - 1L);
            }
        }.getResult();
    }

    public Map<String, List<String>> batchGetAllList(final List<String> keys) {
        return (Map)new Executor<Map<String, List<String>>>(jedisPool){

            @Override
            Map<String, List<String>> execute() {
                Pipeline pipeline = this.jedis.pipelined();
                HashMap<String, List<String>> result = new HashMap<String, List<String>>();
                ArrayList<Response> responses = new ArrayList<Response>(keys.size());
                for (String key : keys) {
                    responses.add(pipeline.lrange(key, 0L, -1L));
                }
                pipeline.sync();
                for (int i = 0; i < keys.size(); ++i) {
                    result.put((String)keys.get(i), (List<String>)((Response)responses.get(i)).get());
                }
                return result;
            }
        }.getResult();
    }

    public Long sortSetPush(final String key, final double score, final String value) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.zadd(key, score, value);
            }
        }.getResult();
    }

    public Set<String> sorSetRangeByScore(final String key, final double min, final double max) {
        return (Set)new Executor<Set<String>>(jedisPool){

            @Override
            Set<String> execute() {
                return this.jedis.zrangeByScore(key, min, max);
            }
        }.getResult();
    }

    public Set<String> sorSetRangeByScore(final String key, final double min, final double max, final int offset, final int count) {
        return (Set)new Executor<Set<String>>(jedisPool){

            @Override
            Set<String> execute() {
                return this.jedis.zrangeByScore(key, min, max, offset, count);
            }
        }.getResult();
    }

    public Long publish(final String channel, final String message) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.publish(channel, message);
            }
        }.getResult();
    }

    public void publishAll(final String channel, final List<String> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        new Executor<Void>(jedisPool){

            @Override
            Void execute() {
                Pipeline pipeline = this.jedis.pipelined();
                for (String message : messages) {
                    pipeline.publish(channel, message);
                }
                pipeline.sync();
                return null;
            }
        }.getResult();
    }

    public void subscribe(final JedisPubSub jedisPubSub, final String channel) {
        new Executor<Object>(jedisPool){

            @Override
            Object execute() {
                this.jedis.subscribe(jedisPubSub, new String[]{channel});
                return null;
            }
        }.getResult();
    }

    public void unSubscribe(JedisPubSub jedisPubSub) {
        jedisPubSub.unsubscribe();
    }

    public Long addWithSortedSet(final String key, final double score, final String member) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.zadd(key, score, member);
            }
        }.getResult();
    }

    public Long addWithSortedSet(final String key, final Map<String, Double> scoreMembers) {
        return (Long)new Executor<Long>(jedisPool){

            @Override
            Long execute() {
                return this.jedis.zadd(key, scoreMembers);
            }
        }.getResult();
    }

    public Set<String> revrangeByScoreWithSortedSet(final String key, final double max, final double min) {
        return (Set)new Executor<Set<String>>(jedisPool){

            @Override
            Set<String> execute() {
                return this.jedis.zrevrangeByScore(key, max, min);
            }
        }.getResult();
    }

    public <K, V> Pair<K, V> makePair(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public <K, V, E> PairEx<K, V, E> makePairEx(K key, V value, E expire) {
        return new PairEx<K, V, E>(key, value, expire);
    }

    public Object set(final String key, final Object value) {
        return new Executor<Object>(jedisPool){

            @Override
            Object execute() {
                String objectJson = JSON.toJSONString((Object)value);
                return this.jedis.set(key, objectJson);
            }
        }.getResult();
    }

    public Object set(final String key, final Object value, final int expire) {
        return new Executor<Object>(jedisPool){

            @Override
            Object execute() {
                String objectJson = JSON.toJSONString((Object)value);
                return this.jedis.setex(key, expire, objectJson);
            }
        }.getResult();
    }

    public <T> T get(final String key, final Class<T> clazz) {
        return new Executor<T>(jedisPool){

            @Override
            T execute() {
                String json = this.jedis.get(key);
                return JSON.parseObject((String)json, (Class)clazz);
            }
        }.getResult();
    }

    public class PairEx<K, V, E>
    extends Pair<K, V> {
        private E expire;

        public PairEx(K key, V value) {
            super(key, value);
        }

        public PairEx(K key, V value, E expire) {
            super(key, value);
            this.expire = expire;
        }

        public E getExpire() {
            return this.expire;
        }

        public void setExpire(E expire) {
            this.expire = expire;
        }
    }

    public class Pair<K, V> {
        private K key;
        private V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            this.key = key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }

    abstract class Executor<T> {
        Jedis jedis;
        JedisPool jedisPool;

        public Executor(JedisPool jedisPool) {
            this.jedisPool = jedisPool;
            this.jedis = JedisTemplate.this.getJedis();
        }

        abstract T execute();

        public T getResult() {
            T result = null;
            try {
                result = this.execute();
            }
            catch (Throwable e) {
                throw new RuntimeException("Redis execute exception", e);
            }
            finally {
                if (this.jedis != null) {
                    this.jedisPool.returnResource(this.jedis);
                }
            }
            return result;
        }
    }
}

