/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import java.util.HashMap;
import java.util.Map;
import org.jim.common.cache.redis.RedisCache;
import org.jim.common.cache.redis.RedisExpireUpdateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheManager {
    private static Logger log = LoggerFactory.getLogger(RedisCache.class);
    private static Map<String, RedisCache> map = new HashMap<String, RedisCache>();

    public static RedisCache getCache(String cacheName) {
        RedisCache redisCache = map.get(cacheName);
        if (redisCache == null) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)RedisCache.class.getSimpleName());
        }
        return redisCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisCache register(String cacheName, Integer timeToLiveSeconds, Integer timeToIdleSeconds) {
        RedisExpireUpdateTask.start();
        RedisCache redisCache = map.get(cacheName);
        if (redisCache != null) return redisCache;
        Class<RedisCacheManager> clazz = RedisCacheManager.class;
        synchronized (RedisCacheManager.class) {
            redisCache = map.get(cacheName);
            if (redisCache != null) return redisCache;
            redisCache = new RedisCache(cacheName, timeToLiveSeconds, timeToIdleSeconds);
            map.put(cacheName, redisCache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return redisCache;
        }
    }
}

