/*
 * Decompiled with CFR 0.152.
 */
package org.jim.common.cache.redis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.jim.common.ImAio;
import org.jim.common.cache.redis.RedisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)RedisConfigurationFactory.class.getName());
    private static final String DEFAULT_CLASSPATH_CONFIGURATION_FILE = "jim.properties";

    private RedisConfigurationFactory() {
    }

    public static RedisConfiguration parseConfiguration(File file) throws Exception {
        if (file == null) {
            throw new Exception("Attempt to configure redis from null file.");
        }
        LOG.debug("Configuring redis from file: {}", (Object)file);
        RedisConfiguration configuration = null;
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            configuration = RedisConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new Exception("Error configuring from " + file + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.error("IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configuration;
    }

    public static RedisConfiguration parseConfiguration(URL url) throws Exception {
        RedisConfiguration configuration;
        LOG.debug("Configuring redis from URL: {}", (Object)url);
        InputStream input = null;
        try {
            input = url.openStream();
            configuration = RedisConfigurationFactory.parseConfiguration(input);
        }
        catch (Exception e) {
            throw new Exception("Error configuring from " + url + ". Initial cause was " + e.getMessage(), e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                LOG.error("IOException while closing configuration input stream. Error was " + e.getMessage());
            }
        }
        return configuration;
    }

    public static RedisConfiguration parseConfiguration() throws Exception {
        ClassLoader standardClassloader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        if (standardClassloader != null) {
            url = standardClassloader.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url == null) {
            url = ImAio.class.getResource(DEFAULT_CLASSPATH_CONFIGURATION_FILE);
        }
        if (url != null) {
            LOG.debug("Configuring redis from jim.properties found in the classpath: " + url);
        } else {
            LOG.warn("No configuration found. Configuring redis from jim.properties  found in the classpath: {}", (Object)url);
        }
        RedisConfiguration configuration = RedisConfigurationFactory.parseConfiguration(url);
        return configuration;
    }

    public static RedisConfiguration parseConfiguration(InputStream inputStream) throws Exception {
        LOG.debug("Configuring redis from InputStream");
        RedisConfiguration configuration = null;
        try {
            Properties prop = new Properties();
            prop.load(inputStream);
            configuration = new RedisConfiguration(prop);
        }
        catch (Exception e) {
            throw new Exception("Error configuring from input stream. Initial cause was " + e.getMessage(), e);
        }
        return configuration;
    }

    public static void main(String[] args) throws Exception {
        RedisConfigurationFactory.parseConfiguration();
    }
}

